/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.StringKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.startup.GradleUnlinkedProjectProcessor;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0014J$\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J&\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J*\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\n\u0010 \u001a\u0004\u0018\u00010\fH\u0002J(\u0010!\u001a\u00020\u0004*\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\f\u0010\u001c\u001a\u00020\u0004*\u00020\"H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/open/GradleOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "()V", "attachGradleProjectAndRefresh", "", "settings", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "createFinalImportCallback", "Lcom/intellij/openapi/externalSystem/service/project/ExternalProjectRefreshCallback;", "externalProjectPath", "", "importData", "externalProject", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "isProjectFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "linkAndRefreshProject", "projectDirectory", "openProject", "projectFile", "projectToClose", "forceOpenInNewFrame", "selectDataToImport", "setupGradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "projectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "suggestGradleHome", "setupGradleProjectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "intellij.gradle.common"})
public final class GradleOpenProjectProvider
extends AbstractOpenProjectProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isProjectFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) return false;
        Intrinsics.checkExpressionValueIsNotNull((Object)GradleConstants.BUILD_FILE_EXTENSIONS, (String)"BUILD_FILE_EXTENSIONS");
        String[] $this$any$iv = GradleConstants.BUILD_FILE_EXTENSIONS;
        boolean $i$f$any = false;
        String[] stringArray = $this$any$iv;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element$iv;
            String it = element$iv = stringArray[n2];
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            String string2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            if (StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void linkAndRefreshProject(@NotNull String projectDirectory, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        Sdk projectSdk2 = projectRootManager.getProjectSdk();
        GradleProjectSettings gradleProjectSettings = new GradleProjectSettings();
        this.setupGradleSettings(gradleProjectSettings, projectDirectory, project, projectSdk2);
        this.attachGradleProjectAndRefresh(gradleProjectSettings, project);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile projectFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        Project project = super.openProject(projectFile, projectToClose, forceOpenInNewFrame);
        if (project != null) {
            GradleUnlinkedProjectProcessor.Companion.enableNotifications(project);
        }
        return project;
    }

    private final void attachGradleProjectAndRefresh(ExternalProjectSettings settings, Project project) {
        String externalProjectPath = settings.getExternalProjectPath();
        ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                ExternalSystemUtil.ensureToolWindowInitialized((Project)this.$project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            }
            {
                this.$project = project;
            }
        });
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject(settings);
        ExternalSystemUtil.refreshProject((String)externalProjectPath, (ImportSpecBuilder)new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).usePreviewMode().use(ProgressExecutionMode.MODAL_SYNC));
        ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
        String string = externalProjectPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"externalProjectPath");
        ExternalSystemUtil.refreshProject((String)externalProjectPath, (ImportSpecBuilder)importSpecBuilder.callback(this.createFinalImportCallback(project, string)));
    }

    public final void setupGradleSettings(@NotNull GradleProjectSettings settings, @NotNull String projectDirectory, @NotNull Project project, @Nullable Sdk projectSdk2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)settings), (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        this.setupGradleSettings(gradleSettings);
        this.setupGradleProjectSettings(settings, projectDirectory, project, projectSdk2);
    }

    public static /* synthetic */ void setupGradleSettings$default(GradleOpenProjectProvider gradleOpenProjectProvider, GradleProjectSettings gradleProjectSettings, String string, Project project, Sdk sdk, int n, Object object) {
        if ((n & 8) != 0) {
            sdk = null;
        }
        gradleOpenProjectProvider.setupGradleSettings(gradleProjectSettings, string, project, sdk);
    }

    private final void setupGradleSettings(@NotNull GradleSettings $this$setupGradleSettings) {
        boolean bl;
        String string = GradleEnvironment.Headless.GRADLE_VM_OPTIONS;
        if (string == null) {
            string = $this$setupGradleSettings.getGradleVmOptions();
        }
        $this$setupGradleSettings.setGradleVmOptions(string);
        GradleSettings gradleSettings = $this$setupGradleSettings;
        String string2 = GradleEnvironment.Headless.GRADLE_OFFLINE;
        if (string2 != null) {
            String string3 = string2;
            GradleSettings gradleSettings2 = gradleSettings;
            boolean bl2 = false;
            boolean bl3 = Boolean.parseBoolean(string3);
            gradleSettings = gradleSettings2;
            bl = bl3;
        } else {
            bl = $this$setupGradleSettings.isOfflineWork();
        }
        gradleSettings.setOfflineWork(bl);
        String string4 = GradleEnvironment.Headless.GRADLE_SERVICE_DIRECTORY;
        if (string4 == null) {
            string4 = $this$setupGradleSettings.getServiceDirectoryPath();
        }
        $this$setupGradleSettings.setServiceDirectoryPath(string4);
        $this$setupGradleSettings.setStoreProjectFilesExternally(true);
    }

    private final void setupGradleProjectSettings(@NotNull GradleProjectSettings $this$setupGradleProjectSettings, String projectDirectory, Project project, Sdk projectSdk2) {
        Object object;
        GradleProjectSettings gradleProjectSettings;
        block5: {
            block4: {
                $this$setupGradleProjectSettings.setExternalProjectPath(projectDirectory);
                $this$setupGradleProjectSettings.setUseQualifiedModuleNames(true);
                gradleProjectSettings = $this$setupGradleProjectSettings;
                object = GradleEnvironment.Headless.GRADLE_DISTRIBUTION_TYPE;
                if (object == null) break block4;
                String string = object;
                GradleProjectSettings gradleProjectSettings2 = gradleProjectSettings;
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string;
                boolean bl3 = false;
                DistributionType distributionType = DistributionType.valueOf(p1);
                gradleProjectSettings = gradleProjectSettings2;
                object = distributionType;
                if (object != null) break block5;
            }
            object = DistributionType.DEFAULT_WRAPPED;
        }
        gradleProjectSettings.setDistributionType((DistributionType)((Object)object));
        String string = GradleEnvironment.Headless.GRADLE_HOME;
        if (string == null) {
            string = this.suggestGradleHome();
        }
        $this$setupGradleProjectSettings.setGradleHome(string);
        GradleVersion gradleVersion = $this$setupGradleProjectSettings.resolveGradleVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"resolveGradleVersion()");
        $this$setupGradleProjectSettings.setGradleJvm(GradleJvmResolutionUtil.suggestGradleJvm(project, projectSdk2, projectDirectory, gradleVersion));
    }

    static /* synthetic */ void setupGradleProjectSettings$default(GradleOpenProjectProvider gradleOpenProjectProvider, GradleProjectSettings gradleProjectSettings, String string, Project project, Sdk sdk, int n, Object object) {
        if ((n & 4) != 0) {
            sdk = null;
        }
        gradleOpenProjectProvider.setupGradleProjectSettings(gradleProjectSettings, string, project, sdk);
    }

    private final String suggestGradleHome() {
        GradleInstallationManager installationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
        String lastUsedGradleHome = StringKt.nullize$default((String)GradleUtil.getLastUsedGradleHome(), (boolean)false, (int)1, null);
        if (lastUsedGradleHome != null) {
            return lastUsedGradleHome;
        }
        GradleInstallationManager gradleInstallationManager = installationManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleInstallationManager, (String)"installationManager");
        File file = gradleInstallationManager.getAutodetectedGradleHome();
        if (file == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"installationManager.auto\u2026GradleHome ?: return null");
        File gradleHome = file;
        return FileUtil.toCanonicalPath((String)gradleHome.getPath());
    }

    private final ExternalProjectRefreshCallback createFinalImportCallback(Project project, String externalProjectPath) {
        return new ExternalProjectRefreshCallback(this, project, externalProjectPath){
            final /* synthetic */ GradleOpenProjectProvider this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                GradleOpenProjectProvider.access$selectDataToImport(this.this$0, this.$project, this.$externalProjectPath, externalProject);
                GradleOpenProjectProvider.access$importData(this.this$0, this.$project, externalProject);
                GradleJvmResolutionUtil.updateGradleJvm(this.$project, this.$externalProjectPath);
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                this.$externalProjectPath = $captured_local_variable$2;
            }
        };
    }

    private final void selectDataToImport(Project project, String externalProjectPath, DataNode<ProjectData> externalProject) {
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings = gradleSettings;
        boolean showSelectiveImportDialog = settings.showSelectiveImportDialogOnInitialImport();
        Application application = ApplicationManager.getApplication();
        if (showSelectiveImportDialog) {
            Application application2 = application;
            Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"application");
            if (!application2.isHeadlessEnvironment()) {
                application.invokeAndWait(new Runnable(externalProjectPath, externalProject, project){
                    final /* synthetic */ String $externalProjectPath;
                    final /* synthetic */ DataNode $externalProject;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(GradleConstants.SYSTEM_ID, this.$externalProjectPath, this.$externalProject);
                        ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog(this.$project, (ExternalProjectInfo)projectInfo);
                        if (dialog.hasMultipleDataToSelect()) {
                            dialog.showAndGet();
                        } else {
                            Disposer.dispose((Disposable)dialog.getDisposable());
                        }
                    }
                    {
                        this.$externalProjectPath = string;
                        this.$externalProject = dataNode;
                        this.$project = project;
                    }
                });
            }
        }
    }

    private final void importData(Project project, DataNode<ProjectData> externalProject) {
        ProjectDataManager.getInstance().importData(externalProject, project, false);
    }

    public static final /* synthetic */ void access$selectDataToImport(GradleOpenProjectProvider $this, Project project, String externalProjectPath, DataNode externalProject) {
        $this.selectDataToImport(project, externalProjectPath, (DataNode<ProjectData>)externalProject);
    }

    public static final /* synthetic */ void access$importData(GradleOpenProjectProvider $this, Project project, DataNode externalProject) {
        $this.importData(project, (DataNode<ProjectData>)externalProject);
    }
}

