/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.UserDataHolderBase;
import java.io.File;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class DefaultProjectResolverContext
extends UserDataHolderBase
implements ProjectResolverContext {
    @NotNull
    private final ExternalSystemTaskId myExternalSystemTaskId;
    @NotNull
    private final String myProjectPath;
    @Nullable
    private final GradleExecutionSettings mySettings;
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    private final boolean myIsPreviewMode;
    @NotNull
    private final CancellationTokenSource myCancellationTokenSource;
    private ProjectConnection myConnection;
    @NotNull
    private ProjectImportAction.AllModels myModels;
    private File myGradleUserHome;
    @Nullable
    private String myProjectGradleVersion;
    @Nullable
    private String myBuildSrcGroup;
    @Nullable
    private BuildEnvironment myBuildEnvironment;
    @Nullable
    private final GradlePartialResolverPolicy myPolicy;

    public DefaultProjectResolverContext(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener, @Nullable GradlePartialResolverPolicy resolverPolicy, boolean isPreviewMode) {
        if (externalSystemTaskId == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(1);
        }
        if (listener == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(2);
        }
        this(externalSystemTaskId, projectPath, settings, null, listener, resolverPolicy, isPreviewMode);
    }

    public DefaultProjectResolverContext(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener, @Nullable GradlePartialResolverPolicy resolverPolicy, boolean isPreviewMode) {
        if (externalSystemTaskId == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(3);
        }
        if (projectPath == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(5);
        }
        this.myExternalSystemTaskId = externalSystemTaskId;
        this.myProjectPath = projectPath;
        this.mySettings = settings;
        this.myConnection = connection;
        this.myListener = listener;
        this.myPolicy = resolverPolicy;
        this.myIsPreviewMode = isPreviewMode;
        this.myCancellationTokenSource = GradleConnector.newCancellationTokenSource();
    }

    @Override
    @NotNull
    public ExternalSystemTaskId getExternalSystemTaskId() {
        ExternalSystemTaskId externalSystemTaskId = this.myExternalSystemTaskId;
        if (externalSystemTaskId == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(6);
        }
        return externalSystemTaskId;
    }

    @Override
    @Nullable
    public String getIdeProjectPath() {
        return this.mySettings != null ? this.mySettings.getIdeProjectPath() : null;
    }

    @Override
    @NotNull
    public String getProjectPath() {
        String string = this.myProjectPath;
        if (string == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    public GradleExecutionSettings getSettings() {
        return this.mySettings;
    }

    @Override
    @NotNull
    public ProjectConnection getConnection() {
        ProjectConnection projectConnection = this.myConnection;
        if (projectConnection == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(8);
        }
        return projectConnection;
    }

    public void setConnection(@NotNull ProjectConnection connection) {
        if (connection == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(9);
        }
        this.myConnection = connection;
    }

    @Override
    @NotNull
    public CancellationTokenSource getCancellationTokenSource() {
        CancellationTokenSource cancellationTokenSource = this.myCancellationTokenSource;
        if (cancellationTokenSource == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(10);
        }
        return cancellationTokenSource;
    }

    @Override
    @NotNull
    public ExternalSystemTaskNotificationListener getListener() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.myListener;
        if (externalSystemTaskNotificationListener == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(11);
        }
        return externalSystemTaskNotificationListener;
    }

    @Override
    public boolean isPreviewMode() {
        return this.myIsPreviewMode;
    }

    @Override
    public boolean isResolveModulePerSourceSet() {
        return this.mySettings == null || this.mySettings.isResolveModulePerSourceSet();
    }

    @Override
    public boolean isUseQualifiedModuleNames() {
        return this.mySettings != null && this.mySettings.isUseQualifiedModuleNames();
    }

    @Override
    public boolean isDelegatedBuild() {
        return this.mySettings == null || this.mySettings.isDelegatedBuild();
    }

    public File getGradleUserHome() {
        if (this.myGradleUserHome == null) {
            String serviceDirectory = this.mySettings == null ? null : this.mySettings.getServiceDirectory();
            this.myGradleUserHome = serviceDirectory != null ? new File(serviceDirectory) : new BuildLayoutParameters().getGradleUserHomeDir();
        }
        return this.myGradleUserHome;
    }

    @Override
    @NotNull
    public ProjectImportAction.AllModels getModels() {
        ProjectImportAction.AllModels allModels = this.myModels;
        if (allModels == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(12);
        }
        return allModels;
    }

    @Override
    public void setModels(@NotNull ProjectImportAction.AllModels models) {
        if (models == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(13);
        }
        this.myModels = models;
    }

    @Override
    @Nullable
    public <T> T getExtraProject(Class<T> modelClazz) {
        return (T)this.myModels.getModel(modelClazz);
    }

    @Override
    @Nullable
    public <T> T getExtraProject(@Nullable IdeaModule module, Class<T> modelClazz) {
        return (T)(module == null ? this.myModels.getModel(modelClazz) : this.myModels.getModel((ProjectModel)module, modelClazz));
    }

    @Override
    public boolean hasModulesWithModel(@NotNull Class modelClazz) {
        if (modelClazz == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(14);
        }
        return this.myModels.hasModulesWithModel(modelClazz);
    }

    @Override
    public void checkCancelled() {
        if (this.myCancellationTokenSource.token().isCancellationRequested()) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public String getProjectGradleVersion() {
        if (this.myProjectGradleVersion == null) {
            if (this.myBuildEnvironment == null) {
                this.myBuildEnvironment = this.getModels().getBuildEnvironment();
            }
            if (this.myBuildEnvironment != null) {
                this.myProjectGradleVersion = this.myBuildEnvironment.getGradle().getGradleVersion();
            }
        }
        return this.myProjectGradleVersion;
    }

    public void setBuildSrcGroup(@Nullable String groupId) {
        this.myBuildSrcGroup = groupId;
    }

    @Override
    @Nullable
    public String getBuildSrcGroup() {
        return this.myBuildSrcGroup;
    }

    @Override
    public void report(@NotNull MessageEvent.Kind kind, @NotNull BuildIssue buildIssue) {
        if (kind == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(15);
        }
        if (buildIssue == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(16);
        }
        BuildIssueEventImpl buildIssueEvent = new BuildIssueEventImpl((Object)this.myExternalSystemTaskId, buildIssue, kind);
        this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(this.myExternalSystemTaskId, (BuildEvent)buildIssueEvent));
    }

    void setBuildEnvironment(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(17);
        }
        this.myBuildEnvironment = buildEnvironment;
    }

    @Nullable
    public BuildEnvironment getBuildEnvironment() {
        return this.myBuildEnvironment;
    }

    @Nullable
    @ApiStatus.Experimental
    public GradlePartialResolverPolicy getPolicy() {
        return this.myPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemTaskId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/DefaultProjectResolverContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClazz";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildIssue";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/DefaultProjectResolverContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemTaskId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancellationTokenSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setConnection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setModels";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasModulesWithModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setBuildEnvironment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

