/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.debugger.DebuggerBackendExtension;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleSdkData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.model.project.ProjectSdkData;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencySyncIssue;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClassSetImportModelProvider;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.IntelliJProjectSettings;
import org.jetbrains.plugins.gradle.model.IntelliJSettings;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestsModel;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=0x7FFFFFFE)
public class CommonGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(CommonGradleProjectResolverExtension.class);
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        IntelliJSettings intellijSettings;
        ExternalProject externalProject;
        if (gradleProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(0);
        }
        if (ideProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(1);
        }
        if ((externalProject = this.resolverCtx.getExtraProject(ExternalProject.class)) != null) {
            ideProject.createChild(ExternalProjectDataCache.KEY, (Object)externalProject);
            ((ProjectData)ideProject.getData()).setDescription(externalProject.getDescription());
        }
        if ((intellijSettings = (IntelliJSettings)this.resolverCtx.getExtraProject(IntelliJProjectSettings.class)) != null) {
            ideProject.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
        CommonGradleProjectResolverExtension.populateProjectSdkModel(gradleProject, ideProject);
    }

    @Override
    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(2);
        }
        if (projectDataNode == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(3);
        }
        DataNode<ModuleData> mainModuleNode = GradleProjectResolverUtil.createMainModule(this.resolverCtx, gradleModule, projectDataNode);
        ModuleData mainModuleData = (ModuleData)mainModuleNode.getData();
        String mainModuleConfigPath = mainModuleData.getLinkedExternalProjectPath();
        String mainModuleFileDirectoryPath = mainModuleData.getModuleFileDirectoryPath();
        String jdkName = CommonGradleProjectResolverExtension.getJdkName(gradleModule);
        String[] moduleGroup = null;
        if (!this.resolverCtx.isUseQualifiedModuleNames()) {
            moduleGroup = CommonGradleProjectResolverExtension.getIdeModuleGroup(mainModuleData.getInternalName(), gradleModule);
            mainModuleData.setIdeModuleGroup(moduleGroup);
        }
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
            assert (externalProject != null);
            for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
                String moduleId = GradleProjectResolverUtil.getModuleId(this.resolverCtx, gradleModule, sourceSet);
                String moduleExternalName = gradleModule.getName() + ":" + sourceSet.getName();
                String moduleInternalName = GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, sourceSet.getName(), this.resolverCtx);
                GradleSourceSetData sourceSetData = new GradleSourceSetData(moduleId, moduleExternalName, moduleInternalName, mainModuleFileDirectoryPath, mainModuleConfigPath);
                sourceSetData.setGroup(externalProject.getGroup());
                if ("main".equals(sourceSet.getName())) {
                    sourceSetData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
                }
                sourceSetData.setVersion(externalProject.getVersion());
                sourceSetData.setIdeModuleGroup(moduleGroup);
                sourceSetData.internalSetSourceCompatibility(sourceSet.getSourceCompatibility());
                sourceSetData.internalSetTargetCompatibility(sourceSet.getTargetCompatibility());
                sourceSetData.internalSetSdkName(jdkName);
                THashSet artifacts = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                if ("main".equals(sourceSet.getName())) {
                    Set defaultArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("default");
                    if (defaultArtifacts != null) {
                        artifacts.addAll(defaultArtifacts);
                    }
                } else if ("test".equals(sourceSet.getName())) {
                    sourceSetData.setProductionModuleId(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, "main", this.resolverCtx));
                    Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                    if (testsArtifacts != null) {
                        artifacts.addAll(testsArtifacts);
                    }
                }
                artifacts.addAll(sourceSet.getArtifacts());
                for (ExternalSourceDirectorySet directorySet : sourceSet.getSources().values()) {
                    artifacts.addAll(directorySet.getGradleOutputDirs());
                }
                sourceSetData.setArtifacts(new ArrayList(artifacts));
                DataNode sourceSetDataNode = mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)sourceSetData);
                Map sourceSetMap = (Map)projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
                assert (sourceSetMap != null);
                sourceSetMap.put(moduleId, Pair.create((Object)sourceSetDataNode, (Object)sourceSet));
                CommonGradleProjectResolverExtension.populateModuleSdkModel(gradleModule, (DataNode<? extends ModuleData>)sourceSetDataNode);
            }
        } else {
            try {
                IdeaJavaLanguageSettings languageSettings = gradleModule.getJavaLanguageSettings();
                if (languageSettings != null) {
                    if (languageSettings.getLanguageLevel() != null) {
                        mainModuleData.internalSetSourceCompatibility(languageSettings.getLanguageLevel().toString());
                    }
                    if (languageSettings.getTargetBytecodeVersion() != null) {
                        mainModuleData.internalSetTargetCompatibility(languageSettings.getTargetBytecodeVersion().toString());
                    }
                }
                mainModuleData.internalSetSdkName(jdkName);
            }
            catch (UnsupportedMethodException languageSettings) {
                // empty catch block
            }
        }
        CommonGradleProjectResolverExtension.populateModuleSdkModel(gradleModule, mainModuleNode);
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        if (StringUtil.equals((CharSequence)mainModuleData.getLinkedExternalProjectPath(), (CharSequence)projectData.getLinkedExternalProjectPath())) {
            projectData.setGroup(mainModuleData.getGroup());
            projectData.setVersion(mainModuleData.getVersion());
        }
        DataNode<ModuleData> dataNode = mainModuleNode;
        if (dataNode == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(4);
        }
        return dataNode;
    }

    private static void populateProjectSdkModel(@NotNull IdeaProject ideaProject, @NotNull DataNode<? extends ProjectData> projectNode) {
        if (ideaProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(5);
        }
        if (projectNode == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(6);
        }
        String sdkName = CommonGradleProjectResolverExtension.findJdkName(ideaProject.getJdkName());
        ProjectSdkData projectSdkData = new ProjectSdkData(sdkName);
        projectNode.createChild(ProjectSdkData.KEY, (Object)projectSdkData);
    }

    private static void populateModuleSdkModel(@NotNull IdeaModule ideaModule, @NotNull DataNode<? extends ModuleData> moduleNode) {
        if (ideaModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(7);
        }
        if (moduleNode == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(8);
        }
        String sdkName = CommonGradleProjectResolverExtension.findJdkName(ideaModule.getJdkName());
        ModuleSdkData moduleSdkData = new ModuleSdkData(sdkName);
        moduleNode.createChild(ModuleSdkData.KEY, (Object)moduleSdkData);
    }

    @Nullable
    private static String findJdkName(@Nullable String jdkNameOrVersion) {
        if (jdkNameOrVersion == null) {
            return null;
        }
        Sdk sdkByName = CommonGradleProjectResolverExtension.findJdkByName(jdkNameOrVersion);
        if (sdkByName != null) {
            return sdkByName.getName();
        }
        Sdk sdkByVersion = CommonGradleProjectResolverExtension.findJdkByVersion(jdkNameOrVersion);
        if (sdkByVersion != null) {
            return sdkByVersion.getName();
        }
        return jdkNameOrVersion;
    }

    @Nullable
    private static Sdk findJdkByName(@NotNull String jdkName) {
        if (jdkName == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(9);
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        return projectJdkTable.findJdk(jdkName);
    }

    @Nullable
    private static Sdk findJdkByVersion(@NotNull String jdkVersionString) {
        JavaVersion jdkVersion;
        if (jdkVersionString == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(10);
        }
        if ((jdkVersion = JavaVersion.tryParse((String)jdkVersionString)) == null) {
            return null;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        ArrayList<Pair> index = new ArrayList<Pair>();
        for (Sdk sdk : projectJdkTable.getAllJdks()) {
            String versionString = CommonGradleProjectResolverExtension.getVersionString(sdk);
            JavaVersion version = JavaVersion.tryParse((String)versionString);
            if (version == null) continue;
            index.add(new Pair((Object)version, (Object)sdk));
        }
        return Stream.concat(index.stream().filter(it -> jdkVersion.equals(it.first)), index.stream().filter(it -> jdkVersion.feature == ((JavaVersion)it.first).feature)).findFirst().map(it -> (Sdk)it.second).orElse(null);
    }

    @Nullable
    private static String getVersionString(@NotNull Sdk sdk) {
        String versionString;
        if (sdk == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(11);
        }
        if ((versionString = sdk.getVersionString()) != null) {
            return versionString;
        }
        SdkTypeId type = sdk.getSdkType();
        return type.getVersionString(sdk);
    }

    private static String @NotNull [] getIdeModuleGroup(String moduleName, IdeaModule gradleModule) {
        String gradlePath = gradleModule.getGradleProject().getPath();
        String rootName = gradleModule.getProject().getName();
        if (StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath)) {
            String[] stringArray = new String[]{moduleName};
            if (stringArray == null) {
                CommonGradleProjectResolverExtension.$$$reportNull$$$0(12);
            }
            return stringArray;
        }
        String[] stringArray = (rootName + gradlePath).split(":");
        if (stringArray == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    @Nullable
    private static String getJdkName(@NotNull IdeaModule gradleModule) {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(14);
        }
        try {
            return gradleModule.getJdkName();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectImportAction.AllModels models;
        ExternalTestsModel externalTestsModel;
        IntelliJSettings intellijSettings;
        GradleExtensions gradleExtensions;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(15);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(16);
        }
        if ((gradleExtensions = this.resolverCtx.getExtraProject(gradleModule, GradleExtensions.class)) != null) {
            boolean useCustomSerialization = Registry.is((String)"gradle.tooling.custom.serializer", (boolean)true);
            DefaultGradleExtensions extensions = useCustomSerialization ? (DefaultGradleExtensions)gradleExtensions : new DefaultGradleExtensions(gradleExtensions);
            ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
            if (externalProject != null) {
                extensions.addTasks(externalProject.getTasks().values());
            }
            ideModule.createChild(GradleExtensionsDataService.KEY, (Object)extensions);
        }
        if ((intellijSettings = this.resolverCtx.getExtraProject(gradleModule, IntelliJSettings.class)) != null) {
            ideModule.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
        if ((externalTestsModel = (ExternalTestsModel)(models = this.resolverCtx.getModels()).getModel((ProjectModel)gradleModule, ExternalTestsModel.class)) != null) {
            for (ExternalTestSourceMapping testSourceMapping : externalTestsModel.getTestSourceMappings()) {
                String testName = testSourceMapping.getTestName();
                String testTaskName = testSourceMapping.getTestTaskPath();
                Set sourceFolders = testSourceMapping.getSourceFolders();
                TestData testData = new TestData(GradleConstants.SYSTEM_ID, testName, testTaskName, sourceFolders);
                ideModule.createChild(ProjectKeys.TEST, (Object)testData);
            }
        }
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ExternalProject externalProject;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(17);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(18);
        }
        if ((externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx)) != null) {
            this.addExternalProjectContentRoots(gradleModule, ideModule, externalProject);
        }
        PathPrefixTreeMap contentRootIndex = new PathPrefixTreeMap();
        for (Object contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            contentRootIndex.set(contentRootData.getRootPath(), (Object)contentRootData);
        }
        DomainObjectSet contentRoots = gradleModule.getContentRoots();
        if (contentRoots == null) {
            return;
        }
        for (IdeaContentRoot gradleContentRoot : contentRoots) {
            Set excluded;
            File rootDirectory;
            if (gradleContentRoot == null || (rootDirectory = gradleContentRoot.getRootDirectory()) == null) continue;
            boolean oldGradle = false;
            String contentRootPath = FileUtil.toCanonicalPath((String)rootDirectory.getAbsolutePath());
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, contentRootPath);
            contentRootIndex.set(contentRootPath, (Object)ideContentRoot);
            if (!this.resolverCtx.isResolveModulePerSourceSet()) {
                List testResourceDirectories;
                List resourceDirectories;
                List testDirectories;
                List sourceDirectories;
                block13: {
                    sourceDirectories = gradleContentRoot.getSourceDirectories().getAll();
                    testDirectories = gradleContentRoot.getTestDirectories().getAll();
                    resourceDirectories = Collections.emptyList();
                    testResourceDirectories = Collections.emptyList();
                    try {
                        Set<File> notResourceDirs = CommonGradleProjectResolverExtension.collectExplicitNonResourceDirectories(externalProject);
                        resourceDirectories = gradleContentRoot.getResourceDirectories().getAll();
                        CommonGradleProjectResolverExtension.removeDuplicateResources(sourceDirectories, resourceDirectories, notResourceDirs);
                        testResourceDirectories = gradleContentRoot.getTestResourceDirectories().getAll();
                        CommonGradleProjectResolverExtension.removeDuplicateResources(testDirectories, testResourceDirectories, notResourceDirs);
                    }
                    catch (UnsupportedMethodException e) {
                        oldGradle = true;
                        LOG.debug(e.getMessage());
                        if (externalProject != null) break block13;
                        CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getSourceDirectories());
                        CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getTestDirectories());
                    }
                }
                if (!oldGradle) {
                    CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, sourceDirectories);
                    CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, testDirectories);
                    CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.RESOURCE, resourceDirectories);
                    CommonGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST_RESOURCE, testResourceDirectories);
                }
            }
            if ((excluded = gradleContentRoot.getExcludeDirectories()) == null) continue;
            for (File file : excluded) {
                ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, file.getAbsolutePath());
            }
        }
        LinkedHashSet<String> existsContentRoots = new LinkedHashSet<String>();
        for (DataNode contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            existsContentRoots.add(contentRootData.getRootPath());
        }
        for (ContentRootData ideContentRoot : contentRootIndex.getValues()) {
            if (existsContentRoots.contains(ideContentRoot.getRootPath())) continue;
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    @Nullable
    private static ExternalProject getExternalProject(@NotNull IdeaModule gradleModule, @NotNull ProjectResolverContext resolverCtx) {
        ExternalProject project;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(19);
        }
        if (resolverCtx == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(20);
        }
        if ((project = resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) == null && resolverCtx.isResolveModulePerSourceSet()) {
            LOG.error("External Project model is missing for module-per-sourceSet import mode. Please, check import log for error messages.");
        }
        return project;
    }

    private void addExternalProjectContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull ExternalProject externalProject) {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(21);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(22);
        }
        if (externalProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(23);
        }
        CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

            @Override
            public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                if (dataNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (sourceSet == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                    ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                    ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                    for (File file : sourceDirectorySet.getSrcDirs()) {
                        ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, file.getAbsolutePath());
                        ideContentRoot.storePath(sourceType, file.getAbsolutePath());
                        dataNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceSet";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void removeDuplicateResources(@NotNull List<? extends IdeaSourceDirectory> sourceDirectories, @NotNull List<? extends IdeaSourceDirectory> resourceDirectories, @NotNull Set<File> notResourceDirs) {
        if (sourceDirectories == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(24);
        }
        if (resourceDirectories == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(25);
        }
        if (notResourceDirs == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(26);
        }
        resourceDirectories.removeIf(ideaSourceDirectory -> notResourceDirs.contains(ideaSourceDirectory.getDirectory()));
        CommonGradleProjectResolverExtension.removeAll(sourceDirectories, resourceDirectories);
    }

    @NotNull
    private static Set<File> collectExplicitNonResourceDirectories(@Nullable ExternalProject externalProject) {
        if (externalProject == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                CommonGradleProjectResolverExtension.$$$reportNull$$$0(27);
            }
            return set;
        }
        Set set = (Set)externalProject.getSourceSets().values().stream().flatMap(ss -> ss.getSources().entrySet().stream().filter(e -> !((IExternalSystemSourceType)e.getKey()).isResource()).flatMap(e -> ((ExternalSourceDirectorySet)e.getValue()).getSrcDirs().stream())).collect(Collectors.toCollection(() -> new THashSet(FileUtil.FILE_HASHING_STRATEGY)));
        if (set == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(28);
        }
        return set;
    }

    private static void removeAll(List<? extends IdeaSourceDirectory> list, List<? extends IdeaSourceDirectory> toRemove) {
        Set files = toRemove.stream().map(o -> o.getDirectory()).collect(Collectors.toSet());
        list.removeIf(o -> files.contains(o.getDirectory()));
    }

    private static void processSourceSets(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> ideModule, @NotNull SourceSetsProcessor processor) {
        if (resolverCtx == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(29);
        }
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(30);
        }
        if (externalProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(31);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(33);
        }
        HashMap<String, DataNode> sourceSetsMap = new HashMap<String, DataNode>();
        for (DataNode dataNode : ExternalSystemApiUtil.findAll(ideModule, GradleSourceSetData.KEY)) {
            sourceSetsMap.put(((GradleSourceSetData)((Object)dataNode.getData())).getId(), dataNode);
        }
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            DataNode moduleDataNode;
            if (sourceSet == null || sourceSet.getSources().isEmpty()) continue;
            String moduleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule, sourceSet);
            DataNode dataNode = moduleDataNode = sourceSetsMap.isEmpty() ? ideModule : (DataNode)sourceSetsMap.get(moduleId);
            if (moduleDataNode == null) continue;
            processor.process((DataNode<? extends ModuleData>)moduleDataNode, sourceSet);
        }
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        boolean inheritOutputDirs;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(34);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(35);
        }
        ModuleData moduleData = (ModuleData)ideModule.getData();
        moduleData.useExternalCompilerOutput(this.resolverCtx.isDelegatedBuild());
        File ideaOutDir = new File(moduleData.getLinkedExternalProjectPath(), "out");
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            DataNode projectDataNode = ideModule.getDataNode(ProjectKeys.PROJECT);
            assert (projectDataNode != null);
            final Map moduleOutputsMap = (Map)projectDataNode.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
            assert (moduleOutputsMap != null);
            final HashSet outputDirs = new HashSet();
            assert (externalProject != null);
            CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    MultiMap gradleOutputMap;
                    if (dataNode == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (sourceSet == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((gradleOutputMap = (MultiMap)dataNode.getUserData(GradleProjectResolver.GRADLE_OUTPUTS)) == null) {
                        gradleOutputMap = MultiMap.create();
                        dataNode.putUserData(GradleProjectResolver.GRADLE_OUTPUTS, (Object)gradleOutputMap);
                    }
                    ModuleData moduleData = (ModuleData)dataNode.getData();
                    moduleData.useExternalCompilerOutput(CommonGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild());
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        File ideOutputDir = CommonGradleProjectResolverExtension.getIdeOutputDir(sourceDirectorySet);
                        File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(sourceDirectorySet);
                        File outputDir = CommonGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild() ? gradleOutputDir : ideOutputDir;
                        moduleData.setCompileOutputPath(sourceType, ideOutputDir == null ? null : ideOutputDir.getAbsolutePath());
                        moduleData.setExternalCompilerOutputPath(sourceType, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                        moduleData.setInheritProjectCompileOutputPath(sourceDirectorySet.isCompilerOutputPathInherited());
                        if (outputDir == null) continue;
                        outputDirs.add(outputDir.getPath());
                        for (File file : sourceDirectorySet.getGradleOutputDirs()) {
                            String gradleOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)file.getAbsolutePath());
                            gradleOutputMap.putValue((Object)sourceType, (Object)gradleOutputPath);
                            if (file.getPath().equals(outputDir.getPath())) continue;
                            moduleOutputsMap.put(gradleOutputPath, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataNode";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceSet";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension$2";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (outputDirs.stream().anyMatch(path -> FileUtil.isAncestor((File)ideaOutDir, (File)new File((String)path), (boolean)false))) {
                CommonGradleProjectResolverExtension.excludeOutDir(ideModule, ideaOutDir);
            }
            return;
        }
        IdeaCompilerOutput moduleCompilerOutput = gradleModule.getCompilerOutput();
        boolean bl = inheritOutputDirs = moduleCompilerOutput != null && moduleCompilerOutput.getInheritOutputDirs();
        if (moduleCompilerOutput != null) {
            File outputDir = moduleCompilerOutput.getOutputDir();
            if (outputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getAbsolutePath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, new File(ideaOutDir, "production/classes").getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, new File(ideaOutDir, "production/resources").getAbsolutePath());
                if (externalProject != null) {
                    File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.SOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                    File gradleResourceOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getAbsolutePath());
                }
            }
            File testOutputDir = moduleCompilerOutput.getTestOutputDir();
            if (testOutputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getAbsolutePath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, new File(ideaOutDir, "test/classes").getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, new File(ideaOutDir, "test/resources").getAbsolutePath());
                if (externalProject != null) {
                    File gradleOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                    File gradleResourceOutputDir = CommonGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST_RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getAbsolutePath());
                }
            }
            if (!(this.resolverCtx.isDelegatedBuild() || inheritOutputDirs || outputDir != null && testOutputDir != null)) {
                CommonGradleProjectResolverExtension.excludeOutDir(ideModule, ideaOutDir);
            }
        }
        moduleData.setInheritProjectCompileOutputPath(inheritOutputDirs);
    }

    @Nullable
    public static File getGradleOutputDir(@NotNull ExternalProject externalProject, @NotNull String sourceSetName, @NotNull ExternalSystemSourceType sourceType) {
        ExternalSourceSet sourceSet;
        if (externalProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(36);
        }
        if (sourceSetName == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(37);
        }
        if (sourceType == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(38);
        }
        if ((sourceSet = (ExternalSourceSet)externalProject.getSourceSets().get(sourceSetName)) == null) {
            return null;
        }
        return CommonGradleProjectResolverExtension.getGradleOutputDir((ExternalSourceDirectorySet)sourceSet.getSources().get(sourceType));
    }

    @Nullable
    private static File getIdeOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getOutputDir();
    }

    @Nullable
    private static File getGradleOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getGradleOutputDirs().stream().findFirst().orElse(null);
    }

    private static void excludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        ContentRootData excludedContentRootData;
        DataNode contentRootDataDataNode;
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(39);
        }
        if ((contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) == null || !FileUtil.isAncestor((File)new File(((ContentRootData)contentRootDataDataNode.getData()).getRootPath()), (File)ideaOutDir, (boolean)false)) {
            excludedContentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, ideaOutDir.getAbsolutePath());
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)excludedContentRootData);
        } else {
            excludedContentRootData = (ContentRootData)contentRootDataDataNode.getData();
        }
        excludedContentRootData.storePath(ExternalSystemSourceType.EXCLUDED, ideaOutDir.getAbsolutePath());
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, final @NotNull DataNode<ProjectData> ideProject) {
        ExternalSystemTaskId taskId;
        Project project;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(40);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(41);
        }
        if (ideProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(42);
        }
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (this.resolverCtx.isResolveModulePerSourceSet()) {
            final Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
            final Map artifactsMap = (Map)ideProject.getUserData(GradleProjectResolver.CONFIGURATION_ARTIFACTS);
            assert (sourceSetMap != null);
            assert (artifactsMap != null);
            assert (externalProject != null);
            CommonGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    if (dataNode == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (sourceSet == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    GradleProjectResolverUtil.buildDependencies(CommonGradleProjectResolverExtension.this.resolverCtx, sourceSetMap, artifactsMap, dataNode, sourceSet.getDependencies(), (DataNode<ProjectData>)ideProject);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataNode";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceSet";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension$3";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return;
        }
        List dependencies = gradleModule.getDependencies().getAll();
        if (dependencies == null) {
            return;
        }
        ArrayList<String> orphanModules = new ArrayList<String>();
        HashMap<String, ModuleData> modulesIndex = new HashMap<String, ModuleData>();
        for (DataNode dataNode : ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectKeys.MODULE)) {
            modulesIndex.put(((ModuleData)dataNode.getData()).getExternalName(), (ModuleData)dataNode.getData());
        }
        for (int i2 = 0; i2 < dependencies.size(); ++i2) {
            ModuleDependencyData d;
            IdeaDependency dependency = (IdeaDependency)dependencies.get(i2);
            if (dependency == null) continue;
            DependencyScope scope = CommonGradleProjectResolverExtension.parseScope(dependency.getScope());
            if (dependency instanceof IdeaModuleDependency) {
                d = CommonGradleProjectResolverExtension.buildDependency(this.resolverCtx, ideModule, (IdeaModuleDependency)dependency, modulesIndex);
                d.setExported(dependency.getExported());
                if (scope != null) {
                    d.setScope(scope);
                }
                d.setOrder(i2);
                ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)d);
                ModuleData targetModule = (ModuleData)d.getTarget();
                if (!targetModule.getId().isEmpty() || !targetModule.getLinkedExternalProjectPath().isEmpty()) continue;
                orphanModules.add(targetModule.getExternalName());
                continue;
            }
            if (!(dependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            d = this.buildDependency(gradleModule, ideModule, (IdeaSingleEntryLibraryDependency)dependency, ideProject);
            d.setExported(dependency.getExported());
            if (scope != null) {
                d.setScope(scope);
            }
            d.setOrder(i2);
            ideModule.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)d);
        }
        if (!orphanModules.isEmpty() && (project = (taskId = this.resolverCtx.getExternalSystemTaskId()).findProject()) != null) {
            String msg = "Can't find the following module" + (orphanModules.size() > 1 ? "s" : "") + ": " + StringUtil.join(orphanModules, (String)", ") + "\nIt can be caused by composite build configuration inside your *.gradle scripts with Gradle version older than 3.3.\nTry Gradle 3.3 or better or enable 'Create separate module per source set' option";
            NotificationData notification2 = new NotificationData("Gradle project structure problems", msg, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(taskId.getProjectSystemId(), notification2);
        }
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(43);
        }
        if (ideModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(44);
        }
        if (ideProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(45);
        }
        ArrayList<TaskData> tasks = new ArrayList<TaskData>();
        String moduleConfigPath = ((ModuleData)ideModule.getData()).getLinkedExternalProjectPath();
        String rootProjectPath = ((ProjectData)ideProject.getData()).getLinkedExternalProjectPath();
        try {
            File rootDir = gradleModule.getGradleProject().getProjectIdentifier().getBuildIdentifier().getRootDir();
            rootProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)rootDir.getCanonicalPath());
        }
        catch (IOException e) {
            LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
        }
        ExternalProject externalProject = CommonGradleProjectResolverExtension.getExternalProject(gradleModule, this.resolverCtx);
        if (externalProject != null) {
            boolean isFlatProject = !FileUtil.isAncestor((String)rootProjectPath, (String)moduleConfigPath, (boolean)false);
            for (ExternalTask task : externalProject.getTasks().values()) {
                String taskName = isFlatProject ? task.getQName() : task.getName();
                String taskGroup = task.getGroup();
                if (taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
                String taskPath = isFlatProject ? rootProjectPath : moduleConfigPath;
                TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, taskPath, task.getDescription());
                taskData.setGroup(taskGroup);
                taskData.setType(task.getType());
                taskData.setTest(task.isTest());
                ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
                taskData.setInherited(StringUtil.equals((CharSequence)task.getName(), (CharSequence)task.getQName()));
                tasks.add(taskData);
            }
            ArrayList<TaskData> arrayList = tasks;
            if (arrayList == null) {
                CommonGradleProjectResolverExtension.$$$reportNull$$$0(46);
            }
            return arrayList;
        }
        for (GradleTask task : gradleModule.getGradleProject().getTasks()) {
            String taskName = task.getName();
            String taskGroup = CommonGradleProjectResolverExtension.getTaskGroup(task);
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task.getDescription());
            taskData.setGroup(taskGroup);
            ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
            tasks.add(taskData);
        }
        ArrayList<TaskData> arrayList = tasks;
        if (arrayList == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(47);
        }
        return arrayList;
    }

    @Nullable
    private static String getTaskGroup(GradleTask task) {
        String taskGroup;
        try {
            taskGroup = task.getGroup();
        }
        catch (UnsupportedMethodException e) {
            taskGroup = null;
        }
        return taskGroup;
    }

    @Override
    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Object[])new Class[]{BuildScriptClasspathModel.class, GradleExtensions.class, ExternalTestsModel.class, IntelliJProjectSettings.class, IntelliJSettings.class});
        if (linkedHashSet == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(48);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public ProjectImportModelProvider getModelProvider() {
        return new ClassSetImportModelProvider(this.getExtraProjectModelClasses(), (Set)ContainerUtil.newLinkedHashSet((Object[])new Class[]{ExternalProject.class, IdeaProject.class}));
    }

    @Override
    public Set<Class<?>> getTargetTypes() {
        return ContainerUtil.newLinkedHashSet((Object[])new Class[]{ExternalProjectDependency.class, ExternalLibraryDependency.class, FileCollectionDependency.class, UnresolvedExternalDependency.class});
    }

    @Override
    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @NotNull Consumer<String> initScriptConsumer, @NotNull Map<String, String> parameters) {
        String dispatchPort;
        if (taskNames == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(49);
        }
        if (initScriptConsumer == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(50);
        }
        if (parameters == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(51);
        }
        if ((dispatchPort = parameters.get("DEBUG_DISPATCH_PORT")) == null) {
            return;
        }
        String debugOptions = parameters.get("DEBUG_OPTIONS");
        if (debugOptions == null) {
            debugOptions = "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        String esRtJarPath = PathUtil.getCanonicalPath((String)PathManager.getJarPathForClass(ExternalSystemSourceType.class));
        lines.add("initscript { dependencies { classpath files(\"" + esRtJarPath + "\") } }");
        for (DebuggerBackendExtension extension : DebuggerBackendExtension.EP_NAME.getExtensionList()) {
            lines.addAll(extension.initializationCode(dispatchPort, debugOptions));
        }
        String script = StringUtil.join(lines, (String)SystemProperties.getLineSeparator());
        initScriptConsumer.consume((Object)script);
    }

    private static void populateContentRoot(@NotNull PathPrefixTreeMap<ContentRootData> contentRootIndex, @NotNull ExternalSystemSourceType type, @Nullable Iterable<? extends IdeaSourceDirectory> dirs) throws IllegalArgumentException {
        if (contentRootIndex == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(52);
        }
        if (type == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(53);
        }
        if (dirs == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : dirs) {
            ExternalSystemSourceType dirSourceType = type;
            try {
                if (ideaSourceDirectory.isGenerated() && !dirSourceType.isGenerated()) {
                    ExternalSystemSourceType generatedType = ExternalSystemSourceType.from((boolean)dirSourceType.isTest(), (boolean)ideaSourceDirectory.isGenerated(), (boolean)dirSourceType.isResource(), (boolean)dirSourceType.isExcluded());
                    dirSourceType = generatedType != null ? generatedType : dirSourceType;
                }
            }
            catch (UnsupportedMethodException e) {
                LOG.warn(e.getMessage());
                CommonGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            catch (Throwable e) {
                LOG.debug(e);
                CommonGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            String path = FileUtil.toCanonicalPath((String)ideaSourceDirectory.getDirectory().getAbsolutePath());
            if (contentRootIndex.getAllAncestorKeys(path).isEmpty()) {
                ContentRootData contentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, path);
                contentRootIndex.set(path, (Object)contentRootData);
            }
            List ancestors = contentRootIndex.getAllAncestorKeys(path);
            String contentRootPath = (String)ancestors.get(ancestors.size() - 1);
            ContentRootData contentRoot = (ContentRootData)contentRootIndex.get(contentRootPath);
            assert (contentRoot != null);
            contentRoot.storePath(dirSourceType, path);
        }
    }

    private static void printToolingProxyDiagnosticInfo(@Nullable Object obj) {
        if (!LOG.isDebugEnabled() || obj == null) {
            return;
        }
        LOG.debug(String.format("obj: %s", obj));
        Class<?> aClass = obj.getClass();
        LOG.debug(String.format("obj class: %s", aClass));
        LOG.debug(String.format("classloader: %s", aClass.getClassLoader()));
        for (Method m : aClass.getDeclaredMethods()) {
            LOG.debug(String.format("obj m: %s", m));
        }
        if (obj instanceof Proxy) {
            try {
                Field hField = ReflectionUtil.findField(obj.getClass(), null, (String)"h");
                hField.setAccessible(true);
                Object h = hField.get(obj);
                Field delegateField = ReflectionUtil.findField(h.getClass(), null, (String)"delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(h);
                LOG.debug(String.format("delegate: %s", delegate));
                LOG.debug(String.format("delegate class: %s", delegate.getClass()));
                LOG.debug(String.format("delegate classloader: %s", delegate.getClass().getClassLoader()));
                for (Method m : delegate.getClass().getDeclaredMethods()) {
                    LOG.debug(String.format("delegate m: %s", m));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @Nullable
    private static DependencyScope parseScope(@Nullable IdeaDependencyScope scope) {
        if (scope == null) {
            return null;
        }
        String scopeAsString = scope.getScope();
        if (scopeAsString == null) {
            return null;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scopeAsString.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return null;
    }

    @NotNull
    private static ModuleDependencyData buildDependency(@NotNull ProjectResolverContext resolverContext, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaModuleDependency dependency, @NotNull Map<String, ModuleData> registeredModulesIndex) throws IllegalStateException {
        ModuleData moduleData;
        ModuleData moduleData2;
        IdeaModule dependencyModule;
        GradleVersion projectGradleVersion;
        if (resolverContext == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(54);
        }
        if (ownerModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(55);
        }
        if (dependency == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(56);
        }
        if (registeredModulesIndex == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(57);
        }
        GradleExecutionSettings gradleExecutionSettings = resolverContext.getSettings();
        String projectGradleVersionString = resolverContext.getProjectGradleVersion();
        if (gradleExecutionSettings != null && projectGradleVersionString != null && (projectGradleVersion = GradleVersion.version((String)projectGradleVersionString)).compareTo(GradleVersion.version((String)"4.0")) < 0 && (dependencyModule = CommonGradleProjectResolverExtension.getDependencyModuleByReflection(dependency)) != null && (moduleData2 = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByModule(resolverContext, dependencyModule)) != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData2);
        }
        String moduleName = dependency.getTargetModuleName();
        if (gradleExecutionSettings != null && (moduleData = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByGradleModuleName(moduleName)) != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData);
        }
        ModuleData registeredModuleData = registeredModulesIndex.get(moduleName);
        if (registeredModuleData != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), registeredModuleData);
        }
        throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: no module with such name (%s) is found. Registered modules: %s", dependency, moduleName, registeredModulesIndex.keySet()));
    }

    @Nullable
    private static IdeaModule getDependencyModuleByReflection(@NotNull IdeaModuleDependency dependency) {
        Method getDependencyModule;
        if (dependency == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(58);
        }
        if ((getDependencyModule = ReflectionUtil.getMethod(dependency.getClass(), (String)"getDependencyModule", (Class[])new Class[0])) != null) {
            try {
                Object result = getDependencyModule.invoke((Object)dependency, new Object[0]);
                return (IdeaModule)result;
            }
            catch (IllegalAccessException e) {
                LOG.info("Failed to get dependency module for [" + dependency + "]", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.info("Failed to get dependency module for [" + dependency + "]", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private LibraryDependencyData buildDependency(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaSingleEntryLibraryDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        String libraryName;
        LibraryLevel level;
        File binaryPath;
        if (gradleModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(59);
        }
        if (ownerModule == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(60);
        }
        if (dependency == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(61);
        }
        if (ideProject == null) {
            CommonGradleProjectResolverExtension.$$$reportNull$$$0(62);
        }
        if ((binaryPath = dependency.getFile()) == null) {
            throw new IllegalStateException(String.format("Can't parse external library dependency '%s'. Reason: it doesn't specify path to the binaries", dependency));
        }
        GradleModuleVersion moduleVersion = dependency.getGradleModuleVersion();
        boolean unresolved = binaryPath.getName().startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
        if (moduleVersion == null) {
            if (binaryPath.isFile()) {
                boolean isModuleLocalLibrary = false;
                try {
                    isModuleLocalLibrary = FileUtil.isAncestor((File)gradleModule.getGradleProject().getProjectDirectory(), (File)binaryPath, (boolean)false);
                }
                catch (UnsupportedMethodException unsupportedMethodException) {
                    // empty catch block
                }
                level = isModuleLocalLibrary ? LibraryLevel.MODULE : LibraryLevel.PROJECT;
                libraryName = this.chooseName(binaryPath, level, ideProject);
            } else {
                level = LibraryLevel.MODULE;
                libraryName = "";
            }
            if (unresolved) {
                libraryName = binaryPath.getName().substring(UNRESOLVED_DEPENDENCY_PREFIX.length());
                libraryName = StringUtil.join((Collection)StringUtil.split((String)libraryName, (String)" "), (String)":");
            }
        } else {
            level = LibraryLevel.PROJECT;
            libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            if (binaryPath.isFile()) {
                String libraryFileName = FileUtilRt.getNameWithoutExtension((String)binaryPath.getName());
                String mavenLibraryFileName = String.format("%s-%s", moduleVersion.getName(), moduleVersion.getVersion());
                if (!mavenLibraryFileName.equals(libraryFileName)) {
                    Pattern pattern = Pattern.compile(moduleVersion.getName() + "-" + moduleVersion.getVersion() + "-(.*)");
                    Matcher matcher = pattern.matcher(libraryFileName);
                    if (matcher.matches()) {
                        String classifier = matcher.group(1);
                        libraryName = libraryName + ":" + classifier;
                    } else {
                        String artifactId = StringUtil.trimEnd((String)StringUtil.trimEnd((String)libraryFileName, (String)moduleVersion.getVersion()), (String)"-");
                        libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), artifactId, moduleVersion.getVersion());
                    }
                }
            }
        }
        if (!unresolved && StringUtil.isNotEmpty((String)libraryName) && !FileUtilRt.extensionEquals((String)binaryPath.getName(), (String)"jar")) {
            libraryName = libraryName + ":" + FileUtilRt.getExtension((String)binaryPath.getName());
        }
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, unresolved);
        if (moduleVersion != null) {
            library.setGroup(moduleVersion.getGroup());
            library.setArtifactId(moduleVersion.getName());
            library.setVersion(moduleVersion.getVersion());
        }
        if (!unresolved) {
            library.addPath(LibraryPathType.BINARY, binaryPath.getAbsolutePath());
        } else {
            boolean isOfflineWork = this.resolverCtx.getSettings() != null && this.resolverCtx.getSettings().isOfflineWork();
            String message = String.format("Could not resolve %s.", libraryName);
            UnresolvedDependencySyncIssue buildIssue = new UnresolvedDependencySyncIssue(libraryName, message, this.resolverCtx.getProjectPath(), isOfflineWork);
            this.resolverCtx.report(MessageEvent.Kind.ERROR, buildIssue);
        }
        File sourcePath = dependency.getSource();
        if (!unresolved && sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getAbsolutePath());
        }
        if (!unresolved && sourcePath == null) {
            GradleProjectResolverUtil.attachGradleSdkSources(gradleModule, binaryPath, library, this.resolverCtx);
            if (this.resolverCtx instanceof DefaultProjectResolverContext) {
                GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(this.resolverCtx, ((DefaultProjectResolverContext)this.resolverCtx).getGradleUserHome(), library);
            }
        }
        File javadocPath = dependency.getJavadoc();
        if (!unresolved && javadocPath != null) {
            library.addPath(LibraryPathType.DOC, javadocPath.getAbsolutePath());
        }
        if (level == LibraryLevel.PROJECT && !GradleProjectResolverUtil.linkProjectLibrary(this.resolverCtx, ideProject, library)) {
            level = LibraryLevel.MODULE;
        }
        return new LibraryDependencyData((ModuleData)ownerModule.getData(), library, level);
    }

    private String chooseName(File path, LibraryLevel level, DataNode<ProjectData> ideProject) {
        String candidateName;
        DataNode libraryData;
        String fileName = FileUtilRt.getNameWithoutExtension((String)path.getName());
        if (level == LibraryLevel.MODULE) {
            return fileName;
        }
        int count = 0;
        while ((libraryData = ExternalSystemApiUtil.find(ideProject, (Key)ProjectKeys.LIBRARY, arg_0 -> CommonGradleProjectResolverExtension.lambda$chooseName$11(candidateName = fileName + (count == 0 ? "" : "_" + count), arg_0))) != null) {
            if (((LibraryData)libraryData.getData()).getPaths(LibraryPathType.BINARY).contains(FileUtil.toSystemIndependentName((String)path.getAbsolutePath()))) {
                return candidateName;
            }
            ++count;
        }
        return candidateName;
    }

    private static /* synthetic */ boolean lambda$chooseName$11(String candidateName, DataNode node) {
        return ((LibraryData)node.getData()).getExternalName().equals(candidateName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 27: 
            case 28: 
            case 46: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 27: 
            case 28: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 1: 
            case 42: 
            case 45: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 30: 
            case 34: 
            case 40: 
            case 43: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 27: 
            case 28: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaModule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkVersionString";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 16: 
            case 18: 
            case 22: 
            case 32: 
            case 35: 
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 23: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDirectories";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectories";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notResourceDirs";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptConsumer";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootIndex";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 56: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredModulesIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/CommonGradleProjectResolverExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeModuleGroup";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExplicitNonResourceDirectories";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "populateModuleTasks";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 27: 
            case 28: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectSdkModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleSdkModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findJdkByName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findJdkByVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getJdkName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleContentRoots";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProject";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addExternalProjectContentRoots";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicateResources";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processSourceSets";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleCompileOutputSettings";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getGradleOutputDir";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "excludeOutDir";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleDependencies";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleTasks";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "enhanceTaskProcessing";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "populateContentRoot";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "buildDependency";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyModuleByReflection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 27: 
            case 28: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface SourceSetsProcessor {
        public void process(@NotNull DataNode<? extends ModuleData> var1, @NotNull ExternalSourceSet var2);
    }
}

