/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.StatusEvent;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;

public class GradleProgressListener
implements org.gradle.tooling.ProgressListener,
ProgressListener {
    private final ExternalSystemTaskNotificationListener myListener;
    private final ExternalSystemTaskId myTaskId;
    private final Map<Object, Long> myStatusEventIds;
    private final String myOperationId;
    private static final String STARTING_GRADLE_DAEMON_EVENT = "Starting Gradle Daemon";
    private ExternalSystemTaskNotificationEvent myLastStatusChange;

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener, @NotNull ExternalSystemTaskId taskId) {
        if (listener == null) {
            GradleProgressListener.$$$reportNull$$$0(0);
        }
        if (taskId == null) {
            GradleProgressListener.$$$reportNull$$$0(1);
        }
        this(listener, taskId, null);
    }

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener, @NotNull ExternalSystemTaskId taskId, @Nullable String buildRootDir) {
        if (listener == null) {
            GradleProgressListener.$$$reportNull$$$0(2);
        }
        if (taskId == null) {
            GradleProgressListener.$$$reportNull$$$0(3);
        }
        this.myStatusEventIds = new HashMap<Object, Long>();
        this.myLastStatusChange = null;
        this.myListener = listener;
        this.myTaskId = taskId;
        this.myOperationId = taskId.hashCode() + FileUtil.pathHashCode((String)(buildRootDir == null ? UUID.randomUUID().toString() : buildRootDir)) + "_";
    }

    public void statusChanged(ProgressEvent event) {
        GradleProgressEventConverter.EventId eventId = GradleProgressEventConverter.getEventId(event, this.myOperationId);
        ExternalSystemTaskNotificationEvent progressBuildEvent = GradleProgressEventConverter.createProgressBuildEvent(this.myTaskId, this.myTaskId, event);
        this.sendProgressToOutputIfNeeded(event);
        if (progressBuildEvent != null && event instanceof StatusEvent) {
            this.myListener.onStatusChange(progressBuildEvent);
        }
        this.maybeUpdateTaskStatus(progressBuildEvent);
        if (event instanceof TaskProgressEvent) {
            ExternalSystemTaskNotificationEvent notificationEvent = GradleProgressEventConverter.convert(this.myTaskId, event, new GradleProgressEventConverter.EventId(eventId.id, this.myTaskId));
            this.myListener.onStatusChange(notificationEvent);
        }
    }

    public void statusChanged(org.gradle.tooling.ProgressEvent event) {
        String eventDescription = event.getDescription();
        ExternalSystemTaskNotificationEvent progressBuildEvent = GradleProgressEventConverter.legacyCreateProgressBuildEvent(this.myTaskId, this.myTaskId, eventDescription);
        this.maybeUpdateTaskStatus(progressBuildEvent);
        this.myListener.onStatusChange(new ExternalSystemTaskNotificationEvent(this.myTaskId, eventDescription));
        this.reportGradleDaemonStartingEvent(eventDescription);
    }

    private void maybeUpdateTaskStatus(@Nullable ExternalSystemTaskNotificationEvent progressBuildEvent) {
        if (progressBuildEvent != null && !progressBuildEvent.equals((Object)this.myLastStatusChange)) {
            this.myListener.onStatusChange(progressBuildEvent);
            this.myLastStatusChange = progressBuildEvent;
        }
    }

    private void sendProgressToOutputIfNeeded(ProgressEvent progressEvent) {
        String operationName = progressEvent.getDescriptor().getName();
        if (progressEvent instanceof StatusEvent) {
            StatusEvent statusEvent = (StatusEvent)progressEvent;
            if ("bytes".equals(statusEvent.getUnit())) {
                Long oldProgress = this.myStatusEventIds.get(operationName);
                if (oldProgress == null) {
                    String totalSizeInfo = statusEvent.getTotal() > 0L ? " (" + StringUtil.formatFileSize((long)statusEvent.getTotal()) + ")" : "";
                    this.myListener.onTaskOutput(this.myTaskId, operationName + totalSizeInfo + "\n", true);
                    this.myStatusEventIds.put(operationName, 0L);
                } else {
                    double fraction = (double)statusEvent.getProgress() / (double)statusEvent.getTotal();
                    int progressBarSize = 14;
                    int progress = (int)(fraction * (double)progressBarSize + 0.5);
                    if (oldProgress != (long)progress) {
                        this.myStatusEventIds.put(operationName, Long.valueOf(progress));
                        if (statusEvent.getTotal() > 0L) {
                            int remaining = progressBarSize - progress;
                            remaining = Math.max(remaining, 0);
                            int offset = 3 - ((int)Math.log10(fraction * 100.0) + 1);
                            offset = Math.max(offset, 0);
                            this.myListener.onTaskOutput(this.myTaskId, "\r[" + StringUtil.repeat((String)" ", (int)offset) + (int)(fraction * 100.0) + "%" + ']' + " [ " + StringUtil.repeat((String)"=", (int)(progress * 4 - 3)) + ">" + StringUtil.repeat((String)" ", (int)(remaining * 4)) + " ] " + StringUtil.formatFileSize((long)statusEvent.getProgress()), true);
                        } else {
                            this.myListener.onTaskOutput(this.myTaskId, StringUtil.formatFileSize((long)statusEvent.getProgress()) + "\n", true);
                        }
                    }
                }
            }
        } else if (progressEvent instanceof FinishEvent) {
            FinishEvent finishEvent = (FinishEvent)progressEvent;
            if (this.myStatusEventIds.containsKey(operationName)) {
                OperationResult operationResult = finishEvent.getResult();
                String duration = StringUtil.formatDuration((long)(operationResult.getEndTime() - operationResult.getStartTime()));
                this.myListener.onTaskOutput(this.myTaskId, "\r" + finishEvent.getDisplayName() + " succeeded, took " + duration + "\n", true);
                this.myStatusEventIds.remove(operationName);
            }
        }
    }

    private void reportGradleDaemonStartingEvent(String eventDescription) {
        if (StringUtil.equals((CharSequence)STARTING_GRADLE_DAEMON_EVENT, (CharSequence)eventDescription)) {
            long eventTime = System.currentTimeMillis();
            Long startTime = this.myStatusEventIds.remove(eventDescription);
            if (startTime == null) {
                this.myListener.onTaskOutput(this.myTaskId, "Starting Gradle Daemon...\n", true);
                this.myStatusEventIds.put(eventDescription, eventTime);
            } else {
                String duration = StringUtil.formatDuration((long)(eventTime - startTime));
                this.myListener.onTaskOutput(this.myTaskId, "\rGradle Daemon started in " + duration + "\n", true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "taskId";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressListener";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

