/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyBuildIssue;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/output/GradleBuildScriptErrorParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "checkUnresolvedDependencyError", "Lcom/intellij/build/events/BuildEvent;", "reason", "", "description", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parentId", "", "getReasonAndFilePosition", "Lkotlin/Pair;", "Lcom/intellij/build/FilePosition;", "errorText", "filter", "Lorg/jetbrains/plugins/gradle/execution/GradleConsoleFilter;", "getStartupErrorReasonAndFilePosition", "parse", "", "line", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "intellij.gradle.common"})
public final class GradleBuildScriptErrorParser
implements BuildOutputParser {
    /*
     * WARNING - void declaration
     */
    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        CharSequence nextLine;
        boolean bl;
        String nextLine2;
        CharSequence charSequence;
        void reason;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(messageConsumer, (String)"messageConsumer");
        if (!StringsKt.startsWith$default((String)line, (String)"FAILURE: Build failed with an exception.", (boolean)false, (int)2, null)) {
            return false;
        }
        CharSequence charSequence2 = reader.readLine();
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            return false;
        }
        String location = null;
        GradleConsoleFilter filter = null;
        String whereOrWhatLine = reader.readLine();
        if (Intrinsics.areEqual((Object)whereOrWhatLine, (Object)"* Where:")) {
            String string = reader.readLine();
            if (string == null) {
                return false;
            }
            location = string;
            filter = new GradleConsoleFilter(null);
            if (filter.applyFilter(location, location.length()) == null) {
                return false;
            }
            CharSequence charSequence3 = reader.readLine();
            boolean bl5 = false;
            bl2 = false;
            if (!(charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3))) {
                return false;
            }
            whereOrWhatLine = reader.readLine();
        } else {
            location = null;
            filter = null;
        }
        if (Intrinsics.areEqual((Object)whereOrWhatLine, (Object)"* What went wrong:") ^ true) {
            return false;
        }
        StringBuilder description = new StringBuilder();
        if (location != null) {
            StringBuilder stringBuilder = description;
            bl2 = false;
            StringBuilder stringBuilder2 = stringBuilder.append(location);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)StringsKt.appendln((StringBuilder)stringBuilder2));
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        String string = reader.readLine();
        if (string == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.readLine() ?: return false");
        objectRef.element = string;
        Object parentId = null;
        if (StringsKt.startsWith$default((String)((String)reason.element), (String)"Execution failed for task '", (boolean)false, (int)2, null)) {
            parentId = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)((String)reason.element), (String)"Execution failed for task '", null, (int)2, null), (String)"'.", null, (int)2, null);
        } else {
            Object object = reader.getParentEventId();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"reader.parentEventId");
            parentId = object;
        }
        StringBuilder stringBuilder = description;
        CharSequence charSequence4 = (String)reason.element;
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder.append((String)charSequence4);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        do {
            if (reader.readLine() == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)nextLine2, (String)"reader.readLine() ?: return false");
            if (StringsKt.isBlank((CharSequence)nextLine2)) break;
            charSequence4 = description;
            bl6 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)charSequence4).append(nextLine2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            charSequence = nextLine2;
            bl = false;
            String string2 = charSequence;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String trimStart = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
            if (StringsKt.startsWith$default((String)trimStart, (String)"> ", (boolean)false, (int)2, null)) {
                reason.element = StringsKt.trimEnd((String)StringsKt.substringAfter$default((String)trimStart, (String)"> ", null, (int)2, null), (char[])new char[]{'.'});
            }
            charSequence = nextLine2;
            bl = false;
        } while (!(charSequence.length() == 0) && !Intrinsics.areEqual((Object)nextLine2, (Object)"* Try:"));
        StringBuilder exception = null;
        do {
            StringBuilder stringBuilder5;
            if (reader.readLine() == null) {
                break;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)nextLine, (String)"reader.readLine() ?: break");
            if (Intrinsics.areEqual((Object)nextLine, (Object)"* Exception is:")) {
                exception = StringsKt.appendln((StringBuilder)new StringBuilder((String)nextLine));
                continue;
            }
            if (exception == null) continue;
            bl = false;
            StringBuilder stringBuilder6 = stringBuilder5.append((String)nextLine);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        } while (!Intrinsics.areEqual((Object)nextLine, (Object)"BUILD FAILED"));
        StringBuilder stringBuilder7 = exception;
        if (stringBuilder7 != null) {
            nextLine = stringBuilder7;
            bl6 = false;
            bl = false;
            CharSequence it = nextLine;
            boolean bl7 = false;
            StringsKt.appendln((StringBuilder)description).append(it);
        }
        if (StringsKt.startsWith$default((String)((String)reason.element), (String)"Compilation failed", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)((String)reason.element), (Object)"Compilation error. See log for more details") || Intrinsics.areEqual((Object)((String)reason.element), (Object)"Script compilation error:") || StringsKt.contains$default((CharSequence)((String)reason.element), (CharSequence)"compiler failed", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)((String)reason.element), (String)"Could not create service of type ", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)((String)reason.element), (CharSequence)" using BuildScopeServices.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.contains$default((CharSequence)((String)reason.element), (CharSequence)"Build cancelled.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (location != null && filter != null) {
            String string3 = description.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"description.toString()");
            String errorText = string3;
            Pair<String, FilePosition> reasonAndFilePosition = this.getReasonAndFilePosition((String)reason.element, errorText, filter);
            reason.element = (String)reasonAndFilePosition.getFirst();
            FilePosition filePosition = (FilePosition)reasonAndFilePosition.getSecond();
            messageConsumer.accept((BuildEvent)new DuplicateMessageAware(parentId, (Ref.ObjectRef)reason, errorText, filePosition, parentId, MessageEvent.Kind.ERROR, null, (String)reason.element, errorText, filePosition){
                final /* synthetic */ Object $parentId;
                final /* synthetic */ Ref.ObjectRef $reason;
                final /* synthetic */ String $errorText;
                final /* synthetic */ FilePosition $filePosition;
                {
                    this.$parentId = $captured_local_variable$0;
                    this.$reason = $captured_local_variable$1;
                    this.$errorText = $captured_local_variable$2;
                    this.$filePosition = $captured_local_variable$3;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9);
                }
            });
        } else {
            BuildEvent unresolvedMessageEvent = this.checkUnresolvedDependencyError((String)reason.element, description, parentId);
            if (unresolvedMessageEvent != null) {
                messageConsumer.accept((BuildEvent)unresolvedMessageEvent);
            } else {
                messageConsumer.accept((BuildEvent)new DuplicateMessageAware(parentId, (Ref.ObjectRef)reason, description, parentId, MessageEvent.Kind.ERROR, null, (String)reason.element, description.toString()){
                    final /* synthetic */ Object $parentId;
                    final /* synthetic */ Ref.ObjectRef $reason;
                    final /* synthetic */ StringBuilder $description;
                    {
                        this.$parentId = $captured_local_variable$0;
                        this.$reason = $captured_local_variable$1;
                        this.$description = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
                    }
                });
            }
        }
        return true;
    }

    private final Pair<String, FilePosition> getReasonAndFilePosition(String reason, String errorText, GradleConsoleFilter filter) {
        Pair<String, FilePosition> startupError;
        if (Intrinsics.areEqual((Object)reason, (Object)"startup failed:") && (startupError = this.getStartupErrorReasonAndFilePosition(errorText, filter)) != null) {
            return startupError;
        }
        return new Pair((Object)reason, (Object)new FilePosition(new File(filter.getFilteredFileName()), filter.getFilteredLineNumber() - 1, 0));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, FilePosition> getStartupErrorReasonAndFilePosition(String errorText, GradleConsoleFilter filter) {
        List list;
        String string;
        block9: {
            block8: {
                string = StringKt.nullize$default((String)StringsKt.substringAfter((String)errorText, (String)"> startup failed:", (String)""), (boolean)false, (int)1, null);
                if (string == null) break block8;
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trimStart((CharSequence)string3)).toString();
                if (string != null && (string = StringsKt.substringBefore$default((String)string, (String)"\n", null, (int)2, null)) != null) break block9;
            }
            return null;
        }
        String locationLine = string;
        String string4 = StringKt.nullize$default((String)StringsKt.substringAfter((String)locationLine, (String)('\'' + filter.getFilteredFileName() + "': " + filter.getFilteredLineNumber() + ": "), (String)""), (boolean)false, (int)1, null);
        if (string4 == null || (string4 = StringsKt.substringBeforeLast$default((String)string4, (String)" @ ", null, (int)2, null)) == null) {
            return null;
        }
        String failedStartupReason = string4;
        String locationPart = StringsKt.substringAfterLast$default((String)locationLine, (String)" @ ", null, (int)2, null);
        Pattern pattern = GradleConsoleFilter.LINE_AND_COLUMN_PATTERN;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"GradleConsoleFilter.LINE_AND_COLUMN_PATTERN");
        Pattern pattern2 = pattern;
        boolean bl = false;
        MatchResult matchResult = new Regex(pattern2).matchEntire((CharSequence)locationPart);
        Object object = matchResult;
        if (object != null && (object = object.getGroupValues()) != null && (object = CollectionsKt.drop((Iterable)((Iterable)object), (int)1)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string5 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var17_20 = it;
                boolean bl3 = false;
                Integer n = Integer.parseInt((String)var17_20);
                collection.add(n);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object[])new Integer[]{filter.getFilteredLineNumber(), 0});
        }
        List values = list;
        int line = ((Number)values.get(0)).intValue() - 1;
        int column = ((Number)values.get(1)).intValue();
        return new Pair((Object)failedStartupReason, (Object)new FilePosition(new File(filter.getFilteredFileName()), line, column));
    }

    private final BuildEvent checkUnresolvedDependencyError(String reason, StringBuilder description, Object parentId) {
        String string;
        boolean bl;
        int n;
        String string2;
        String noCachedVersionPrefix = "No cached version of ";
        String couldNotFindPrefix = "Could not find ";
        String cannotResolvePrefix = "Cannot resolve external dependency ";
        String cannotDownloadPrefix = "Could not download ";
        String string3 = StringsKt.startsWith$default((String)reason, (String)noCachedVersionPrefix, (boolean)false, (int)2, null) ? noCachedVersionPrefix : (StringsKt.startsWith$default((String)reason, (String)couldNotFindPrefix, (boolean)false, (int)2, null) ? couldNotFindPrefix : (StringsKt.startsWith$default((String)reason, (String)cannotResolvePrefix, (boolean)false, (int)2, null) ? cannotResolvePrefix : (StringsKt.startsWith$default((String)reason, (String)cannotDownloadPrefix, (boolean)false, (int)2, null) ? cannotDownloadPrefix : null)));
        if (string3 == null) {
            return null;
        }
        String prefix = string3;
        int indexOfSuffix = StringsKt.indexOf$default((CharSequence)reason, (String)" available for offline mode", (int)0, (boolean)false, (int)6, null);
        if (indexOfSuffix > 0) {
            string2 = reason;
            n = prefix.length();
            bl = false;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, indexOfSuffix);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = reason;
            n = prefix.length();
            bl = false;
            String string6 = string2;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        }
        String dependencyName = string;
        UnresolvedDependencyBuildIssue unresolvedDependencyIssue = new UnresolvedDependencyBuildIssue(dependencyName, description.toString(), indexOfSuffix > 0);
        return (BuildEvent)new BuildIssueEventImpl(parentId, (BuildIssue)unresolvedDependencyIssue, MessageEvent.Kind.ERROR);
    }
}

