/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.finder;

import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.core.ComponentFoundCondition;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.NameMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.fixture.AbstractComponentFixture;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public abstract class ComponentFinderTemplate<T extends Component> {
    static final long TIMEOUT = 5000L;
    private long timeout = 5000L;
    private final ComponentMatcher matcher;
    private final String searchDescription;

    protected ComponentFinderTemplate(@Nullable String componentName, @Nonnull Class<? extends T> componentType) {
        this(new NameMatcher(componentName, componentType, true));
    }

    protected ComponentFinderTemplate(@Nonnull GenericTypeMatcher<? extends T> matcher) {
        this((ComponentMatcher)matcher);
    }

    protected ComponentFinderTemplate(@Nonnull Class<? extends T> componentType) {
        this(new TypeMatcher(componentType, true));
    }

    private ComponentFinderTemplate(@Nonnull ComponentMatcher matcher) {
        this.matcher = (ComponentMatcher)Preconditions.checkNotNull((Object)matcher);
        this.searchDescription = Strings.concat((Object[])new Object[]{"component to be found using matcher ", matcher});
    }

    protected ComponentFinderTemplate<T> withTimeout(@Nonnegative long newTimeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit));
        return this.withTimeout(unit.toMillis(newTimeout));
    }

    @Nonnull
    protected ComponentFinderTemplate<T> withTimeout(@Nonnegative long newTimeout) {
        if (newTimeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
        this.timeout = newTimeout;
        return this;
    }

    @Nonnull
    public abstract AbstractComponentFixture<?, T, ?> using(@Nonnull Robot var1);

    @Nonnull
    protected final T findComponentWith(@Nonnull Robot robot) {
        ComponentFoundCondition condition = new ComponentFoundCondition(this.searchDescription, robot.finder(), this.matcher);
        Pause.pause((Condition)condition, this.timeout);
        return (T)((Component)Preconditions.checkNotNull(this.cast(condition.found())));
    }

    @Nullable
    protected abstract T cast(@Nullable Component var1);
}

