/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.JListCellBoundsQuery;
import org.fest.swing.driver.JListCellCenterQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Sets;

final class JListMatchingItemQuery {
    @Nonnull
    @RunsInEDT
    static Point centerOfMatchingItemCell(final @Nonnull JList list, final @Nullable String value, final @Nonnull JListCellReader cellReader) {
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                int itemIndex = JListMatchingItemQuery.matchingItemIndex(list, new StringTextMatcher(value), cellReader);
                Rectangle cellBounds = (Rectangle)Preconditions.checkNotNull((Object)JListCellBoundsQuery.cellBounds(list, itemIndex));
                return JListCellCenterQuery.cellCenter(list, cellBounds);
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @RunsInCurrentThread
    static int matchingItemIndex(@Nonnull JList list, @Nonnull TextMatcher matcher, @Nonnull JListCellReader cellReader) {
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            if (!matcher.isMatching(cellReader.valueAt(list, i))) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    @RunsInEDT
    static List<Integer> matchingItemIndices(final @Nonnull JList list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        List<Integer> result = GuiActionRunner.execute(new GuiQuery<List<Integer>>(){

            @Override
            protected List<Integer> executeInEDT() {
                HashSet indices = Sets.newHashSet();
                int size = list.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    if (!matcher.isMatching(cellReader.valueAt(list, i))) continue;
                    indices.add(i);
                }
                ArrayList indexList = Lists.newArrayList((Iterable)indices);
                Collections.sort(indexList);
                return indexList;
            }
        });
        return (List)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInEDT
    static List<String> matchingItemValues(final @Nonnull JList list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        List<String> result = GuiActionRunner.execute(new GuiQuery<List<String>>(){

            @Override
            protected List<String> executeInEDT() {
                ArrayList values = Lists.newArrayList();
                int size = list.getModel().getSize();
                for (int i = 0; i < size; ++i) {
                    String value = cellReader.valueAt(list, i);
                    if (!matcher.isMatching(value)) continue;
                    values.add(value);
                }
                return values;
            }
        });
        return (List)Preconditions.checkNotNull(result);
    }

    private JListMatchingItemQuery() {
    }
}

