/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.kapt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ReflectionUtilKt;
import org.jetbrains.kotlin.utils.kapt.ClassLoaderData;
import org.jetbrains.kotlin.utils.kapt.MemoryLeak;
import org.jetbrains.kotlin.utils.kapt.MemoryLeakDetectorKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/utils/kapt/MemoryLeakDetector;", "", "()V", "classLoaderData", "", "Lorg/jetbrains/kotlin/utils/kapt/ClassLoaderData;", "add", "", "classLoader", "Ljava/lang/ClassLoader;", "inspectStatics", "", "Lorg/jetbrains/kotlin/utils/kapt/MemoryLeak;", "process", "isParanoid", "", "util"})
public final class MemoryLeakDetector {
    private static final List<ClassLoaderData> classLoaderData;
    public static final MemoryLeakDetector INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        List<ClassLoaderData> list2 = classLoaderData;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list2) {
            boolean bl3 = false;
            bl2 = classLoaderData.add(new ClassLoaderData(classLoader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<MemoryLeak> process(boolean isParanoid) {
        boolean bl = false;
        Set memoryLeaks = new LinkedHashSet();
        List<ClassLoaderData> list2 = classLoaderData;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (list2) {
            boolean bl4 = false;
            boolean bl5 = false;
            List newClassLoaderData = new ArrayList();
            for (ClassLoaderData data2 : classLoaderData) {
                ClassLoader classLoader;
                if ((ClassLoader)data2.getRef().get() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"data.ref.get() ?: continue");
                ClassLoaderData classLoaderData = data2;
                classLoaderData.setAge(classLoaderData.getAge() + 1);
                if (isParanoid || data2.getAge() >= 5) {
                    INSTANCE.inspectStatics(classLoader);
                    continue;
                }
                Collection collection = newClassLoaderData;
                boolean bl6 = false;
                collection.add(data2);
            }
            classLoaderData.clear();
            bl3 = classLoaderData.addAll(newClassLoaderData);
        }
        return memoryLeaks;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MemoryLeak> inspectStatics(ClassLoader classLoader) {
        Set $this$mapTo$iv;
        Vector loadedClasses = MemoryLeakDetectorKt.access$loadedClasses(classLoader);
        try {
            Iterable iterable = loadedClasses;
            boolean bl = false;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void var19_13;
                void it;
                Class clazz = (Class)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                collection.add(var19_13);
            }
            $this$mapTo$iv = (Set)destination$iv;
        }
        catch (ConcurrentModificationException e) {
            Thread.sleep(100L);
            return this.inspectStatics(classLoader);
        }
        Set loadedClassesSet = $this$mapTo$iv;
        boolean e = false;
        Set leaks = new LinkedHashSet();
        for (Class clazz : loadedClassesSet) {
            Object declaredFields;
            Object item$iv;
            try {
                item$iv = clazz.getDeclaredFields();
            }
            catch (Throwable e2) {
                continue;
            }
            Object object = declaredFields = item$iv;
            int n = ((T)object).length;
            for (int j = 0; j < n; ++j) {
                Object field2;
                Object t = field2 = object[j];
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"field");
                if (!Modifier.isStatic(((Field)t).getModifiers())) continue;
                Object object2 = ReflectionUtilKt.getSafe(field2, null);
                if (object2 == null) continue;
                Object object3 = object2;
                boolean bl = false;
                boolean bl3 = false;
                Object it = object3;
                boolean bl4 = false;
                object2 = !MemoryLeakDetectorKt.access$isPrimitiveOrString(it) ? object3 : null;
                if (object2 == null) {
                    continue;
                }
                Object value2 = object2;
                if (MemoryLeakDetectorKt.access$isJavacComponent(value2)) {
                    object3 = leaks;
                    String string = clazz.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clazz.name");
                    String string2 = ((Field)field2).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"field.name");
                    MemoryLeak memoryLeak = new MemoryLeak(string, string2, "Field leaks an Annotation Processing component (" + value2 + ").");
                    bl3 = false;
                    object3.add(memoryLeak);
                    continue;
                }
                if (!(value2 instanceof Class) || !loadedClassesSet.contains(value2)) continue;
                object3 = leaks;
                String string = clazz.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clazz.name");
                String string3 = ((Field)field2).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"field.name");
                MemoryLeak memoryLeak = new MemoryLeak(string, string3, "Field leaks a class type from the same ClassLoader (" + ((Class)value2).getName() + ").");
                bl3 = false;
                object3.add(memoryLeak);
            }
        }
        return leaks;
    }

    private MemoryLeakDetector() {
    }

    static {
        MemoryLeakDetector memoryLeakDetector;
        INSTANCE = memoryLeakDetector = new MemoryLeakDetector();
        boolean bl = false;
        classLoaderData = new ArrayList();
    }
}

