/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public class JavaAnnotationImpl
extends JavaElementImpl<PsiAnnotation>
implements JavaAnnotation {
    public JavaAnnotationImpl(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(0);
        }
        super(psiAnnotation);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotationArgument> getArguments() {
        Collection<JavaAnnotationArgument> collection = JavaElementCollectionFromPsiArrayUtil.namedAnnotationArguments(((PsiAnnotation)this.getPsi()).getParameterList().getAttributes());
        if (collection == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @Nullable
    public ClassId getClassId() {
        PsiClass resolved2 = this.resolvePsi();
        if (resolved2 != null) {
            return JavaAnnotationImpl.computeClassId(resolved2);
        }
        String qualifiedName2 = ((PsiAnnotation)this.getPsi()).getQualifiedName();
        if (qualifiedName2 != null) {
            return ClassId.topLevel(new FqName(qualifiedName2));
        }
        return null;
    }

    @Override
    @Nullable
    public JavaClass resolve() {
        PsiClass resolved2 = this.resolvePsi();
        return resolved2 == null ? null : new JavaClassImpl(resolved2);
    }

    @Nullable
    private static ClassId computeClassId(@NotNull PsiClass psiClass2) {
        PsiClass container2;
        if (psiClass2 == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(2);
        }
        if ((container2 = psiClass2.getContainingClass()) != null) {
            ClassId parentClassId = JavaAnnotationImpl.computeClassId(container2);
            String name2 = psiClass2.getName();
            return parentClassId == null || name2 == null ? null : parentClassId.createNestedClassId(Name.identifier(name2));
        }
        String fqName2 = psiClass2.getQualifiedName();
        return fqName2 == null ? null : ClassId.topLevel(new FqName(fqName2));
    }

    @Nullable
    private PsiClass resolvePsi() {
        PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)this.getPsi()).getNameReferenceElement();
        if (referenceElement == null) {
            return null;
        }
        PsiElement resolved2 = referenceElement.resolve();
        return resolved2 instanceof PsiClass ? (PsiClass)resolved2 : null;
    }

    @Override
    public boolean isIdeExternalAnnotation() {
        PsiAnnotation psi2 = (PsiAnnotation)this.getPsi();
        ExternalAnnotationsManager externalAnnotationManager = ExternalAnnotationsManager.getInstance((Project)psi2.getProject());
        return externalAnnotationManager.isExternalAnnotation(psi2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/structure/impl/JavaAnnotationImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/structure/impl/JavaAnnotationImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeClassId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

