/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathsList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtCompilingExecutor;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchExecutionSession;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bJL\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0002J\u0006\u0010#\u001a\u00020\u0019J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession;", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "executor", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;)V", "backgroundProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compileFileToTempDir", "Ljava/io/File;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "originalFile", "module", "Lcom/intellij/openapi/module/Module;", "mainClassName", "", "tempOutDir", "execute", "", "callback", "Lkotlin/Function0;", "runCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "modifiedScratchSourceFile", "result", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "indicator", "stop", "writeClassFilesToTempDir", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "Companion", "idea-jvm"})
public final class KtScratchExecutionSession {
    private volatile ProgressIndicator backgroundProcessIndicator;
    private final ScratchFile file;
    private final KtCompilingExecutor executor;
    private static final int TIMEOUT_MS = 30000;
    public static final Companion Companion = new Companion(null);

    public final void execute(@NotNull Function0<Unit> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        PsiFile psiFile2 = this.file.getPsiFile();
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.find.ktfile.for.current.editor", new Object[0]), null, true, 2, null);
            return;
        }
        KtFile psiFile3 = ktFile;
        List<ScratchExpression> expressions2 = this.file.getExpressions();
        if (!this.executor.checkForErrors(psiFile3, expressions2)) {
            return;
        }
        Project project2 = this.file.getProject();
        ReadAction.nonBlocking((Runnable)new Runnable(this, expressions2, psiFile3, project2, callback2){
            final /* synthetic */ KtScratchExecutionSession this$0;
            final /* synthetic */ List $expressions;
            final /* synthetic */ KtFile $psiFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function0 $callback;

            public final void run() {
                block1: {
                    KtScratchSourceFileProcessor.Result result2 = new KtScratchSourceFileProcessor().process(this.$expressions);
                    if (result2 instanceof KtScratchSourceFileProcessor.Result.Error) {
                        ScratchExecutor.errorOccurs$default(KtScratchExecutionSession.access$getExecutor$p(this.this$0), ((KtScratchSourceFileProcessor.Result.Error)result2).getMessage(), null, true, 2, null);
                        return;
                    }
                    if (!(result2 instanceof KtScratchSourceFileProcessor.Result.OK)) break block1;
                    ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "After processing by KtScratchSourceFileProcessor:\n " + ((KtScratchSourceFileProcessor.Result.OK)result2).getCode());
                    new Task.Backgroundable(this, result2, this.$psiFile.getProject(), KotlinJvmBundle.message("running.kotlin.scratch", new Object[0]), true){
                        final /* synthetic */ execute.1 this$0;
                        final /* synthetic */ KtScratchSourceFileProcessor.Result $result;

                        public void run(@NotNull ProgressIndicator indicator) {
                            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                            KtScratchExecutionSession.access$setBackgroundProcessIndicator$p(this.this$0.this$0, indicator);
                            KtFile modifiedScratchSourceFile2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>(this){
                                final /* synthetic */ execute.1 this$0;

                                @NotNull
                                public final KtFile invoke() {
                                    Project project2 = this.this$0.this$0.$psiFile.getProject();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"psiFile.project");
                                    return new KtPsiFactory(project2, false, 2, null).createFileWithLightClassSupport("tmp.kt", ((KtScratchSourceFileProcessor.Result.OK)this.this$0.$result).getCode(), (PsiElement)this.this$0.this$0.$psiFile);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                            try {
                                KtScratchExecutionSession.access$runCommandLine(this.this$0.this$0, this.this$0.$project, modifiedScratchSourceFile2, this.this$0.$expressions, this.this$0.$psiFile, (KtScratchSourceFileProcessor.Result.OK)this.$result, indicator, this.this$0.$callback);
                            }
                            catch (Throwable e) {
                                if (e instanceof ControlFlowException) {
                                    throw e;
                                }
                                ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), ((KtScratchSourceFileProcessor.Result.OK)this.$result).getCode());
                                KtCompilingExecutor ktCompilingExecutor = KtScratchExecutionSession.access$getExecutor$p(this.this$0.this$0);
                                String string = e.getMessage();
                                if (string == null) {
                                    Object[] objectArray = new Object[1];
                                    String string2 = this.this$0.$psiFile.getName();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"psiFile.name");
                                    objectArray[0] = string2;
                                    string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
                                }
                                ktCompilingExecutor.errorOccurs(string, e, true);
                            }
                        }
                        {
                            this.this$0 = $outer;
                            this.$result = $captured_local_variable$1;
                            super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                        }
                    }.queue();
                }
            }
            {
                this.this$0 = ktScratchExecutionSession;
                this.$expressions = list2;
                this.$psiFile = ktFile;
                this.$project = project2;
                this.$callback = function0;
            }
        }).inSmartMode(project2).expireWith((Disposable)project2).withDocumentsCommitted(project2).submit((Executor)NonUrgentExecutor.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runCommandLine(Project project2, KtFile modifiedScratchSourceFile2, List<ScratchExpression> expressions2, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, ProgressIndicator indicator, Function0<Unit> callback2) {
        File file2 = (File)DumbService.getInstance((Project)project2).runReadActionInSmartMode((Computable)new Computable<File>(this, modifiedScratchSourceFile2, expressions2){
            final /* synthetic */ KtScratchExecutionSession this$0;
            final /* synthetic */ KtFile $modifiedScratchSourceFile;
            final /* synthetic */ List $expressions;

            @Nullable
            public final File compute() {
                return KtScratchExecutionSession.access$compileFileToTempDir(this.this$0, this.$modifiedScratchSourceFile, this.$expressions);
            }
            {
                this.this$0 = ktScratchExecutionSession;
                this.$modifiedScratchSourceFile = ktFile;
                this.$expressions = list2;
            }
        });
        if (file2 == null) {
            return;
        }
        File tempDir2 = file2;
        try {
            Module module = this.file.getModule();
            String string = result2.getMainClassName();
            String string2 = tempDir2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tempDir.path");
            GeneralCommandLine commandLine = this.createCommandLine(psiFile2, module, string, string2);
            Logger logger = ScratchUtilsKt.getLOG();
            String string3 = commandLine.getCommandLineString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"commandLine.commandLineString");
            ScratchUtilsKt.printDebugMessage(logger, string3);
            CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator, 30000);
            Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"processHandler.runProces\u2026or(indicator, TIMEOUT_MS)");
            ProcessOutput executionResult = processOutput;
            if (executionResult.isTimeout()) {
                ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.get.scratch.execution.result.stopped.by.timeout.0.ms", 30000), null, false, 6, null);
            } else if (executionResult.isCancelled()) {
            } else {
                this.executor.parseOutput(executionResult, expressions2);
            }
        }
        finally {
            tempDir2.delete();
            callback2.invoke();
        }
    }

    public final void stop() {
        block0: {
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            if (progressIndicator == null) break block0;
            progressIndicator.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File compileFileToTempDir(KtFile psiFile2, List<ScratchExpression> expressions2) {
        void bindingContext2;
        if (!this.executor.checkForErrors(psiFile2, expressions2)) {
            return null;
        }
        ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade((KtElement)psiFile2);
        Pair pair2 = DebuggerUtils.analyzeInlinedFunctions$default(DebuggerUtils.INSTANCE, resolutionFacade2, psiFile2, false, null, 8, null);
        BindingContext bindingContext3 = (BindingContext)pair2.component1();
        List files2 = (List)pair2.component2();
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Analyzed files: \n" + CollectionsKt.joinToString$default((Iterable)files2, (CharSequence)"\n", null, null, (int)0, null, (Function1)compileFileToTempDir.1.INSTANCE, (int)30, null));
        GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(psiFile2){
            final /* synthetic */ KtFile $psiFile;

            public boolean shouldGeneratePackagePart(@NotNull KtFile ktFile) {
                Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
                return Intrinsics.areEqual((Object)ktFile, (Object)this.$psiFile);
            }

            public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
                Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                return true;
            }

            public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
                Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                return Intrinsics.areEqual((Object)processingClassOrObject.getContainingKtFile(), (Object)this.$psiFile);
            }

            public boolean shouldGenerateScript(@NotNull KtScript script) {
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                return false;
            }

            public boolean shouldGenerateCodeFragment(@NotNull KtCodeFragment script) {
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                return false;
            }
            {
                this.$psiFile = $captured_local_variable$0;
            }
        };
        Project project2 = this.file.getProject();
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.BINARIES");
        ModuleDescriptor moduleDescriptor = resolutionFacade2.getModuleDescriptor();
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"CompilerConfiguration.EMPTY");
        GenerationState state = new GenerationState.Builder(project2, classBuilderFactory, moduleDescriptor, (BindingContext)bindingContext2, files2, compilerConfiguration).generateDeclaredClassFilter(generateClassFilter2).build();
        KotlinCodegenFacade.compileCorrectFiles(state);
        return this.writeClassFilesToTempDir(state);
    }

    private final File writeClassFilesToTempDir(GenerationState state) {
        List<OutputFile> list2 = state.getFactory().asList();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"state.factory.asList()");
        List<OutputFile> classFiles = ClassFileUtilsKt.filterClassFiles(list2);
        File file2 = FileUtil.createTempDirectory((String)"compile", (String)"scratch");
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempDirectory(\"compile\", \"scratch\")");
        File dir = file2;
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Temp output dir: " + dir.getPath());
        for (OutputFile classFile : classFiles) {
            File tmpOutFile = new File(dir, classFile.getRelativePath());
            tmpOutFile.getParentFile().mkdirs();
            tmpOutFile.createNewFile();
            FilesKt.writeBytes((File)tmpOutFile, (byte[])classFile.asByteArray());
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Generated class file: " + classFile.getRelativePath());
        }
        return dir;
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine createCommandLine(KtFile originalFile, Module module, String mainClassName, String tempOutDir) {
        Project project2 = originalFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"originalFile.project");
        JavaParameters javaParameters = new JavaParametersBuilder(project2).withSdkFrom(module, true).withMainClassName(mainClassName).build();
        javaParameters.getClassPath().add(tempOutDir);
        if (module != null) {
            javaParameters.getClassPath().addAll(JavaParametersBuilder.Companion.getModuleDependencies(module));
        }
        Project project3 = originalFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"originalFile.project");
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = ScriptConfigurationManager.Companion.getInstance(project3).getConfiguration(originalFile);
        if (scriptCompilationConfigurationWrapper != null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper2 = scriptCompilationConfigurationWrapper;
            boolean bl = false;
            boolean bl2 = false;
            ScriptCompilationConfigurationWrapper it = scriptCompilationConfigurationWrapper2;
            boolean bl3 = false;
            Iterable iterable = it.getDependenciesClassPath();
            PathsList pathsList = javaParameters.getClassPath();
            boolean $i$f$map = false;
            void var14_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void f2;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                String string = f2.getAbsolutePath();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            pathsList.addAll((List)collection);
        }
        GeneralCommandLine generalCommandLine = javaParameters.toCommandLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"javaParameters.toCommandLine()");
        return generalCommandLine;
    }

    public KtScratchExecutionSession(@NotNull ScratchFile file2, @NotNull KtCompilingExecutor executor) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.file = file2;
        this.executor = executor;
    }

    public static final /* synthetic */ KtCompilingExecutor access$getExecutor$p(KtScratchExecutionSession $this) {
        return $this.executor;
    }

    public static final /* synthetic */ ProgressIndicator access$getBackgroundProcessIndicator$p(KtScratchExecutionSession $this) {
        return $this.backgroundProcessIndicator;
    }

    public static final /* synthetic */ void access$setBackgroundProcessIndicator$p(KtScratchExecutionSession $this, ProgressIndicator progressIndicator) {
        $this.backgroundProcessIndicator = progressIndicator;
    }

    public static final /* synthetic */ void access$runCommandLine(KtScratchExecutionSession $this, Project project2, KtFile modifiedScratchSourceFile2, List expressions2, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, ProgressIndicator indicator, Function0 callback2) {
        $this.runCommandLine(project2, modifiedScratchSourceFile2, expressions2, psiFile2, result2, indicator, (Function0<Unit>)callback2);
    }

    public static final /* synthetic */ File access$compileFileToTempDir(KtScratchExecutionSession $this, KtFile psiFile2, List expressions2) {
        return $this.compileFileToTempDir(psiFile2, expressions2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession$Companion;", "", "()V", "TIMEOUT_MS", "", "idea-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

