/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.changePackage.KotlinChangePackageRefactoring;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ChangePackageFix", "MoveFileToPackageFix", "idea"})
public final class PackageDirectoryMismatchInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        return VisitorWrappersKt.packageDirectiveVisitor((Function1<? super KtPackageDirective, Unit>)((Function1)new Function1<KtPackageDirective, Unit>(holder2){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtPackageDirective directive) {
                LocalQuickFix[] localQuickFixArray;
                void $this$toTypedArray$iv;
                TextRange textRange;
                boolean bl;
                FqName fqNameWithImplicitPrefix;
                boolean bl2;
                Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
                KtFile ktFile = directive.getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"directive.containingKtFile");
                KtFile file2 = ktFile;
                if (file2.getTextLength() == 0 || KotlinRefactoringUtilKt.isInjectedFragment((PsiFile)file2) || PackageUtilsKt.packageMatchesDirectoryOrImplicit(file2)) {
                    return;
                }
                boolean bl3 = false;
                List fixes = new ArrayList<E>();
                String string = directive.getQualifiedName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"directive.qualifiedName");
                String qualifiedName2 = string;
                Object object = qualifiedName2;
                boolean bl4 = false;
                String dirName = object.length() == 0 ? "source root" : '\'' + StringsKt.replace$default((String)qualifiedName2, (char)'.', (char)'/', (boolean)false, (int)4, null) + '\'';
                object = fixes;
                Object object2 = new MoveFileToPackageFix(dirName);
                boolean bl5 = false;
                object.add(object2);
                FqName fqNameByDirectory = PackageUtilsKt.getFqNameByDirectory((PsiFile)file2);
                if (fqNameByDirectory.isRoot()) {
                    object2 = fixes;
                    ChangePackageFix changePackageFix = new ChangePackageFix("source root", fqNameByDirectory);
                    bl2 = false;
                    object2.add(changePackageFix);
                } else if (KotlinRefactoringUtilKt.hasIdentifiersOnly(fqNameByDirectory)) {
                    object2 = fixes;
                    ChangePackageFix changePackageFix = new ChangePackageFix('\'' + fqNameByDirectory.asString() + '\'', fqNameByDirectory);
                    bl2 = false;
                    object2.add(changePackageFix);
                }
                PsiDirectory psiDirectory = file2.getParent();
                FqName fqName2 = fqNameWithImplicitPrefix = psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null;
                if (fqNameWithImplicitPrefix != null && Intrinsics.areEqual((Object)fqNameWithImplicitPrefix, (Object)fqNameByDirectory) ^ true) {
                    Collection collection = fixes;
                    ChangePackageFix changePackageFix = new ChangePackageFix('\'' + fqNameWithImplicitPrefix.asString() + '\'', fqNameWithImplicitPrefix);
                    bl = false;
                    collection.add(changePackageFix);
                }
                if (directive.getTextLength() != 0) {
                    textRange = directive.getTextRange();
                } else {
                    KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.firstOrNull(file2.getDeclarations());
                    if (ktDeclaration != null) {
                        KtDeclaration ktDeclaration2 = ktDeclaration;
                        bl = false;
                        boolean bl6 = false;
                        KtDeclaration it = ktDeclaration2;
                        boolean bl7 = false;
                        textRange = TextRange.from((int)PsiUtilsKt.getStartOffset(it), (int)1);
                    } else {
                        textRange = null;
                    }
                }
                TextRange textRange2 = textRange;
                Collection collection = fixes;
                String string2 = KotlinBundle.message("text.package.directive.dont.match.file.location", new Object[0]);
                TextRange textRange3 = textRange2;
                PsiElement psiElement2 = (PsiElement)file2;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                if (localQuickFixArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                problemsHolder.registerProblem(psiElement2, textRange3, string2, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection$MoveFileToPackageFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "dirName", "", "(Ljava/lang/String;)V", "getDirName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "startInWriteAction", "", "idea"})
    private static final class MoveFileToPackageFix
    implements LocalQuickFix {
        @NotNull
        private final String dirName;

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.move.file.to.package.family", new Object[0]);
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("fix.move.file.to.package.text", this.dirName);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtFile)) {
                psiElement2 = null;
            }
            KtFile ktFile = (KtFile)psiElement2;
            if (ktFile == null) {
                return;
            }
            KtFile file2 = ktFile;
            KtPackageDirective ktPackageDirective = file2.getPackageDirective();
            if (ktPackageDirective == null) {
                return;
            }
            KtPackageDirective directive = ktPackageDirective;
            List<VirtualFile> sourceRoots = ProjectRootUtilsKt.getSuitableDestinationSourceRoots(project2);
            PackageWrapper packageWrapper = new PackageWrapper(PsiManager.getInstance((Project)project2), directive.getQualifiedName());
            PsiFile psiFile2 = directive.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"directive.containingFile");
            PsiFile fileToMove = psiFile2;
            VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.singleOrNull(sourceRoots);
            if (virtualFile2 == null) {
                virtualFile2 = MoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)packageWrapper, sourceRoots, (PsiDirectory)fileToMove.getContainingDirectory());
            }
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile chosenRoot = virtualFile2;
            AutocreatingSingleSourceRootMoveDestination targetDirFactory = new AutocreatingSingleSourceRootMoveDestination(packageWrapper, chosenRoot);
            String string = targetDirFactory.verify(fileToMove);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                Messages.showMessageDialog((Project)project2, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            PsiDirectory psiDirectory = (PsiDirectory)ApplicationUtilsKt.runWriteAction((Function0)new Function0<PsiDirectory>(targetDirFactory, fileToMove){
                final /* synthetic */ AutocreatingSingleSourceRootMoveDestination $targetDirFactory;
                final /* synthetic */ PsiFile $fileToMove;

                public final PsiDirectory invoke() {
                    return this.$targetDirFactory.getTargetDirectory(this.$fileToMove);
                }
                {
                    this.$targetDirFactory = autocreatingSingleSourceRootMoveDestination;
                    this.$fileToMove = psiFile2;
                    super(0);
                }
            });
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory targetDirectory2 = psiDirectory;
            String string3 = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)targetDirectory2, (String)file2.getName());
            if (string3 != null) {
                String string4 = string3;
                boolean bl = false;
                boolean bl4 = false;
                String it = string4;
                boolean bl5 = false;
                Messages.showMessageDialog((Project)project2, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(file2, targetDirectory2){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ PsiDirectory $targetDirectory;

                public final void invoke() {
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiFile)this.$file), (PsiDirectory)this.$targetDirectory);
                }
                {
                    this.$file = ktFile;
                    this.$targetDirectory = psiDirectory;
                    super(0);
                }
            });
        }

        @NotNull
        public final String getDirName() {
            return this.dirName;
        }

        public MoveFileToPackageFix(@NotNull String dirName) {
            Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
            this.dirName = dirName;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection$ChangePackageFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "packageName", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackageName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
    private static final class ChangePackageFix
    implements LocalQuickFix {
        @NotNull
        private final String packageName;
        @NotNull
        private final FqName packageFqName;

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("fix.change.package.family", new Object[0]);
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("fix.change.package.text", this.packageName);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtFile)) {
                psiElement2 = null;
            }
            KtFile ktFile = (KtFile)psiElement2;
            if (ktFile == null) {
                return;
            }
            KtFile file2 = ktFile;
            new KotlinChangePackageRefactoring(file2).run(this.packageFqName);
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        public ChangePackageFix(@NotNull String packageName, @NotNull FqName packageFqName) {
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
            this.packageName = packageName;
            this.packageFqName = packageFqName;
        }
    }
}

