/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceArrayOfWithLiteralInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ReplaceWithArrayLiteralFix", "idea"})
public final class ReplaceArrayOfWithLiteralInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor((Function1<? super KtCallExpression, Unit>)((Function1)new Function1<KtCallExpression, Unit>(holder2){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtCallExpression expression2) {
                KtExpression ktExpression;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                if (!PlatformKt.getLanguageVersionSettings((PsiElement)expression2).supportsFeature(LanguageFeature.ArrayLiteralsInAnnotations)) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode()) {
                        return;
                    }
                }
                if (!((ktExpression = expression2.getCalleeExpression()) instanceof KtNameReferenceExpression)) {
                    ktExpression = null;
                }
                KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
                if (ktNameReferenceExpression == null) {
                    return;
                }
                KtNameReferenceExpression calleeExpression2 = ktNameReferenceExpression;
                if (!UtilsKt.isArrayOfMethod(expression2)) {
                    return;
                }
                PsiElement parent2 = expression2.getParent();
                if (parent2 instanceof KtValueArgument) {
                    PsiElement psiElement2 = ((KtValueArgument)parent2).getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent.parent");
                    if (!(psiElement2.getParent() instanceof KtAnnotationEntry)) {
                        return;
                    }
                    if (((KtValueArgument)parent2).getSpreadElement() != null && !((KtValueArgument)parent2).isNamed()) {
                        return;
                    }
                } else if (parent2 instanceof KtParameter) {
                    PsiElement psiElement3 = ((KtParameter)parent2).getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"parent.parent");
                    PsiElement psiElement4 = psiElement3.getParent();
                    if (!(psiElement4 instanceof KtPrimaryConstructor)) {
                        psiElement4 = null;
                    }
                    KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)psiElement4;
                    if (ktPrimaryConstructor == null) {
                        return;
                    }
                    KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
                    KtClassOrObject containingClass2 = constructor2.getContainingClassOrObject();
                    if (!containingClass2.isAnnotation()) {
                        return;
                    }
                } else {
                    return;
                }
                String calleeName = calleeExpression2.getReferencedName();
                this.$holder.registerProblem((PsiElement)calleeExpression2, KotlinBundle.message("0.call.should.be.replaced.with.array.literal", calleeName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithArrayLiteralFix()});
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceArrayOfWithLiteralInspection$ReplaceWithArrayLiteralFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "idea"})
    private static final class ReplaceWithArrayLiteralFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("replace.with.array.literal.fix.family.name", new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            void $this$getParentOfType$iv;
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression calleeExpression2 = (KtExpression)psiElement2;
            PsiElement psiElement3 = calleeExpression2.getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            KtCallExpression callExpression2 = (KtCallExpression)psiElement3;
            PsiElement psiElement4 = (PsiElement)callExpression2;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtValueArgument valueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtValueArgument.class, (boolean)strict$iv);
            KtValueArgument ktValueArgument = valueArgument;
            if (ktValueArgument != null && (ktValueArgument = ktValueArgument.getSpreadElement()) != null) {
                ktValueArgument.delete();
            }
            List<KtValueArgument> list2 = callExpression2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callExpression.valueArguments");
            List<KtValueArgument> arguments2 = list2;
            KtExpression ktExpression = CreateByPatternKt.buildExpression$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callExpression2, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(arguments2){
                final /* synthetic */ List $arguments;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                    Intrinsics.checkParameterIsNotNull($this$buildExpression, (String)"$receiver");
                    $this$buildExpression.appendFixedText("[");
                    boolean bl = false;
                    for (KtValueArgument argument2 : (Iterable)this.$arguments) {
                        void index2;
                        $this$buildExpression.appendExpression(argument2.getArgumentExpression());
                        if (index2 != this.$arguments.size() - 1) {
                            $this$buildExpression.appendFixedText(", ");
                        }
                        ++index2;
                    }
                    $this$buildExpression.appendFixedText("]");
                }
                {
                    this.$arguments = list2;
                    super(1);
                }
            }, 1, null);
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCollectionLiteralExpression");
            }
            KtCollectionLiteralExpression arrayLiteral2 = (KtCollectionLiteralExpression)ktExpression;
            callExpression2.replace((PsiElement)arrayLiteral2);
        }
    }
}

