/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AssignBackingFieldFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
final class AssignBackingFieldFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message("assign.backing.field.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        if (!(psiElement2 instanceof KtPropertyAccessor)) {
            psiElement2 = null;
        }
        KtPropertyAccessor ktPropertyAccessor = (KtPropertyAccessor)psiElement2;
        if (ktPropertyAccessor == null) {
            return;
        }
        KtPropertyAccessor setter2 = ktPropertyAccessor;
        List<KtParameter> list2 = setter2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"setter.valueParameters");
        KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull(list2);
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter = ktParameter;
        KtBlockExpression ktBlockExpression = setter2.getBodyBlockExpression();
        if (ktBlockExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktBlockExpression, (String)"setter.bodyBlockExpression ?: return");
        KtBlockExpression bodyExpression = ktBlockExpression;
        PsiElement psiElement3 = bodyExpression.getLBrace();
        if (psiElement3 != null && (psiElement3 = PsiUtilsKt.siblings$default(psiElement3, false, false, 1, null)) != null && (psiElement3 = SequencesKt.takeWhile((Sequence)psiElement3, (Function1)((Function1)new Function1<PsiElement, Boolean>(bodyExpression){
            final /* synthetic */ KtBlockExpression $bodyExpression;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$bodyExpression.getRBrace()) ^ true;
            }
            {
                this.$bodyExpression = ktBlockExpression;
                super(1);
            }
        }))) != null) {
            Object v6;
            block8: {
                PsiElement $this$singleOrNull$iv = psiElement3;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PsiWhiteSpace)) continue;
                    if (found$iv) {
                        v6 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v6 = !found$iv ? null : single$iv;
            }
            if ((psiElement3 = (PsiElement)v6) != null) {
                PsiElement psiElement4 = psiElement3;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement4;
                boolean bl3 = false;
                it.delete();
            }
        }
        bodyExpression.addBefore((PsiElement)KtPsiFactoryKt.KtPsiFactory$default(setter2, false, 2, null).createExpression("field = " + parameter.getText()), bodyExpression.getRBrace());
    }
}

