/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.FormattingChange;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/CollectChangesWithoutApplyModel;", "Lcom/intellij/formatting/FormattingModel;", "file", "Lcom/intellij/psi/PsiFile;", "block", "Lcom/intellij/formatting/Block;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/formatting/Block;)V", "getBlock", "()Lcom/intellij/formatting/Block;", "changes", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/idea/formatter/FormattingChange;", "Lkotlin/collections/HashSet;", "documentModel", "Lcom/intellij/psi/formatter/FormattingDocumentModelImpl;", "getFile", "()Lcom/intellij/psi/PsiFile;", "requestedChanges", "", "getRequestedChanges", "()Ljava/util/Set;", "commitChanges", "", "getDocumentModel", "Lcom/intellij/formatting/FormattingDocumentModel;", "getRootBlock", "replaceWhiteSpace", "Lcom/intellij/openapi/util/TextRange;", "textRange", "whiteSpace", "", "shiftIndentInsideRange", "node", "Lcom/intellij/lang/ASTNode;", "range", "indent", "", "idea"})
final class CollectChangesWithoutApplyModel
implements FormattingModel {
    private final FormattingDocumentModelImpl documentModel;
    private final HashSet<FormattingChange> changes;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Block block;

    @NotNull
    public final Set<FormattingChange> getRequestedChanges() {
        return this.changes;
    }

    public void commitChanges() {
    }

    @NotNull
    public FormattingDocumentModel getDocumentModel() {
        return (FormattingDocumentModel)this.documentModel;
    }

    @NotNull
    public Block getRootBlock() {
        return this.block;
    }

    @NotNull
    public TextRange shiftIndentInsideRange(@Nullable ASTNode node2, @NotNull TextRange range, int indent) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        this.changes.add(new FormattingChange.ShiftIndentInsideRange(node2, range, indent));
        return range;
    }

    @NotNull
    public TextRange replaceWhiteSpace(@NotNull TextRange textRange, @NotNull String whiteSpace) {
        Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
        Intrinsics.checkParameterIsNotNull((Object)whiteSpace, (String)"whiteSpace");
        this.changes.add(new FormattingChange.ReplaceWhiteSpace(textRange, whiteSpace));
        return textRange;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    public CollectChangesWithoutApplyModel(@NotNull PsiFile file2, @NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        this.file = file2;
        this.block = block;
        FileViewProvider fileViewProvider = this.file.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"file.viewProvider");
        this.documentModel = new FormattingDocumentModelImpl((Document)new DocumentImpl(fileViewProvider.getContents(), true), this.file);
        this.changes = new HashSet();
    }
}

