/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProvider;
import org.jetbrains.kotlin.idea.platform.IdePlatformKindTooling;
import org.jetbrains.kotlin.idea.platform.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u00030\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription;", "Lcom/intellij/facet/ui/libraries/FrameworkLibraryValidator;", "context", "Lcom/intellij/facet/impl/ui/libraries/LibrariesValidatorContext;", "validatorsManager", "Lcom/intellij/facet/ui/FacetValidatorsManager;", "libraryCategoryName", "", "getPlatform", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "(Lcom/intellij/facet/impl/ui/libraries/LibrariesValidatorContext;Lcom/intellij/facet/ui/FacetValidatorsManager;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "libraryDescription", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "getLibraryDescription", "(Lorg/jetbrains/kotlin/platform/IdePlatformKind;)Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "check", "Lcom/intellij/facet/ui/ValidationResult;", "checkLibraryIsConfigured", "", "platform", "LibrariesQuickFix", "idea-jvm"})
public final class FrameworkLibraryValidatorWithDynamicDescription
extends FrameworkLibraryValidator {
    private final LibrariesValidatorContext context;
    private final FacetValidatorsManager validatorsManager;
    private final String libraryCategoryName;
    private final Function0<TargetPlatform> getPlatform;

    private final CustomLibraryDescription getLibraryDescription(@NotNull IdePlatformKind<?> $this$libraryDescription) {
        IdePlatformKindTooling idePlatformKindTooling = IdePlatformKindToolingKt.getTooling($this$libraryDescription);
        Module module = this.context.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"context.module");
        Project project2 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"context.module.project");
        return idePlatformKindTooling.getLibraryDescription(project2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkLibraryIsConfigured(IdePlatformKind<?> platform) {
        void found2;
        boolean bl;
        block4: {
            if (CommonIdePlatformUtil.isCommon(platform)) {
                return true;
            }
            Ref.BooleanRef booleanRef = KotlinVersionInfoProvider.Companion.getEP_NAME().getExtensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)booleanRef, (String)"KotlinVersionInfoProvider.EP_NAME.extensions");
            Ref.BooleanRef $this$any$iv = booleanRef;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KotlinVersionInfoProvider it = (KotlinVersionInfoProvider)element$iv;
                boolean bl2 = false;
                Module module = this.context.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"context.module");
                Collection<String> collection = it.getLibraryVersions(module, platform, this.context.getRootModel());
                boolean bl3 = false;
                if (!(!collection.isEmpty())) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        CustomLibraryDescription customLibraryDescription = this.getLibraryDescription(platform);
        if (customLibraryDescription == null) {
            return true;
        }
        CustomLibraryDescription libraryDescription = customLibraryDescription;
        Set set2 = libraryDescription.getSuitableLibraryKinds();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"libraryDescription.suitableLibraryKinds");
        Set libraryKinds = set2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        LibraryPresentationManager presentationManager = LibraryPresentationManager.getInstance();
        this.context.getRootModel().orderEntries().using((RootModelProvider)this.context.getModulesProvider()).recursively().librariesOnly().forEachLibrary((Processor)new Processor<Library>(this, presentationManager, libraryKinds, (Ref.BooleanRef)found2){
            final /* synthetic */ FrameworkLibraryValidatorWithDynamicDescription this$0;
            final /* synthetic */ LibraryPresentationManager $presentationManager;
            final /* synthetic */ Set $libraryKinds;
            final /* synthetic */ Ref.BooleanRef $found;

            public final boolean process(Library library2) {
                if (this.$presentationManager.isLibraryOfKind(library2, FrameworkLibraryValidatorWithDynamicDescription.access$getContext$p(this.this$0).getLibrariesContainer(), this.$libraryKinds)) {
                    this.$found.element = true;
                }
                return !this.$found.element;
            }
            {
                this.this$0 = frameworkLibraryValidatorWithDynamicDescription;
                this.$presentationManager = libraryPresentationManager;
                this.$libraryKinds = set2;
                this.$found = booleanRef;
            }
        });
        return found2.element;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ValidationResult check() {
        TargetPlatform targetPlatform = (TargetPlatform)this.getPlatform.invoke();
        if (targetPlatform == null) {
            return new ValidationResult(KotlinJvmBundle.message("no.target.platforms.selected", new Object[0]));
        }
        TargetPlatform targetPlatform2 = targetPlatform;
        if (this.checkLibraryIsConfigured(IdePlatformKindUtil.getIdePlatformKind(targetPlatform2))) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = IdePlatformKind.Companion.getALL_KINDS();
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IdePlatformKind it = (IdePlatformKind)element$iv$iv;
                boolean bl = false;
                if (!(!CommonIdePlatformUtil.isCommon(it) && Intrinsics.areEqual((Object)it.getName(), (Object)IdePlatformKindUtil.getIdePlatformKind(targetPlatform2).getName()) ^ true && this.getLibraryDescription(it) != null && this.checkLibraryIsConfigured(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List conflictingPlatforms = (List)destination$iv$iv;
            $this$filter$iv = conflictingPlatforms;
            $i$f$filter2 = false;
            if (!$this$filter$iv.isEmpty()) {
                void $this$mapTo$iv;
                Iterable $i$f$filter2 = conflictingPlatforms;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    Object element$iv$iv;
                    element$iv$iv = (IdePlatformKind)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    String string = it.getName();
                    collection.add(string);
                }
                String platformText = CollectionsKt.joinToString$default((Iterable)destination$iv, null, null, null, (int)0, null, null, (int)63, null);
                return new ValidationResult(KotlinJvmBundle.message("libraries.for.the.following.platform.are.also.present.in.the.module.dependencies.0", platformText));
            }
            ValidationResult validationResult = ValidationResult.OK;
            Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
            return validationResult;
        }
        String string = IdeBundle.message((String)"label.missed.libraries.text", (Object[])new Object[]{this.libraryCategoryName});
        CustomLibraryDescription customLibraryDescription = this.getLibraryDescription(IdePlatformKindUtil.getIdePlatformKind(targetPlatform2));
        if (customLibraryDescription == null) {
            Intrinsics.throwNpe();
        }
        return new ValidationResult(string, (FacetConfigurationQuickFix)new LibrariesQuickFix(customLibraryDescription));
    }

    public FrameworkLibraryValidatorWithDynamicDescription(@NotNull LibrariesValidatorContext context2, @NotNull FacetValidatorsManager validatorsManager, @NotNull String libraryCategoryName, @NotNull Function0<? extends TargetPlatform> getPlatform) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)validatorsManager, (String)"validatorsManager");
        Intrinsics.checkParameterIsNotNull((Object)libraryCategoryName, (String)"libraryCategoryName");
        Intrinsics.checkParameterIsNotNull(getPlatform, (String)"getPlatform");
        this.context = context2;
        this.validatorsManager = validatorsManager;
        this.libraryCategoryName = libraryCategoryName;
        this.getPlatform = getPlatform;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription$LibrariesQuickFix;", "Lcom/intellij/facet/ui/FacetConfigurationQuickFix;", "myDescription", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "(Lorg/jetbrains/kotlin/idea/facet/FrameworkLibraryValidatorWithDynamicDescription;Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;)V", "run", "", "place", "Ljavax/swing/JComponent;", "idea-jvm"})
    private final class LibrariesQuickFix
    extends FacetConfigurationQuickFix {
        private final CustomLibraryDescription myDescription;

        public void run(@NotNull JComponent place) {
            Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
            AddCustomLibraryDialog dialog2 = AddCustomLibraryDialog.createDialog((CustomLibraryDescription)this.myDescription, (LibrariesContainer)FrameworkLibraryValidatorWithDynamicDescription.this.context.getLibrariesContainer(), (Module)FrameworkLibraryValidatorWithDynamicDescription.this.context.getModule(), (ModifiableRootModel)FrameworkLibraryValidatorWithDynamicDescription.this.context.getModifiableRootModel(), null);
            dialog2.show();
            FrameworkLibraryValidatorWithDynamicDescription.this.validatorsManager.validate();
        }

        public LibrariesQuickFix(CustomLibraryDescription myDescription) {
            Intrinsics.checkParameterIsNotNull((Object)myDescription, (String)"myDescription");
            super(IdeBundle.message((String)"button.fix", (Object[])new Object[0]));
            this.myDescription = myDescription;
        }
    }
}

