/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.engine.AsyncStackTraceProvider;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.HopelessExceptionUtilKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.AsyncStackTraceContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0012H\u0016J\u001e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAsyncStackTraceProvider;", "Lcom/intellij/debugger/engine/AsyncStackTraceProvider;", "()V", "canRunEvaluation", "", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "createAsyncStackTraceContext", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/AsyncStackTraceContext;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "method", "Lcom/sun/jdi/Method;", "getAsyncStackTrace", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "stackFrame", "Lcom/intellij/debugger/engine/JavaStackFrame;", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "getAsyncStackTraceSafe", "", "jvm-debugger-coroutine"})
public final class CoroutineAsyncStackTraceProvider
implements AsyncStackTraceProvider {
    @Nullable
    public List<CoroutineStackFrameItem> getAsyncStackTrace(@NotNull JavaStackFrame stackFrame, @NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkParameterIsNotNull((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        return this.getAsyncStackTrace(stackFrame, (XSuspendContext)suspendContext);
    }

    @Nullable
    public final List<CoroutineStackFrameItem> getAsyncStackTrace(@NotNull JavaStackFrame stackFrame, @NotNull XSuspendContext suspendContext) {
        List<CoroutineStackFrameItem> list2;
        Intrinsics.checkParameterIsNotNull((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        boolean $i$f$hopelessAware = false;
        try {
            boolean bl = false;
            StackFrameProxyImpl stackFrameProxyImpl = stackFrame.getStackFrameProxy();
            Intrinsics.checkExpressionValueIsNotNull((Object)stackFrameProxyImpl, (String)"stackFrame.stackFrameProxy");
            list2 = this.getAsyncStackTraceSafe(stackFrameProxyImpl, suspendContext);
        }
        catch (Exception e$iv) {
            HopelessExceptionUtilKt.handleHopelessException(e$iv);
            list2 = null;
        }
        List<CoroutineStackFrameItem> stackFrameList = list2;
        return stackFrameList == null || stackFrameList.isEmpty() ? null : stackFrameList;
    }

    @NotNull
    public final List<CoroutineStackFrameItem> getAsyncStackTraceSafe(@NotNull StackFrameProxyImpl frameProxy, @NotNull XSuspendContext suspendContext) {
        Location location2;
        Intrinsics.checkParameterIsNotNull((Object)frameProxy, (String)"frameProxy");
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        boolean bl = false;
        List defaultResult = new ArrayList();
        Location location3 = location2 = frameProxy.location();
        Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"location");
        if (!DebuggerUtilKt.isInKotlinSources(location3)) {
            return defaultResult;
        }
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return defaultResult;
        }
        Method method2 = method;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = frameProxy.threadProxy();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadReferenceProxyImpl, (String)"frameProxy.threadProxy()");
        ThreadReference threadReference = threadReferenceProxyImpl.getThreadReference();
        if (threadReference == null || !threadReference.isSuspended() || !this.canRunEvaluation(suspendContext)) {
            return defaultResult;
        }
        AsyncStackTraceContext astContext = this.createAsyncStackTraceContext(frameProxy, suspendContext, method2);
        return astContext.getAsyncStackTraceIfAny();
    }

    private final AsyncStackTraceContext createAsyncStackTraceContext(StackFrameProxyImpl frameProxy, XSuspendContext suspendContext, Method method) {
        XSuspendContext xSuspendContext = suspendContext;
        if (xSuspendContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.engine.SuspendContextImpl");
        }
        EvaluationContextImpl evaluationContext = new EvaluationContextImpl((SuspendContextImpl)xSuspendContext, frameProxy);
        ExecutionContext context2 = new ExecutionContext(evaluationContext, frameProxy);
        return new AsyncStackTraceContext(context2, method);
    }

    public final boolean canRunEvaluation(@NotNull XSuspendContext suspendContext) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        DebugProcessImpl debugProcessImpl = ((SuspendContextImpl)suspendContext).getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"(suspendContext as Suspe\u2026ContextImpl).debugProcess");
        return DebuggerUtilKt.getCanRunEvaluation(debugProcessImpl);
    }
}

