/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints.dialog;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.util.DescriptorMemberChooserObject;
import org.jetbrains.kotlin.idea.debugger.breakpoints.dialog.FieldBreakpointDialogUtilKt;
import org.jetbrains.kotlin.psi.KtProperty;

public abstract class AddFieldBreakpointDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myFieldChooser;
    private TextFieldWithBrowseButton myClassChooser;

    public AddFieldBreakpointDialog(Project project2) {
        super(project2, true);
        this.myProject = project2;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])objectArray));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myClassChooser.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                AddFieldBreakpointDialog.this.updateUI();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/debugger/breakpoints/dialog/AddFieldBreakpointDialog$1", "textChanged"));
            }
        });
        this.myClassChooser.addActionListener(e -> {
            PsiDirectory containingDirectory;
            PsiFile containingFile;
            PsiClass currentClass = this.getSelectedClass();
            TreeClassChooser chooser2 = TreeClassChooserFactory.getInstance((Project)this.myProject).createAllProjectScopeChooser(DebuggerBundle.message((String)"add.field.breakpoint.dialog.classchooser.title", (Object[])new Object[0]));
            if (currentClass != null && (containingFile = currentClass.getContainingFile()) != null && (containingDirectory = containingFile.getContainingDirectory()) != null) {
                chooser2.selectDirectory(containingDirectory);
            }
            chooser2.showDialog();
            PsiClass selectedClass = chooser2.getSelected();
            if (selectedClass != null) {
                this.myClassChooser.setText(selectedClass.getQualifiedName());
            }
        });
        this.myFieldChooser.addActionListener(e -> {
            PsiClass selectedClass = this.getSelectedClass();
            if (selectedClass != null) {
                DescriptorMemberChooserObject[] properties2 = FieldBreakpointDialogUtilKt.collectProperties(selectedClass);
                MemberChooser chooser2 = new MemberChooser((ClassMember[])properties2, false, false, this.myProject);
                chooser2.setTitle(DebuggerBundle.message((String)"add.field.breakpoint.dialog.field.chooser.title", (Object[])new Object[]{properties2.length}));
                chooser2.setCopyJavadocVisible(false);
                TransactionGuard.getInstance().submitTransactionAndWait(() -> ((MemberChooser)chooser2).show());
                List selectedElements2 = chooser2.getSelectedElements();
                if (selectedElements2 != null && selectedElements2.size() == 1) {
                    KtProperty field2 = (KtProperty)((DescriptorMemberChooserObject)((Object)((Object)selectedElements2.get(0)))).getElement();
                    this.myFieldChooser.setText(field2.getName());
                }
            }
        });
        this.myFieldChooser.setEnabled(false);
        return this.myPanel;
    }

    private void updateUI() {
        PsiClass selectedClass = this.getSelectedClass();
        this.myFieldChooser.setEnabled(selectedClass != null);
    }

    private PsiClass getSelectedClass() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        String classQName = this.myClassChooser.getText();
        if (StringUtil.isEmpty((String)classQName)) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(classQName, GlobalSearchScope.allScope((Project)this.myProject));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassChooser.getTextField();
    }

    public String getClassName() {
        return this.myClassChooser.getText();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.breakpoints.BreakpointsConfigurationDialogFactory.BreakpointsConfigurationDialog.AddFieldBreakpointDialog";
    }

    public String getFieldName() {
        return this.myFieldChooser.getText();
    }

    protected abstract boolean validateData();

    protected void doOKAction() {
        if (this.validateData()) {
            super.doOKAction();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, 6, false, false));
        this.myClassChooser = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFieldChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, new GridConstraints(5, 0, 1, 1, 2, 1, 3, 3, new Dimension(-1, 1), null, new Dimension(-1, 1)));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DebuggerBundle", AddFieldBreakpointDialog.class).getString("label.add.field.breakpoint.dialog.field.name"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DebuggerBundle", AddFieldBreakpointDialog.class).getString("label.add.field.breakpoint.dialog.fq.name"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

