/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.loader;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptOutsiderFileConfigurationLoader;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "loadDependencies", "", "isFirstLoad", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "context", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoadingContext;", "idea-core"})
public final class ScriptOutsiderFileConfigurationLoader
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context2) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
        Intrinsics.checkParameterIsNotNull((Object)scriptDefinition, (String)"scriptDefinition");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (!isFirstLoad) {
            return false;
        }
        PsiFile psiFile2 = ktFile.getOriginalFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"ktFile.originalFile");
        VirtualFile virtualFile3 = virtualFile2 = psiFile2.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
        VirtualFile virtualFile4 = OutsidersPsiFileSupportUtils.INSTANCE.getOutsiderFileOrigin(this.project, virtualFile3);
        if (virtualFile4 == null) {
            return false;
        }
        VirtualFile fileOrigin = virtualFile4;
        ScriptConfigurationSnapshot original = context2.getCachedConfiguration(fileOrigin);
        if (original != null) {
            CachedConfigurationInputs cachedConfigurationInputs = original.getInputs();
            VirtualFile virtualFile5 = virtualFile2;
            ScriptConfigurationLoadingContext scriptConfigurationLoadingContext = context2;
            boolean bl = false;
            List list2 = CollectionsKt.emptyList();
            ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = original.getConfiguration();
            List list3 = list2;
            CachedConfigurationInputs cachedConfigurationInputs2 = cachedConfigurationInputs;
            scriptConfigurationLoadingContext.saveNewConfiguration(virtualFile5, new ScriptConfigurationSnapshot(cachedConfigurationInputs2, list3, scriptCompilationConfigurationWrapper));
        }
        return true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptOutsiderFileConfigurationLoader(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public boolean shouldRunInBackground(@NotNull ScriptDefinition scriptDefinition) {
        Intrinsics.checkParameterIsNotNull((Object)scriptDefinition, (String)"scriptDefinition");
        return ScriptConfigurationLoader.DefaultImpls.shouldRunInBackground(this, scriptDefinition);
    }
}

