/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\"\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinNativeLibrariesFixer;", "", "()V", "addLibraryToProjectModel", "", "libraryData", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "ideProject", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "applyTo", "ownerNode", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "fixLibraryDependencyLevel", "oldDependencyNode", "Lcom/intellij/openapi/externalSystem/model/project/LibraryDependencyData;", "fixLibraryName", "idea-gradle"})
public final class KotlinNativeLibrariesFixer {
    public static final KotlinNativeLibrariesFixer INSTANCE;

    public final void applyTo(@NotNull DataNode<GradleSourceSetData> ownerNode, @NotNull DataNode<ProjectData> ideProject) {
        Intrinsics.checkParameterIsNotNull(ownerNode, (String)"ownerNode");
        Intrinsics.checkParameterIsNotNull(ideProject, (String)"ideProject");
        Iterator iterator2 = ExternalSystemApiUtil.findAll(ownerNode, (Key)ProjectKeys.LIBRARY_DEPENDENCY).iterator();
        while (iterator2.hasNext()) {
            LibraryData libraryData;
            DataNode libraryDependencyNode;
            DataNode dataNode = libraryDependencyNode = (DataNode)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"libraryDependencyNode");
            Object object = dataNode.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"libraryDependencyNode.data");
            Intrinsics.checkExpressionValueIsNotNull((Object)((LibraryData)((LibraryDependencyData)object).getTarget()), (String)"libraryDependencyNode.data.target");
            String string = libraryData.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"libraryData.internalName");
            if (!StringsKt.startsWith$default((String)string, (String)"Gradle: Kotlin/Native", (boolean)false, (int)2, null)) continue;
            this.fixLibraryName(libraryData);
            this.addLibraryToProjectModel(libraryData, ideProject);
            this.fixLibraryDependencyLevel((DataNode<LibraryDependencyData>)libraryDependencyNode);
        }
    }

    private final void fixLibraryName(LibraryData libraryData) {
        String string = libraryData.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"libraryData.internalName");
        libraryData.setInternalName(StringsKt.substringAfter$default((String)string, (String)"Gradle: ", null, (int)2, null));
    }

    private final void addLibraryToProjectModel(LibraryData libraryData, DataNode<ProjectData> ideProject) {
        GradleProjectResolverUtil.linkProjectLibrary(ideProject, (LibraryData)libraryData);
    }

    private final void fixLibraryDependencyLevel(DataNode<LibraryDependencyData> oldDependencyNode) {
        Object object = oldDependencyNode.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"oldDependencyNode.data");
        LibraryDependencyData oldDependency = (LibraryDependencyData)object;
        if (oldDependency.getLevel() == LibraryLevel.PROJECT) {
            return;
        }
        LibraryDependencyData libraryDependencyData = new LibraryDependencyData(oldDependency.getOwnerModule(), (LibraryData)oldDependency.getTarget(), LibraryLevel.PROJECT);
        boolean bl = false;
        boolean bl2 = false;
        LibraryDependencyData $this$apply = libraryDependencyData;
        boolean bl3 = false;
        $this$apply.setScope(oldDependency.getScope());
        $this$apply.setOrder(oldDependency.getOrder());
        $this$apply.setExported(oldDependency.isExported());
        LibraryDependencyData newDependency = libraryDependencyData;
        DataNode dataNode = oldDependencyNode.getParent();
        if (dataNode == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"oldDependencyNode.parent ?: return");
        DataNode parentNode = dataNode;
        Collection collection = oldDependencyNode.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"oldDependencyNode.children");
        Collection childNodes = collection;
        DataNode dataNode2 = parentNode.createChild(oldDependencyNode.getKey(), (Object)newDependency);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2, (String)"parentNode.createChild(o\u2026yNode.key, newDependency)");
        DataNode newDependencyNode = dataNode2;
        for (DataNode child : childNodes) {
            newDependencyNode.addChild(child);
        }
        oldDependencyNode.clear(true);
    }

    private KotlinNativeLibrariesFixer() {
    }

    static {
        KotlinNativeLibrariesFixer kotlinNativeLibrariesFixer;
        INSTANCE = kotlinNativeLibrariesFixer = new KotlinNativeLibrariesFixer();
    }
}

