/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.BooleanFunction;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.KotlinGradleModel;
import org.jetbrains.kotlin.gradle.KotlinGradleModelBuilder;
import org.jetbrains.kotlin.gradle.KotlinGradleModelBuilderKt;
import org.jetbrains.kotlin.gradle.KotlinMPPGradleModel;
import org.jetbrains.kotlin.gradle.KotlinTarget;
import org.jetbrains.kotlin.gradle.KotlinTaskProperties;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtensionKt;
import org.jetbrains.kotlin.idea.configuration.KotlinMPPGradleProjectResolverKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleModelFacadeKt;
import org.jetbrains.kotlin.idea.statistics.FUSEventGroups;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;
import org.jetbrains.kotlin.idea.statistics.KotlinGradleFUSLogger;
import org.jetbrains.kotlin.idea.util.PsiPrecedences;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002J4\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0002J.\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u000bH\u0002Jh\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2 \u0010$\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020'0&\u0018\u00010%2&\u0010(\u001a\"\u0012\u0004\u0012\u00020\u000b\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\f\u0012\u0004\u0012\u00020)0&\u0018\u00010%H\u0002J\u0016\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0,0+H\u0016J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0,0+H\u0016J\u001e\u0010/\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J,\u00100\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0016J\b\u00101\u001a\u000202H\u0002J0\u00103\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\"*\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0002JD\u00104\u001a4\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012(\u0012&\u0012\f\u0012\n 5*\u0004\u0018\u00010 0  5*\u0012\u0012\f\u0012\n 5*\u0004\u0018\u00010 0 \u0018\u00010\f0\f0%*\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\r\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\"\u0010\n\u001a\u0004\u0018\u00010\u000b*\n\u0012\u0006\b\u0001\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleProjectResolverExtension;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isAndroidProjectKey", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/annotations/Nullable;", "()Lcom/intellij/openapi/util/Key;", "sourceSetName", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "getSourceSetName", "(Lcom/intellij/openapi/externalSystem/model/DataNode;)Ljava/lang/String;", "addDependency", "", "ideModule", "targetModule", "addImplementedModuleNames", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "dependentModule", "ideProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "gradleModel", "Lorg/jetbrains/kotlin/gradle/KotlinGradleModel;", "addTransitiveDependenciesOnImplementedModules", "findModuleById", "moduleId", "getDependencyByFiles", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "files", "", "Ljava/io/File;", "outputToSourceSet", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/externalSystem/model/project/ExternalSystemSourceType;", "sourceSetByName", "Lorg/jetbrains/plugins/gradle/model/ExternalSourceSet;", "getExtraProjectModelClasses", "", "Ljava/lang/Class;", "", "getToolingExtensionsClasses", "populateModuleContentRoots", "populateModuleDependencies", "useModulePerSourceSet", "", "getDependencies", "getSourceSetsMap", "kotlin.jvm.PlatformType", "idea-gradle"})
public final class KotlinGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    @Nullable
    private final com.intellij.openapi.util.Key<?> isAndroidProjectKey = com.intellij.openapi.util.Key.findKeyByName((String)"IS_ANDROID_PROJECT_KEY");
    private final Logger LOG;

    @Nullable
    public final com.intellij.openapi.util.Key<?> isAndroidProjectKey() {
        return this.isAndroidProjectKey;
    }

    @NotNull
    public Set<Class<? extends Object>> getToolingExtensionsClasses() {
        return SetsKt.setOf((Object[])new Class[]{KotlinGradleModelBuilder.class, Unit.class});
    }

    @NotNull
    public Set<Class<? extends Object>> getExtraProjectModelClasses() {
        return SetsKt.setOf(KotlinGradleModel.class);
    }

    private final boolean useModulePerSourceSet() {
        if (this.isAndroidProjectKey != null && Intrinsics.areEqual((Object)this.resolverCtx.getUserData(this.isAndroidProjectKey), (Object)true)) {
            return false;
        }
        ProjectResolverContext projectResolverContext = this.resolverCtx;
        Intrinsics.checkExpressionValueIsNotNull((Object)projectResolverContext, (String)"resolverCtx");
        return projectResolverContext.isResolveModulePerSourceSet();
    }

    /*
     * WARNING - void declaration
     */
    private final DataNode<GradleSourceSetData> getDependencyByFiles(Collection<? extends File> files2, Map<String, ? extends com.intellij.openapi.util.Pair<String, ExternalSystemSourceType>> outputToSourceSet, Map<String, ? extends com.intellij.openapi.util.Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetByName) {
        void $this$mapTo$iv;
        Iterable iterable = files2;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            DataNode dataNode;
            String path2;
            void it;
            File file2 = (File)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)FileUtil.toSystemIndependentName((String)it.getPath()), (String)"FileUtil.toSystemIndependentName(it.path)");
            Map<String, ? extends com.intellij.openapi.util.Pair<String, ExternalSystemSourceType>> map2 = outputToSourceSet;
            if (map2 == null || (map2 = map2.get(path2)) == null || (map2 = (String)((com.intellij.openapi.util.Pair)map2).first) == null) {
                dataNode = null;
            } else {
                Map<String, ? extends com.intellij.openapi.util.Pair<String, ExternalSystemSourceType>> targetSourceSetId = map2;
                Map<String, ? extends com.intellij.openapi.util.Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> map3 = sourceSetByName;
                dataNode = map3 != null && (map3 = map3.get(targetSourceSetId)) != null ? (DataNode)((com.intellij.openapi.util.Pair)map3).first : null;
            }
            DataNode dataNode2 = dataNode;
            collection.add(dataNode2);
        }
        return (DataNode)CollectionsKt.singleOrNull((Iterable)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DataNode<? extends ModuleData>> getDependencies(@NotNull DataNode<? extends ModuleData> $this$getDependencies, DataNode<ProjectData> ideProject) {
        void $this$mapNotNullTo$iv;
        Map cache2;
        Map map2 = KotlinGradleProjectResolverExtensionKt.getDependenciesCache($this$getDependencies);
        if (map2 == null) {
            map2 = cache2 = (Map)new HashMap();
        }
        if (cache2.containsKey(ideProject)) {
            Object v = cache2.get(ideProject);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            return (Collection)v;
        }
        Map outputToSourceSet = (Map)ideProject.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
        Map map3 = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
        if (map3 == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"ideProject.getUserData(G\u2026ETS) ?: return emptySet()");
        Map sourceSetByName = map3;
        com.intellij.openapi.util.Pair pair2 = (com.intellij.openapi.util.Pair)sourceSetByName.get(((ModuleData)$this$getDependencies.getData()).getId());
        if (pair2 == null || (pair2 = (ExternalSourceSet)pair2.second) == null) {
            return SetsKt.emptySet();
        }
        com.intellij.openapi.util.Pair externalSourceSet = pair2;
        Collection collection = externalSourceSet.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"externalSourceSet.dependencies");
        Iterable iterable = collection;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DataNode dataNode;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            ExternalDependency dependency = (ExternalDependency)element$iv;
            boolean bl2 = false;
            ExternalDependency externalDependency = dependency;
            if (externalDependency instanceof ExternalProjectDependency) {
                if (Intrinsics.areEqual((Object)((ExternalProjectDependency)dependency).getConfigurationName(), (Object)"default")) {
                    if (ExternalSystemApiUtil.findFirstRecursively(ideProject, (BooleanFunction)new BooleanFunction<DataNode<?>>(dependency){
                        final /* synthetic */ ExternalDependency $dependency;

                        public final boolean fun(DataNode<?> it) {
                            DataNode<?> dataNode = it;
                            Intrinsics.checkExpressionValueIsNotNull(dataNode, (String)"it");
                            Object object = dataNode.getData();
                            if (!(object instanceof ModuleData)) {
                                object = null;
                            }
                            ModuleData moduleData = (ModuleData)object;
                            return Intrinsics.areEqual((Object)(moduleData != null ? moduleData.getId() : null), (Object)((ExternalProjectDependency)this.$dependency).getProjectPath());
                        }
                        {
                            this.$dependency = externalDependency;
                        }
                    }) == null) {
                        dataNode = null;
                    } else {
                        Object v8;
                        block15: {
                            DataNode targetModuleNode2;
                            Collection collection2 = ExternalSystemApiUtil.findAll((DataNode)targetModuleNode2, (Key)GradleSourceSetData.KEY);
                            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"ExternalSystemApiUtil.fi\u2026 GradleSourceSetData.KEY)");
                            Iterable $this$firstOrNull$iv = collection2;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv2 : $this$firstOrNull$iv) {
                                DataNode it = (DataNode)element$iv2;
                                boolean bl3 = false;
                                DataNode dataNode2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2, (String)"it");
                                if (!Intrinsics.areEqual((Object)this.getSourceSetName((DataNode<? extends ModuleData>)dataNode2), (Object)"main")) continue;
                                v8 = element$iv2;
                                break block15;
                            }
                            v8 = null;
                        }
                        dataNode = v8;
                    }
                } else {
                    Collection collection3 = ((ExternalProjectDependency)dependency).getProjectDependencyArtifacts();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"dependency.projectDependencyArtifacts");
                    dataNode = this.getDependencyByFiles(collection3, outputToSourceSet, sourceSetByName);
                }
            } else if (externalDependency instanceof FileCollectionDependency) {
                Collection collection4 = ((FileCollectionDependency)dependency).getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"dependency.files");
                dataNode = this.getDependencyByFiles(collection4, outputToSourceSet, sourceSetByName);
            } else {
                dataNode = null;
            }
            if (dataNode == null) continue;
            DataNode dataNode3 = dataNode;
            boolean bl4 = false;
            boolean bl5 = false;
            DataNode it$iv = dataNode3;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        LinkedHashSet result2 = (LinkedHashSet)destination$iv;
        cache2.put(ideProject, result2);
        KotlinGradleProjectResolverExtensionKt.setDependenciesCache($this$getDependencies, cache2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addTransitiveDependenciesOnImplementedModules(IdeaModule gradleModule, DataNode<ModuleData> ideModule, DataNode<ProjectData> ideProject) {
        Collection collection;
        if (this.useModulePerSourceSet()) {
            Collection collection2 = ExternalSystemApiUtil.findAll(ideModule, (Key)GradleSourceSetData.KEY);
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"ExternalSystemApiUtil.fi\u2026 GradleSourceSetData.KEY)");
        } else {
            collection = CollectionsKt.listOf(ideModule);
        }
        Collection moduleNodesToProcess = collection;
        boolean dirtyDependencies = true;
        block0: for (DataNode currentModuleNode : moduleNodesToProcess) {
            ArrayDeque<DataNode> arrayDeque = new ArrayDeque<DataNode>();
            boolean bl = false;
            boolean bl2 = false;
            ArrayDeque<DataNode> $this$apply22 = arrayDeque;
            boolean bl3 = false;
            $this$apply22.add(currentModuleNode);
            ArrayDeque<DataNode> toProcess = arrayDeque;
            Collection collection3 = new HashSet<DataNode>();
            bl2 = false;
            boolean $this$apply22 = false;
            HashSet<DataNode> $this$apply = collection3;
            boolean bl4 = false;
            $this$apply.add(currentModuleNode);
            HashSet<DataNode> discovered = collection3;
            while (true) {
                Object object;
                Object object2;
                IdeaModule ideaModule;
                IdeaModule ideaModule2;
                DataNode moduleNodeForGradleModel;
                collection3 = toProcess;
                bl2 = false;
                if (!(!collection3.isEmpty())) continue block0;
                DataNode moduleNode = (DataNode)toProcess.pollLast();
                DataNode dataNode = moduleNodeForGradleModel = this.useModulePerSourceSet() ? ExternalSystemApiUtil.findParent((DataNode)moduleNode, (Key)ProjectKeys.MODULE) : moduleNode;
                if (Intrinsics.areEqual((Object)moduleNodeForGradleModel, ideModule) ^ true) {
                    Object object3;
                    block19: {
                        IdeaProject ideaProject = gradleModule.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)ideaProject, (String)"gradleModule.project");
                        DomainObjectSet domainObjectSet = ideaProject.getModules();
                        Intrinsics.checkExpressionValueIsNotNull((Object)domainObjectSet, (String)"gradleModule.project.modules");
                        Iterable $this$firstOrNull$iv = (Iterable)domainObjectSet;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            DataNode dataNode2;
                            IdeaModule it = (IdeaModule)element$iv;
                            boolean bl5 = false;
                            IdeaModule ideaModule3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)ideaModule3, (String)"it");
                            GradleProject gradleProject = ideaModule3.getGradleProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)gradleProject, (String)"it.gradleProject");
                            if (!Intrinsics.areEqual((Object)gradleProject.getPath(), (dataNode2 = moduleNodeForGradleModel) != null && (dataNode2 = (ModuleData)dataNode2.getData()) != null ? dataNode2.getId() : null)) continue;
                            object3 = element$iv;
                            break block19;
                        }
                        object3 = null;
                    }
                    ideaModule2 = (IdeaModule)object3;
                } else {
                    ideaModule2 = ideaModule = gradleModule;
                }
                if ((object2 = (KotlinGradleModel)this.resolverCtx.getExtraProject(ideaModule, KotlinGradleModel.class)) == null || (object2 = object2.getImplements()) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Object implementsModuleIds = object2;
                Object object4 = implementsModuleIds.iterator();
                while (object4.hasNext()) {
                    DataNode<ModuleData> targetModule;
                    String implementsModuleId = (String)object4.next();
                    if (this.findModuleById(ideProject, gradleModule, implementsModuleId) == null) {
                        continue;
                    }
                    if (this.useModulePerSourceSet()) {
                        void $this$associateByTo$iv$iv;
                        Collection collection4 = ExternalSystemApiUtil.findAll(targetModule, (Key)GradleSourceSetData.KEY);
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"ExternalSystemApiUtil\n  \u2026 GradleSourceSetData.KEY)");
                        Iterable $this$associateBy$iv = collection4;
                        boolean $i$f$associateBy = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        Iterable iterable = $this$associateBy$iv;
                        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                            void it;
                            DataNode dataNode3 = (DataNode)element$iv$iv;
                            Map map2 = destination$iv$iv;
                            boolean bl6 = false;
                            void v12 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
                            String string = this.getSourceSetName((DataNode<? extends ModuleData>)v12);
                            map2.put(string, element$iv$iv);
                        }
                        Map targetSourceSetsByName = destination$iv$iv;
                        DataNode<ModuleData> dataNode4 = (DataNode<ModuleData>)targetSourceSetsByName.get("main");
                        if (dataNode4 == null) {
                            dataNode4 = targetModule;
                        }
                        DataNode<ModuleData> targetMainSourceSet = dataNode4;
                        DataNode dataNode5 = currentModuleNode;
                        Intrinsics.checkExpressionValueIsNotNull((Object)dataNode5, (String)"currentModuleNode");
                        DataNode targetSourceSet = (DataNode)targetSourceSetsByName.get(this.getSourceSetName((DataNode<? extends ModuleData>)dataNode5));
                        if (targetSourceSet != null) {
                            this.addDependency((DataNode<? extends ModuleData>)currentModuleNode, (DataNode<? extends ModuleData>)targetSourceSet);
                        }
                        if (!Intrinsics.areEqual((Object)this.getSourceSetName((DataNode<? extends ModuleData>)currentModuleNode), (Object)"test") || !(Intrinsics.areEqual(targetMainSourceSet, (Object)targetSourceSet) ^ true)) continue;
                        this.addDependency((DataNode<? extends ModuleData>)currentModuleNode, targetMainSourceSet);
                        continue;
                    }
                    dirtyDependencies = true;
                    DataNode dataNode6 = currentModuleNode;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataNode6, (String)"currentModuleNode");
                    this.addDependency((DataNode<? extends ModuleData>)dataNode6, targetModule);
                }
                if (this.useModulePerSourceSet()) {
                    DataNode dataNode7 = moduleNode;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataNode7, (String)"moduleNode");
                    object = this.getDependencies((DataNode<? extends ModuleData>)dataNode7, ideProject);
                } else if (dirtyDependencies) {
                    IdeaProject ideaProject = gradleModule.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ideaProject, (String)"gradleModule.project");
                    object4 = KotlinGradleModelFacadeKt.getDependencyModules(ideModule, ideaProject);
                    boolean targetModule = false;
                    boolean bl7 = false;
                    Object it = object4;
                    boolean bl8 = false;
                    dirtyDependencies = false;
                    object = object4;
                } else {
                    object = CollectionsKt.emptyList();
                }
                Collection<DataNode<? extends ModuleData>> dependencies2 = object;
                Iterable $this$filterTo$iv = dependencies2;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    DataNode p1 = (DataNode)element$iv;
                    boolean bl9 = false;
                    if (!discovered.add(p1)) continue;
                    ((Collection)toProcess).add(element$iv);
                }
            }
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        block11: {
            Intrinsics.checkParameterIsNotNull((Object)gradleModule, (String)"gradleModule");
            Intrinsics.checkParameterIsNotNull(ideModule, (String)"ideModule");
            Intrinsics.checkParameterIsNotNull(ideProject, (String)"ideProject");
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Start populate module dependencies. Gradle module: [" + gradleModule + "], Ide module: [" + ideModule + "], Ide project: [" + ideProject + ']');
            }
            ProjectResolverContext projectResolverContext = this.resolverCtx;
            Intrinsics.checkExpressionValueIsNotNull((Object)projectResolverContext, (String)"resolverCtx");
            KotlinMPPGradleModel mppModel = KotlinMPPGradleProjectResolverKt.getMppModel(projectResolverContext, gradleModule);
            if (mppModel == null) break block11;
            Iterable $this$forEach$iv = mppModel.getTargets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                StringBuilder stringBuilder2;
                FUSEventGroups fUSEventGroups;
                KotlinFUSLogger.Companion companion;
                block13: {
                    block12: {
                        KotlinTarget target = (KotlinTarget)element$iv;
                        boolean bl = false;
                        companion = KotlinFUSLogger.Companion;
                        fUSEventGroups = FUSEventGroups.GradleTarget;
                        stringBuilder2 = new StringBuilder().append("MPP.").append(target.getPlatform().getId());
                        string = target.getPresetName();
                        if (string == null) break block12;
                        String string2 = string;
                        StringBuilder stringBuilder3 = stringBuilder2;
                        FUSEventGroups fUSEventGroups2 = fUSEventGroups;
                        KotlinFUSLogger.Companion companion2 = companion;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String it = string2;
                        boolean bl4 = false;
                        String string3 = '.' + it;
                        companion = companion2;
                        fUSEventGroups = fUSEventGroups2;
                        stringBuilder2 = stringBuilder3;
                        string = string3;
                        if (string != null) break block13;
                    }
                    string = "";
                }
                companion.log(fUSEventGroups, stringBuilder2.append((Object)string).toString());
            }
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
            return;
        }
        KotlinGradleModel kotlinGradleModel = (KotlinGradleModel)this.resolverCtx.getExtraProject(gradleModule, KotlinGradleModel.class);
        if (kotlinGradleModel == null) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinGradleModel, (String)"resolverCtx.getExtraProj\u2026e, ideModule, ideProject)");
        KotlinGradleModel gradleModel = kotlinGradleModel;
        if (!this.useModulePerSourceSet()) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
        this.addTransitiveDependenciesOnImplementedModules(gradleModule, ideModule, ideProject);
        KotlinGradleProjectResolverExtensionKt.setResolved(ideModule, true);
        KotlinGradleProjectResolverExtensionKt.setHasKotlinPlugin(ideModule, gradleModel.getHasKotlinPlugin());
        KotlinGradleProjectResolverExtensionKt.setCompilerArgumentsBySourceSet(ideModule, KotlinGradleModelBuilderKt.deepCopy((Map)gradleModel.getCompilerArgumentsBySourceSet()));
        KotlinGradleProjectResolverExtensionKt.setCoroutines(ideModule, gradleModel.getCoroutines());
        KotlinGradleProjectResolverExtensionKt.setPlatformPluginId(ideModule, gradleModel.getPlatformPluginId());
        if (gradleModel.getHasKotlinPlugin()) {
            String string = gradleModel.getKotlinTarget();
            if (string == null) {
                string = "unknown";
            }
            KotlinFUSLogger.Companion.log(FUSEventGroups.GradleTarget, string);
        }
        this.addImplementedModuleNames(gradleModule, ideModule, ideProject, gradleModel);
        if (this.useModulePerSourceSet()) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Finish populating module dependencies. Gradle module: [" + gradleModule + "], Ide module: [" + ideModule + "], Ide project: [" + ideProject + ']');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addImplementedModuleNames(IdeaModule gradleModule, DataNode<ModuleData> dependentModule, DataNode<ProjectData> ideProject, KotlinGradleModel gradleModel) {
        Object $this$map$iv;
        Object dependentSourceSets;
        Iterator iterator2;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = gradleModel.getImplements();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.findModuleById(ideProject, gradleModule, it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            DataNode<ModuleData> it$iv$iv = iterator2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List implementedModules2 = (List)destination$iv$iv;
        if (this.useModulePerSourceSet()) {
            Object object;
            Collection collection;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            dependentSourceSets = this.getSourceSetsMap(dependentModule);
            $this$map$iv = implementedModules2;
            boolean $i$f$map22 = false;
            Iterable $i$f$mapNotNullTo2 = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it;
                item$iv$iv = iterator3.next();
                element$iv$iv = (DataNode)item$iv$iv;
                collection = destination$iv$iv22;
                boolean bl = false;
                object = this.getSourceSetsMap((DataNode<ModuleData>)it);
                collection.add(object);
            }
            List implementedSourceSetMaps = (List)destination$iv$iv22;
            $this$mapTo$iv$iv = dependentSourceSets;
            boolean destination$iv$iv22 = false;
            Iterator $i$f$map22 = $this$mapTo$iv$iv.entrySet().iterator();
            while ($i$f$map22.hasNext()) {
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                Object $i$f$mapTo2 = $this$map$iv = $i$f$map22.next();
                boolean bl = false;
                $this$mapTo$iv$iv = (String)$i$f$mapTo2.getKey();
                $i$f$mapTo2 = $this$map$iv;
                bl = false;
                DataNode dependentSourceSet = (DataNode)$i$f$mapTo2.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)dependentSourceSet, (String)"dependentSourceSet");
                $i$f$mapTo2 = implementedSourceSetMaps;
                boolean $i$f$mapNotNull2 = false;
                item$iv$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo3 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    String string;
                    void sourceSetName;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    boolean bl6 = false;
                    Map it = (Map)element$iv$iv2;
                    boolean bl7 = false;
                    DataNode dataNode = (DataNode)it.get(sourceSetName);
                    if ((dataNode != null && (dataNode = (GradleSourceSetData)dataNode.getData()) != null ? dataNode.getInternalName() : null) == null) continue;
                    string = string;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    String it$iv$iv = string;
                    boolean bl10 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                object = (List)destination$iv$iv3;
                KotlinGradleProjectResolverExtensionKt.setImplementedModuleNames((DataNode<? extends ModuleData>)collection, (List<String>)object);
            }
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv2;
            dependentSourceSets = implementedModules2;
            DataNode<ModuleData> dataNode = dependentModule;
            boolean $i$f$map = false;
            $this$map$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataNode $i$f$mapNotNull2 = (DataNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.getData();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.data");
                String string = ((ModuleData)object).getInternalName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            KotlinGradleProjectResolverExtensionKt.setImplementedModuleNames(dataNode, (List<String>)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DataNode<GradleSourceSetData>> getSourceSetsMap(@NotNull DataNode<ModuleData> $this$getSourceSetsMap) {
        void $this$associateByTo$iv$iv;
        Collection collection = ExternalSystemApiUtil.getChildren($this$getSourceSetsMap, (Key)GradleSourceSetData.KEY);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026 GradleSourceSetData.KEY)");
        Iterable $this$associateBy$iv = collection;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DataNode dataNode = (DataNode)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = this.getSourceSetName((DataNode<? extends ModuleData>)v1);
            map2.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final String getSourceSetName(@NotNull DataNode<? extends ModuleData> $this$sourceSetName) {
        Object object;
        Object object2 = $this$sourceSetName.getData();
        if (!(object2 instanceof GradleSourceSetData)) {
            object2 = null;
        }
        return (object = (GradleSourceSetData)object2) != null && (object = object.getId()) != null ? StringsKt.substringAfterLast$default((String)object, (char)':', null, (int)2, null) : null;
    }

    private final void addDependency(DataNode<? extends ModuleData> ideModule, DataNode<? extends ModuleData> targetModule) {
        ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ideModule.getData(), (ModuleData)targetModule.getData());
        moduleDependencyData.setScope(DependencyScope.COMPILE);
        moduleDependencyData.setExported(false);
        moduleDependencyData.setProductionOnTestDependency(Intrinsics.areEqual((Object)this.getSourceSetName(targetModule), (Object)"test"));
        ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
    }

    private final DataNode<ModuleData> findModuleById(DataNode<ProjectData> ideProject, IdeaModule gradleModule, String moduleId) {
        Object v8;
        block4: {
            String string;
            ProjectResolverContext projectResolverContext = this.resolverCtx;
            Intrinsics.checkExpressionValueIsNotNull((Object)projectResolverContext, (String)"resolverCtx");
            ProjectImportAction.AllModels allModels = projectResolverContext.getModels();
            Intrinsics.checkExpressionValueIsNotNull((Object)allModels, (String)"resolverCtx.models");
            boolean isCompositeProject = Intrinsics.areEqual((Object)allModels.getIdeaProject(), (Object)gradleModule.getProject()) ^ true;
            if (isCompositeProject && StringsKt.startsWith$default((String)moduleId, (String)":", (boolean)false, (int)2, null)) {
                IdeaProject ideaProject = gradleModule.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)ideaProject, (String)"gradleModule.project");
                string = ideaProject.getName();
            } else {
                string = "";
            }
            String compositePrefix = string;
            String fullModuleId = compositePrefix + moduleId;
            Collection collection = ideProject.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ideProject.children");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DataNode it = (DataNode)t;
                boolean bl3 = false;
                DataNode dataNode = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"it");
                Object object = dataNode.getData();
                if (!(object instanceof ModuleData)) {
                    object = null;
                }
                ModuleData moduleData = (ModuleData)object;
                if (!Intrinsics.areEqual((Object)(moduleData != null ? moduleData.getId() : null), (Object)fullModuleId)) continue;
                v8 = t;
                break block4;
            }
            v8 = null;
        }
        return v8;
    }

    /*
     * WARNING - void declaration
     */
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        Intrinsics.checkParameterIsNotNull((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkParameterIsNotNull(ideModule, (String)"ideModule");
        this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
        String string = GradleProjectResolverUtil.getModuleId((ProjectResolverContext)this.resolverCtx, (IdeaModule)gradleModule);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GradleProjectResolverUti\u2026esolverCtx, gradleModule)");
        String moduleNamePrefix = string;
        KotlinGradleModel kotlinGradleModel = (KotlinGradleModel)this.resolverCtx.getExtraProject(gradleModule, KotlinGradleModel.class);
        if (kotlinGradleModel != null) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            KotlinGradleModel kotlinGradleModel2 = kotlinGradleModel;
            boolean bl = false;
            boolean bl2 = false;
            KotlinGradleModel gradleModel = kotlinGradleModel2;
            boolean bl3 = false;
            KotlinGradleFUSLogger.Companion.populateGradleUserDir(gradleModel.getGradleUserHome());
            Map map2 = gradleModel.getKotlinTaskProperties();
            DataNode<ModuleData> dataNode = ideModule;
            boolean $i$f$flatMap = false;
            void var12_13 = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void var15_19 = $this$flatMapTo$iv$iv;
            boolean bl4 = false;
            Object object = var15_19.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = object.next();
                boolean bl5 = false;
                List list2 = ((KotlinTaskProperties)it.getValue()).getPureKotlinSourceFolders();
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Collection<String> collection = (List)destination$iv$iv;
            $this$flatMap$iv = collection;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                String string2 = it.getAbsolutePath();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            KotlinGradleProjectResolverExtensionKt.setPureKotlinSourceFolders(dataNode, (List<String>)collection);
            Collection collection2 = ideModule.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"ideModule.children");
            Iterable $this$filter$iv = collection2;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DataNode it = (DataNode)element$iv$iv;
                boolean bl7 = false;
                DataNode dataNode2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode2, (String)"it");
                if (!(dataNode2.getData() instanceof GradleSourceSetData)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection gradleSourceSets = (List)destination$iv$iv2;
            for (DataNode gradleSourceSetNode : gradleSourceSets) {
                void $this$filterTo$iv$iv2;
                Map $this$filter$iv2 = gradleModel.getKotlinTaskProperties();
                boolean $i$f$filter2 = false;
                Map item$iv$iv = $this$filter$iv2;
                Map destination$iv$iv3 = new LinkedHashMap();
                boolean $i$f$filterTo2 = false;
                void bl7 = $this$filterTo$iv$iv2;
                boolean bl5 = false;
                Iterator iterator2 = bl7.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void k;
                    Map.Entry element$iv$iv;
                    Map.Entry $dstr$k$v = element$iv$iv = iterator2.next();
                    boolean bl8 = false;
                    Map.Entry entry = $dstr$k$v;
                    boolean bl9 = false;
                    String string3 = (String)entry.getKey();
                    entry = $dstr$k$v;
                    bl9 = false;
                    KotlinTaskProperties v = (KotlinTaskProperties)entry.getValue();
                    Object object2 = gradleSourceSetNode.getData();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gradleSourceSetNode.data");
                    if (!Intrinsics.areEqual((Object)((GradleSourceSetData)object2).getId(), (Object)(moduleNamePrefix + ':' + (String)k))) continue;
                    destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Pair propertiesForSourceSet = (Pair)CollectionsKt.singleOrNull((List)MapsKt.toList((Map)destination$iv$iv3));
                Collection collection3 = gradleSourceSetNode.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"gradleSourceSetNode.children");
                Iterable $this$forEach$iv = collection3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Iterable it;
                    void $this$filterTo$iv$iv3;
                    Pair pair2;
                    String packagePrefix;
                    ContentRootData data2;
                    DataNode dataNode3 = (DataNode)element$iv;
                    boolean bl10 = false;
                    DataNode dataNode4 = dataNode3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataNode4, (String)"dataNode");
                    Object object3 = dataNode4.getData();
                    if (!(object3 instanceof ContentRootData)) {
                        object3 = null;
                    }
                    if ((data2 = (ContentRootData)object3) == null || (packagePrefix = (pair2 = propertiesForSourceSet) != null && (pair2 = (KotlinTaskProperties)pair2.getSecond()) != null ? pair2.getPackagePrefix() : null) == null) continue;
                    ExternalSystemSourceType[] $this$filter$iv3 = ExternalSystemSourceType.values();
                    boolean $i$f$filter3 = false;
                    ExternalSystemSourceType[] bl8 = $this$filter$iv3;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv3) {
                        it = element$iv$iv;
                        boolean bl11 = false;
                        if (!(!it.isResource() && !it.isGenerated())) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv2 = (List)destination$iv$iv4;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        void $this$mapTo$iv$iv2;
                        Collection paths;
                        ExternalSystemSourceType type2 = (ExternalSystemSourceType)element$iv2;
                        boolean bl12 = false;
                        Intrinsics.checkExpressionValueIsNotNull((Object)data2.getPaths(type2), (String)"data.getPaths(type)");
                        Iterable $this$map$iv2 = paths;
                        boolean $i$f$map2 = false;
                        it = $this$map$iv2;
                        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                            void it2;
                            ContentRootData.SourceRoot sourceRoot = (ContentRootData.SourceRoot)item$iv$iv2;
                            Collection collection4 = destination$iv$iv5;
                            boolean bl13 = false;
                            void v10 = it2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                            ContentRootData.SourceRoot sourceRoot2 = new ContentRootData.SourceRoot(v10.getPath(), packagePrefix);
                            collection4.add(sourceRoot2);
                        }
                        List newPaths = (List)destination$iv$iv5;
                        paths.clear();
                        paths.addAll(newPaths);
                    }
                }
            }
        }
    }

    public KotlinGradleProjectResolverExtension() {
        Logger logger = Logger.getInstance(PsiPrecedences.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(PsiPrecedences::class.java)");
        this.LOG = logger;
    }
}

