/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.completion.BasicLookupElementFactory;
import org.jetbrains.kotlin.idea.completion.LookupElementsCollector;
import org.jetbrains.kotlin.idea.completion.SmartCompletionInBasicWeigher;
import org.jetbrains.kotlin.idea.completion.handlers.WithTailInsertHandler;
import org.jetbrains.kotlin.idea.core.ArgumentPositionData;
import org.jetbrains.kotlin.idea.core.ExpectedInfo;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/completion/NamedArgumentCompletion;", "", "()V", "complete", "", "collector", "Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;", "expectedInfos", "", "Lorg/jetbrains/kotlin/idea/core/ExpectedInfo;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "isOnlyNamedArgumentExpected", "", "nameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "NamedArgumentInsertHandler", "idea"})
public final class NamedArgumentCompletion {
    public static final NamedArgumentCompletion INSTANCE;

    public final boolean isOnlyNamedArgumentExpected(@NotNull KtSimpleNameExpression nameExpression2) {
        boolean bl;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)nameExpression2, (String)"nameExpression");
            PsiElement psiElement2 = nameExpression2.getParent();
            if (!(psiElement2 instanceof KtValueArgument)) {
                psiElement2 = null;
            }
            KtValueArgument ktValueArgument = (KtValueArgument)psiElement2;
            if (ktValueArgument == null) {
                return false;
            }
            KtValueArgument thisArgument = ktValueArgument;
            if (thisArgument.isNamed()) {
                return false;
            }
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)thisArgument;
            boolean $i$f$getStrictParentOfType = false;
            KtCallElement ktCallElement = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallElement.class, (boolean)true);
            if (ktCallElement == null) {
                return false;
            }
            KtCallElement callElement2 = ktCallElement;
            List<? extends ValueArgument> list2 = callElement2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callElement.valueArguments");
            Iterable $this$takeWhile$iv = list2;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                ValueArgument it = (ValueArgument)item$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)thisArgument) ^ true)) break;
                list$iv.add(item$iv);
            }
            Iterable $this$any$iv = list$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueArgument it = (ValueArgument)element$iv;
                    boolean bl3 = false;
                    if (!it.isNamed()) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void complete(@NotNull LookupElementsCollector collector2, @NotNull Collection<ExpectedInfo> expectedInfos2, @NotNull CallType<?> callType) {
        Object argumentData;
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Intrinsics.checkParameterIsNotNull(expectedInfos2, (String)"expectedInfos");
        Intrinsics.checkParameterIsNotNull(callType, (String)"callType");
        if (Intrinsics.areEqual(callType, (Object)CallType.DEFAULT.INSTANCE) ^ true) {
            return;
        }
        HashMap nameToParameterType = new HashMap();
        for (ExpectedInfo entry : expectedInfos2) {
            ExpectedInfo.AdditionalData additionalData = entry.getAdditionalData();
            if (!(additionalData instanceof ArgumentPositionData.Positional)) {
                additionalData = null;
            }
            if ((ArgumentPositionData.Positional)additionalData == null) {
                continue;
            }
            for (ParameterDescriptor parameter : ((ArgumentPositionData.Positional)argumentData).getNamedArgumentCandidates()) {
                Object object;
                Name key$iv;
                void $this$getOrPut$iv232;
                Map map2 = nameToParameterType;
                Intrinsics.checkExpressionValueIsNotNull((Object)parameter.getName(), (String)"parameter.name");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv232.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    HashSet answer$iv = new HashSet();
                    $this$getOrPut$iv232.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Set set2 = (Set)object;
                KotlinType kotlinType = parameter.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.type");
                set2.add(kotlinType);
            }
        }
        argumentData = nameToParameterType;
        boolean parameter = false;
        for (Map.Entry entry : argumentData.entrySet()) {
            String nameString;
            void name2;
            Object object;
            block12: {
                block11: {
                    Object object2 = entry;
                    boolean $this$getOrPut$iv232 = false;
                    argumentData = (Name)object2.getKey();
                    object2 = entry;
                    $this$getOrPut$iv232 = false;
                    Set types2 = (Set)object2.getValue();
                    object = (KotlinType)CollectionsKt.singleOrNull((Iterable)types2);
                    if (object == null) break block11;
                    KotlinType $this$getOrPut$iv232 = object;
                    boolean key$iv = false;
                    boolean bl = false;
                    KotlinType it = $this$getOrPut$iv232;
                    boolean bl2 = false;
                    object = BasicLookupElementFactory.Companion.getSHORT_NAMES_RENDERER().renderType(it);
                    if (object != null) break block12;
                }
                object = "...";
            }
            Object typeText = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)name2.asString(), (String)"name.asString()");
            LookupElementBuilder lookupElement2 = LookupElementBuilder.create((String)(nameString + " =")).withPresentableText(nameString + " =").withTailText(' ' + (String)typeText).withIcon(KotlinIcons.PARAMETER).withInsertHandler((InsertHandler)new NamedArgumentInsertHandler((Name)name2));
            lookupElement2.putUserData(SmartCompletionInBasicWeigher.Companion.getNAMED_ARGUMENT_KEY(), (Object)Unit.INSTANCE);
            LookupElementBuilder lookupElementBuilder = lookupElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lookupElementBuilder, (String)"lookupElement");
            LookupElementsCollector.addElement$default(collector2, (LookupElement)lookupElementBuilder, false, 2, null);
        }
    }

    private NamedArgumentCompletion() {
    }

    static {
        NamedArgumentCompletion namedArgumentCompletion;
        INSTANCE = namedArgumentCompletion = new NamedArgumentCompletion();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/NamedArgumentCompletion$NamedArgumentInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameterName", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/Name;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea"})
    private static final class NamedArgumentInsertHandler
    implements InsertHandler<LookupElement> {
        private final Name parameterName;

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            Editor editor2 = context2.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"context.editor");
            Editor editor3 = editor2;
            String text2 = RenderingUtilsKt.render(this.parameterName);
            editor3.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)text2);
            editor3.getCaretModel().moveToOffset(context2.getStartOffset() + text2.length());
            WithTailInsertHandler.Companion.getEQ().postHandleInsert(context2, item);
        }

        public NamedArgumentInsertHandler(@NotNull Name parameterName2) {
            Intrinsics.checkParameterIsNotNull((Object)parameterName2, (String)"parameterName");
            this.parameterName = parameterName2;
        }
    }
}

