/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.actions.AutoImportVariant;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.ImportableFqNameClassifier;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u00060\fR\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/actions/Prioritizer;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "compareNames", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Z)V", "classifier", "Lorg/jetbrains/kotlin/idea/core/ImportableFqNameClassifier;", "proximityComparator", "Lcom/intellij/psi/util/proximity/PsiProximityComparator;", "priority", "Lorg/jetbrains/kotlin/idea/actions/Prioritizer$Priority;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Priority", "VariantWithPriority", "idea"})
final class Prioritizer {
    private final ImportableFqNameClassifier classifier;
    private final PsiProximityComparator proximityComparator;
    private final KtFile file;
    private final boolean compareNames;

    @NotNull
    public final Priority priority(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        return new Priority(descriptor2);
    }

    public Prioritizer(@NotNull KtFile file2, boolean compareNames) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.file = file2;
        this.compareNames = compareNames;
        this.classifier = new ImportableFqNameClassifier(this.file);
        this.proximityComparator = new PsiProximityComparator((PsiElement)this.file);
    }

    public /* synthetic */ Prioritizer(KtFile ktFile, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(ktFile, bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/actions/Prioritizer$Priority;", "", "Lorg/jetbrains/kotlin/idea/actions/Prioritizer;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/idea/actions/Prioritizer;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)V", "classification", "Lorg/jetbrains/kotlin/idea/core/ImportableFqNameClassifier$Classification;", "declaration", "Lcom/intellij/psi/PsiElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "isDeprecated", "", "compareTo", "", "other", "idea"})
    public final class Priority
    implements Comparable<Priority> {
        private final boolean isDeprecated;
        private final FqName fqName;
        private final ImportableFqNameClassifier.Classification classification;
        private final PsiElement declaration;

        @Override
        public int compareTo(@NotNull Priority other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            if (this.isDeprecated != other.isDeprecated) {
                return this.isDeprecated ? 1 : -1;
            }
            int c1 = this.classification.compareTo((Enum)other.classification);
            if (c1 != 0) {
                return c1;
            }
            int c2 = Prioritizer.this.proximityComparator.compare((Object)this.declaration, (Object)other.declaration);
            if (c2 != 0) {
                return c2;
            }
            if (Prioritizer.this.compareNames) {
                String string = this.fqName.asString();
                String string2 = other.fqName.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"other.fqName.asString()");
                return string.compareTo(string2);
            }
            return 0;
        }

        public Priority(DeclarationDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            this.isDeprecated = KotlinBuiltIns.isDeprecated(descriptor2);
            FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2);
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            this.fqName = fqName2;
            this.classification = Prioritizer.this.classifier.classify(this.fqName, false);
            Project project2 = Prioritizer.this.file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
            this.declaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, descriptor2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\r\u001a\u00060\u0005R\u00020\u0006H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005R\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0015\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/actions/Prioritizer$VariantWithPriority;", "", "variant", "Lorg/jetbrains/kotlin/idea/actions/AutoImportVariant;", "priority", "Lorg/jetbrains/kotlin/idea/actions/Prioritizer$Priority;", "Lorg/jetbrains/kotlin/idea/actions/Prioritizer;", "(Lorg/jetbrains/kotlin/idea/actions/AutoImportVariant;Lorg/jetbrains/kotlin/idea/actions/Prioritizer$Priority;)V", "getPriority", "()Lorg/jetbrains/kotlin/idea/actions/Prioritizer$Priority;", "getVariant", "()Lorg/jetbrains/kotlin/idea/actions/AutoImportVariant;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea"})
    public static final class VariantWithPriority {
        @NotNull
        private final AutoImportVariant variant;
        @NotNull
        private final Priority priority;

        @NotNull
        public final AutoImportVariant getVariant() {
            return this.variant;
        }

        @NotNull
        public final Priority getPriority() {
            return this.priority;
        }

        public VariantWithPriority(@NotNull AutoImportVariant variant, @NotNull Priority priority) {
            Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
            Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
            this.variant = variant;
            this.priority = priority;
        }

        @NotNull
        public final AutoImportVariant component1() {
            return this.variant;
        }

        @NotNull
        public final Priority component2() {
            return this.priority;
        }

        @NotNull
        public final VariantWithPriority copy(@NotNull AutoImportVariant variant, @NotNull Priority priority) {
            Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
            Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
            return new VariantWithPriority(variant, priority);
        }

        public static /* synthetic */ VariantWithPriority copy$default(VariantWithPriority variantWithPriority, AutoImportVariant autoImportVariant, Priority priority, int n, Object object) {
            if ((n & 1) != 0) {
                autoImportVariant = variantWithPriority.variant;
            }
            if ((n & 2) != 0) {
                priority = variantWithPriority.priority;
            }
            return variantWithPriority.copy(autoImportVariant, priority);
        }

        @NotNull
        public String toString() {
            return "VariantWithPriority(variant=" + this.variant + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            AutoImportVariant autoImportVariant = this.variant;
            Priority priority = this.priority;
            return (autoImportVariant != null ? autoImportVariant.hashCode() : 0) * 31 + (priority != null ? priority.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VariantWithPriority)) break block3;
                    VariantWithPriority variantWithPriority = (VariantWithPriority)object;
                    if (!Intrinsics.areEqual((Object)this.variant, (Object)variantWithPriority.variant) || !Intrinsics.areEqual((Object)this.priority, (Object)variantWithPriority.priority)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

