/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.IrReplacementFunction;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionBase;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u0006\u0010(\u001a\u00020)H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010(\u001a\u00020+2\u0006\u0010%\u001a\u00020&H\u0002J,\u0010,\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020.\u0012\u0006\u0012\u0004\u0018\u00010\u001a0-0\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\fH\u0016J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0011H\u0016J\u0010\u00109\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020IH\u0002J$\u0010J\u001a\u00020\u000f*\u0002002\u0006\u0010K\u001a\u00020)2\u0006\u0010L\u001a\u0002002\u0006\u0010%\u001a\u00020&H\u0002J\f\u0010M\u001a\u00020\u0018*\u00020\u001aH\u0002J\u001e\u0010N\u001a\u0004\u0018\u00010\u001a*\u00020O2\u0006\u0010P\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "valueMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "isSpecializedInlineClassEqEq", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "buildBoxFunction", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "buildPrimaryInlineClassConstructor", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildSpecializedEqualsMethod", "buildUnboxFunction", "coerceInlineClasses", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "from", "Lorg/jetbrains/kotlin/ir/types/IrType;", "to", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformConstructorFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "constructor", "replacement", "Lorg/jetbrains/kotlin/backend/jvm/lower/inlineclasses/IrReplacementFunction;", "transformFunctionFlat", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "transformSimpleFunctionFlat", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "typedArgumentList", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitCall", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitStatementContainer", "container", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementContainer;", "buildReplacement", "originalFunction", "original", "coerceToUnboxed", "specializeEqualsCall", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "left", "right", "backend.jvm"})
final class JvmInlineClassLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    private final Map<IrValueSymbol, IrValueDeclaration> valueMap;
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(declaration2);
        if (irConstructor != null) {
            IrConstructor irConstructor2 = irConstructor;
            boolean bl = false;
            boolean bl2 = false;
            IrConstructor it = irConstructor2;
            boolean bl3 = false;
            IrReplacementFunction irReplacementFunction = (IrReplacementFunction)this.context.getInlineClassReplacements().getGetReplacementFunction().invoke((Object)it);
            if (irReplacementFunction != null) {
                IrReplacementFunction irReplacementFunction2 = irReplacementFunction;
                boolean bl4 = false;
                boolean bl5 = false;
                IrReplacementFunction replacement2 = irReplacementFunction2;
                boolean bl6 = false;
                this.valueMap.putAll(replacement2.getValueParameterMap());
            }
        }
        TransformKt.transformDeclarationsFlat(declaration2, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
            final /* synthetic */ JvmInlineClassLowering this$0;

            @Nullable
            public final List<IrDeclaration> invoke(@NotNull IrDeclaration memberDeclaration) {
                List list2;
                Intrinsics.checkParameterIsNotNull((Object)memberDeclaration, (String)"memberDeclaration");
                if (memberDeclaration instanceof IrFunction) {
                    list2 = JvmInlineClassLowering.access$transformFunctionFlat(this.this$0, (IrFunction)memberDeclaration);
                } else {
                    memberDeclaration.accept(this.this$0, null);
                    list2 = null;
                }
                return list2;
            }
            {
                this.this$0 = jvmInlineClassLowering;
                super(1);
            }
        }));
        if (declaration2.isInline()) {
            IrConstructor irConstructor3 = IrUtilsKt.getPrimaryConstructor(declaration2);
            if (irConstructor3 == null) {
                Intrinsics.throwNpe();
            }
            IrConstructor irConstructor4 = irConstructor3;
            declaration2.getDeclarations().remove(irConstructor4);
            this.buildPrimaryInlineClassConstructor(declaration2, irConstructor4);
            this.buildBoxFunction(declaration2);
            this.buildUnboxFunction(declaration2);
            this.buildSpecializedEqualsMethod(declaration2);
        }
        return declaration2;
    }

    private final List<IrDeclaration> transformFunctionFlat(IrFunction function2) {
        List<IrDeclaration> list2;
        if (InlineClassAbiKt.isPrimaryInlineClassConstructor(function2)) {
            return null;
        }
        IrReplacementFunction replacement2 = (IrReplacementFunction)this.context.getInlineClassReplacements().getGetReplacementFunction().invoke((Object)function2);
        if (replacement2 == null) {
            this.transformChildrenVoid(function2);
            return null;
        }
        IrFunction irFunction = function2;
        if (irFunction instanceof IrSimpleFunction) {
            list2 = this.transformSimpleFunctionFlat((IrSimpleFunction)function2, replacement2);
        } else if (irFunction instanceof IrConstructor) {
            list2 = this.transformConstructorFlat((IrConstructor)function2, replacement2);
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    private final List<IrDeclaration> transformSimpleFunctionFlat(IrSimpleFunction function2, IrReplacementFunction replacement2) {
        IrFunction worker2 = replacement2.getFunction();
        this.valueMap.putAll(replacement2.getValueParameterMap());
        Iterable $this$forEach$iv = worker2.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        IrBody irBody = function2.getBody();
        worker2.setBody(irBody != null && (irBody = irBody.transform(this, null)) != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBody, worker2) : null);
        if (function2.getOverriddenSymbols().isEmpty() || worker2.getDispatchReceiverParameter() != null) {
            return CollectionsKt.listOf((Object)worker2);
        }
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, function2.getSymbol(), function2.getStartOffset(), function2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$run = declarationIrBuilder;
        boolean bl3 = false;
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$run, worker2);
        boolean bl4 = false;
        boolean bl5 = false;
        IrFunctionAccessExpression $this$apply = irFunctionAccessExpression;
        boolean bl6 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default($this$apply, function2, 0, 2, null);
        for (IrValueParameter parameter : IrUtilsKt.getExplicitParameters(function2)) {
            IrValueParameter newParameter;
            if (replacement2.getValueParameterMap().get(parameter.getSymbol()) == null) {
                continue;
            }
            IrMemberAccessExpressionKt.putArgument($this$apply, newParameter, ExpressionHelpersKt.irGet($this$run, parameter));
        }
        IrFunctionAccessExpression call2 = irFunctionAccessExpression;
        function2.setBody(ExpressionHelpersKt.irExprBody($this$run, call2));
        return CollectionsKt.listOf((Object[])new IrFunction[]{worker2, function2});
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> transformConstructorFlat(IrConstructor constructor2, IrReplacementFunction replacement2) {
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        IrFunction worker2 = replacement2.getFunction();
        this.valueMap.putAll(replacement2.getValueParameterMap());
        Object $this$forEach$iv = worker2.getValueParameters();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        $this$forEach$iv = LowerUtilsKt.createIrBuilder(this.context, worker2.getSymbol(), worker2.getStartOffset(), worker2.getEndOffset());
        IrFunction irFunction = worker2;
        boolean $i$f$irBlockBody = false;
        iterator2 = $this$irBlockBody$iv;
        int element$iv = ((IrElement)worker2).getStartOffset();
        int endOffset$iv$iv = ((IrElement)worker2).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder this_$iv$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv$iv;
        boolean bl = false;
        IrVariable thisVar = ExpressionHelpersKt.irTemporaryVarDeclaration($this$irBlockBody, worker2.getReturnType(), "$this", false);
        IrValueParameter irValueParameter = AdditionalIrUtilsKt.getConstructedClass(constructor2).getThisReceiver();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        this.valueMap.put(irValueParameter.getSymbol(), thisVar);
        Object object = constructor2.getBody();
        if (object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null) {
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrStatement statement2 = (IrStatement)element$iv2;
                boolean bl2 = false;
                $this$irBlockBody.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)statement2.transform(new IrElementTransformerVoid($this$irBlockBody, thisVar, this, worker2, constructor2){
                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody$inlined;
                    final /* synthetic */ IrVariable $thisVar$inlined;
                    final /* synthetic */ JvmInlineClassLowering this$0;
                    final /* synthetic */ IrFunction $worker$inlined;
                    final /* synthetic */ IrConstructor $constructor$inlined;
                    {
                        this.$this_irBlockBody$inlined = irBlockBodyBuilder;
                        this.$thisVar$inlined = irVariable2;
                        this.this$0 = jvmInlineClassLowering;
                        this.$worker$inlined = irFunction;
                        this.$constructor$inlined = irConstructor;
                    }

                    @NotNull
                    public IrStatement visitClass(@NotNull IrClass declaration2) {
                        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                        return declaration2;
                    }

                    @NotNull
                    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                        this.transformChildrenVoid(expression2);
                        return ExpressionHelpersKt.irSetVar(this.$this_irBlockBody$inlined, (IrVariableSymbol)this.$thisVar$inlined.getSymbol(), expression2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public IrExpression visitReturn(@NotNull IrReturn expression2) {
                        void endOffset$iv;
                        void startOffset$iv;
                        void $this$irBlock$iv;
                        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                        this.transformChildrenVoid(expression2);
                        if (Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)((IrConstructorSymbol)this.$constructor$inlined.getSymbol())) ^ true) {
                            return expression2;
                        }
                        IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody$inlined;
                        int n = expression2.getStartOffset();
                        int n2 = expression2.getEndOffset();
                        IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody$inlined;
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = null;
                        boolean $i$f$irBlock = false;
                        IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        IrBlockBuilder $this$irBlock = this_$iv$iv;
                        boolean bl = false;
                        $this$irBlock.unaryPlus(expression2.getValue());
                        $this$irBlock.unaryPlus(ExpressionHelpersKt.irGet($this$irBlock, this.$thisVar$inlined));
                        IrExpression irExpression = this_$iv$iv.doBuild();
                        return ExpressionHelpersKt.irReturn(irBuilderWithScope2, irExpression);
                    }
                }, null).transform(this, null), worker2));
            }
        }
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn($this$irBlockBody, ExpressionHelpersKt.irGet($this$irBlockBody, thisVar)));
        IrBlockBody irBlockBody2 = this_$iv$iv$iv.doBuild();
        irFunction.setBody(irBlockBody2);
        return CollectionsKt.listOf((Object)worker2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IrValueParameter, IrExpression>> typedArgumentList(IrFunction function2, IrMemberAccessExpression expression2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair pair2;
        Pair pair3;
        Pair pair4;
        IrValueParameter it;
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object[] objectArray = new Pair[2];
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        int n2 = 0;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            object3 = irValueParameter;
            n = n2;
            object2 = objectArray2;
            object = objectArray3;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl3 = false;
            pair4 = TuplesKt.to((Object)it, (Object)expression2.getDispatchReceiver());
            objectArray3 = object;
            objectArray2 = object2;
            n2 = n;
            pair3 = pair4;
        } else {
            pair3 = null;
        }
        objectArray2[n2] = pair3;
        Object[] objectArray4 = objectArray3;
        Object[] objectArray5 = objectArray3;
        int n3 = 1;
        IrValueParameter irValueParameter2 = function2.getExtensionReceiverParameter();
        if (irValueParameter2 != null) {
            object3 = irValueParameter2;
            n = n3;
            object2 = objectArray4;
            object = objectArray5;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl4 = false;
            pair4 = TuplesKt.to((Object)it, (Object)expression2.getExtensionReceiver());
            objectArray5 = object;
            objectArray4 = object2;
            n3 = n;
            pair2 = pair4;
        } else {
            pair2 = null;
        }
        objectArray4[n3] = pair2;
        object3 = function2.getValueParameters();
        object = CollectionsKt.listOfNotNull((Object[])objectArray5);
        boolean $i$f$map = false;
        void var5_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl5 = false;
            Pair pair5 = TuplesKt.to((Object)it2, (Object)expression2.getValueArgument(it2.getIndex()));
            object2.add(pair5);
        }
        object2 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)object, (Iterable)((Iterable)object2));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildReplacement(@NotNull IrMemberAccessExpression $this$buildReplacement, IrFunction originalFunction, IrMemberAccessExpression original, IrReplacementFunction replacement2) {
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom($this$buildReplacement, original);
        for (Pair<IrValueParameter, IrExpression> pair2 : this.typedArgumentList(originalFunction, original)) {
            IrValueParameter newParameter;
            void parameter;
            IrValueParameter irValueParameter = (IrValueParameter)pair2.component1();
            IrExpression argument2 = (IrExpression)pair2.component2();
            if (argument2 == null) continue;
            if (replacement2.getValueParameterMap().get(parameter.getSymbol()) == null) {
                continue;
            }
            IrMemberAccessExpressionKt.putArgument($this$buildReplacement, replacement2.getFunction(), newParameter, argument2.transform(this, null));
        }
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrReplacementFunction irReplacementFunction = (IrReplacementFunction)this.context.getInlineClassReplacements().getGetReplacementFunction().invoke((Object)expression2.getSymbol().getOwner());
        if (irReplacementFunction == null) {
            return super.visitFunctionReference(expression2);
        }
        IrReplacementFunction replacement2 = irReplacementFunction;
        IrFunction function2 = replacement2.getFunction();
        IrFunctionReferenceImpl irFunctionReferenceImpl = new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), function2.getSymbol(), function2.getTypeParameters().size(), function2.getValueParameters().size(), expression2.getOrigin());
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionReferenceImpl $this$apply = irFunctionReferenceImpl;
        boolean bl3 = false;
        this.buildReplacement($this$apply, expression2.getSymbol().getOwner(), expression2, replacement2);
        return (IrExpression)IrAttributeContainerKt.copyAttributes((IrAttributeContainer)irFunctionReferenceImpl, expression2);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFunction function2 = expression2.getSymbol().getOwner();
        IrReplacementFunction irReplacementFunction = (IrReplacementFunction)this.context.getInlineClassReplacements().getGetReplacementFunction().invoke((Object)function2);
        if (irReplacementFunction == null) {
            return super.visitFunctionAccess(expression2);
        }
        IrReplacementFunction replacement2 = irReplacementFunction;
        BackendContext backendContext = this.context;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)LowerUtilsKt.createIrBuilder(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset()), replacement2.getFunction());
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionAccessExpression $this$apply = irFunctionAccessExpression;
        boolean bl3 = false;
        this.buildReplacement($this$apply, function2, expression2, replacement2);
        return irFunctionAccessExpression;
    }

    private final IrCallImpl coerceInlineClasses(IrExpression argument2, IrType from, IrType to) {
        IrCallImpl irCallImpl = new IrCallImpl(-1, -1, to, (IrFunctionSymbol)this.context.getIr().getSymbols().getUnsafeCoerceIntrinsic(), null, null, 48, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl $this$apply = irCallImpl;
        boolean bl3 = false;
        $this$apply.putTypeArgument(0, from);
        $this$apply.putTypeArgument(1, to);
        $this$apply.putValueArgument(0, argument2);
        return irCallImpl;
    }

    private final IrCallImpl coerceToUnboxed(@NotNull IrExpression $this$coerceToUnboxed) {
        return this.coerceInlineClasses($this$coerceToUnboxed, $this$coerceToUnboxed.getType(), InlineClassAbiKt.unboxInlineClass($this$coerceToUnboxed.getType()));
    }

    private final IrExpression specializeEqualsCall(@NotNull IrBuilderWithScope $this$specializeEqualsCall, IrExpression left, IrExpression right2) {
        IrExpression irExpression;
        boolean rightNullCheck;
        if (IrUtilsKt.isNullConst(left) || IrUtilsKt.isNullConst(right2)) {
            return null;
        }
        boolean leftIsUnboxed = Intrinsics.areEqual((Object)InlineClassAbiKt.unboxInlineClass(left.getType()), (Object)left.getType()) ^ true;
        boolean rightIsUnboxed = Intrinsics.areEqual((Object)InlineClassAbiKt.unboxInlineClass(right2.getType()), (Object)right2.getType()) ^ true;
        if (!leftIsUnboxed && !rightIsUnboxed) {
            return null;
        }
        Function2<IrExpression, IrExpression, IrExpression> $fun$equals$1 = new Function2<IrExpression, IrExpression, IrExpression>(this, $this$specializeEqualsCall, rightIsUnboxed){
            final /* synthetic */ JvmInlineClassLowering this$0;
            final /* synthetic */ IrBuilderWithScope $this_specializeEqualsCall;
            final /* synthetic */ boolean $rightIsUnboxed;

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final IrExpression invoke(@NotNull IrExpression left, @NotNull IrExpression right) {
                block9: {
                    block8: {
                        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
                        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
                        if (IrTypeUtilsKt.isUnsigned(left.getType()) && IrTypeUtilsKt.isUnsigned(right.getType()) && this.$rightIsUnboxed) {
                            return ExpressionHelpersKt.irEquals$default(this.$this_specializeEqualsCall, JvmInlineClassLowering.access$coerceToUnboxed(this.this$0, left), JvmInlineClassLowering.access$coerceToUnboxed(this.this$0, right), null, 4, null);
                        }
                        v0 = IrTypesKt.getClassOrNull(left.getType());
                        if (v0 == null) {
                            Intrinsics.throwNpe();
                        }
                        klass = (IrClass)v0.getOwner();
                        if (!this.$rightIsUnboxed) break block8;
                        v1 = JvmInlineClassLowering.access$getContext$p(this.this$0).getInlineClassReplacements().getSpecializedEqualsMethod(klass, this.$this_specializeEqualsCall.getContext().getIrBuiltIns());
                        break block9;
                    }
                    $this$single$iv = IrUtilsKt.getFunctions(klass);
                    $i$f$single = false;
                    single$iv = null;
                    found$iv = false;
                    for (E element$iv : $this$single$iv) {
                        it = (IrSimpleFunction)element$iv;
                        $i$a$-single-JvmInlineClassLowering$specializeEqualsCall$1$equalsMethod$equals$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"equals")) ** GOTO lbl-1000
                        var14_13 = it.getOverriddenSymbols();
                        var15_14 = false;
                        if (var14_13.isEmpty() == false) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        if (found$iv) {
                            throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    equals = single$iv;
                    v3 = JvmInlineClassLowering.access$getContext$p(this.this$0).getInlineClassReplacements().getGetReplacementFunction().invoke((Object)equals);
                    if (v3 == null) {
                        Intrinsics.throwNpe();
                    }
                    v1 = ((IrReplacementFunction)v3).getFunction();
                }
                equalsMethod = v1;
                var5_15 = ExpressionHelpersKt.irCall(this.$this_specializeEqualsCall, equalsMethod);
                var6_5 = false;
                var7_6 = false;
                $this$apply = var5_15;
                $i$a$-apply-JvmInlineClassLowering$specializeEqualsCall$1$1 = false;
                $this$apply.putValueArgument(0, left);
                $this$apply.putValueArgument(1, right);
                return var5_15;
            }
            {
                this.this$0 = jvmInlineClassLowering;
                this.$this_specializeEqualsCall = irBuilderWithScope;
                this.$rightIsUnboxed = bl;
                super(2);
            }
        };
        boolean leftNullCheck = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(left.getType());
        boolean bl = rightNullCheck = rightIsUnboxed && org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(right2.getType());
        if (leftNullCheck || rightNullCheck) {
            IrExpression equalsRight;
            IrBuilderWithScope $this$irBlock$iv = $this$specializeEqualsCall;
            int startOffset$iv = $this$irBlock$iv.getStartOffset();
            int endOffset$iv = $this$irBlock$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            IrBlockBuilder $this$irBlock = this_$iv$iv;
            boolean bl2 = false;
            IrValueDeclaration leftVal = left instanceof IrGetValue ? ((IrGetValue)left).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default($this$irBlock, left, null, null, null, 14, null);
            IrValueDeclaration rightVal = right2 instanceof IrGetValue ? ((IrGetValue)right2).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default($this$irBlock, right2, null, null, null, 14, null);
            IrExpression equalsCall = $fun$equals$1.invoke((IrExpression)(leftNullCheck ? (IrExpressionBase)ExpressionHelpersKt.irImplicitCast($this$irBlock, ExpressionHelpersKt.irGet($this$irBlock, leftVal), IrTypesKt.makeNotNull(left.getType())) : (IrExpressionBase)ExpressionHelpersKt.irGet($this$irBlock, leftVal)), (IrExpression)(rightNullCheck ? (IrExpressionBase)ExpressionHelpersKt.irImplicitCast($this$irBlock, ExpressionHelpersKt.irGet($this$irBlock, rightVal), IrTypesKt.makeNotNull(right2.getType())) : (IrExpressionBase)ExpressionHelpersKt.irGet($this$irBlock, rightVal)));
            IrExpression irExpression2 = equalsRight = rightNullCheck ? (IrExpression)ExpressionHelpersKt.irIfNull($this$irBlock, $this$irBlock.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet($this$irBlock, rightVal), ExpressionHelpersKt.irFalse($this$irBlock), equalsCall) : equalsCall;
            if (leftNullCheck) {
                $this$irBlock.unaryPlus(ExpressionHelpersKt.irIfNull($this$irBlock, $this$irBlock.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet($this$irBlock, leftVal), ExpressionHelpersKt.irEqualsNull($this$irBlock, ExpressionHelpersKt.irGet($this$irBlock, rightVal)), equalsRight));
            } else {
                $this$irBlock.unaryPlus(equalsRight);
            }
            irExpression = this_$iv$iv.doBuild();
        } else {
            irExpression = $fun$equals$1.invoke(left, right2);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (InlineClassAbiKt.isInlineClassFieldGetter(expression2.getSymbol().getOwner())) {
            IrExpression irExpression2 = expression2.getDispatchReceiver();
            if (irExpression2 == null) {
                Intrinsics.throwNpe();
            }
            IrExpression arg = irExpression2.transform(this, null);
            IrValueParameter irValueParameter = expression2.getSymbol().getOwner().getDispatchReceiverParameter();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            irExpression = this.coerceInlineClasses(arg, irValueParameter.getType(), expression2.getType());
        } else if (this.isSpecializedInlineClassEqEq(expression2)) {
            this.transformChildrenVoid(expression2);
            BackendContext backendContext = this.context;
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            if (scopeWithIr == null) {
                Intrinsics.throwNpe();
            }
            IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            IrExpression irExpression3 = expression2.getValueArgument(0);
            if (irExpression3 == null) {
                Intrinsics.throwNpe();
            }
            IrExpression irExpression4 = expression2.getValueArgument(1);
            if (irExpression4 == null) {
                Intrinsics.throwNpe();
            }
            if ((irExpression = this.specializeEqualsCall(irBuilderWithScope, irExpression3, irExpression4)) == null) {
                irExpression = expression2;
            }
        } else {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    private final boolean isSpecializedInlineClassEqEq(@NotNull IrCall $this$isSpecializedInlineClassEqEq) {
        Object object;
        block5: {
            block4: {
                if (Intrinsics.areEqual((Object)$this$isSpecializedInlineClassEqEq.getSymbol(), (Object)this.context.getIrBuiltIns().getEqeqSymbol()) ^ true) {
                    return false;
                }
                object = $this$isSpecializedInlineClassEqEq.getValueArgument(0);
                if (object == null || (object = object.getType()) == null || (object = IrTypesKt.getClassOrNull((IrType)object)) == null || (object = (IrClass)object.getOwner()) == null) break block4;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = it.isInline() ? object2 : null;
                if (object != null) break block5;
            }
            return false;
        }
        Object leftClass = object;
        return Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)leftClass), (Object)DescriptorUtils.RESULT_FQ_NAME) ^ true || this.context.getState().getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        IrDeclarationParent parent2 = field2.getParent();
        if (parent2 instanceof IrClass && ((IrClass)parent2).isInline() && Intrinsics.areEqual((Object)field2.getName(), (Object)InlineClassAbiKt.getInlineClassFieldName((IrClass)parent2))) {
            IrExpression irExpression = expression2.getReceiver();
            if (irExpression == null) {
                Intrinsics.throwNpe();
            }
            IrExpression receiver2 = irExpression.transform(this, null);
            return this.coerceInlineClasses(receiver2, receiver2.getType(), field2.getType());
        }
        return super.visitGetField(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrReturnTarget $this$safeAs$iv = expression2.getReturnTargetSymbol().getOwner();
            boolean $i$f$safeAs = false;
            IrReturnTarget irReturnTarget = $this$safeAs$iv;
            if (!(irReturnTarget instanceof IrFunction)) {
                irReturnTarget = null;
            }
            IrFunction irFunction = (IrFunction)irReturnTarget;
            if (irFunction == null) break block2;
            IrFunction irFunction2 = irFunction;
            boolean bl = false;
            boolean bl2 = false;
            IrFunction target = irFunction2;
            boolean bl3 = false;
            IrReplacementFunction irReplacementFunction = (IrReplacementFunction)this.context.getInlineClassReplacements().getGetReplacementFunction().invoke((Object)target);
            if (irReplacementFunction != null) {
                IrReplacementFunction irReplacementFunction2 = irReplacementFunction;
                boolean bl4 = false;
                boolean bl5 = false;
                IrReplacementFunction it = irReplacementFunction2;
                boolean bl6 = false;
                return ExpressionHelpersKt.irReturn(LowerUtilsKt.createIrBuilder(this.context, it.getFunction().getSymbol(), expression2.getStartOffset(), expression2.getEndOffset()), expression2.getValue().transform(this, null));
            }
        }
        return super.visitReturn(expression2);
    }

    private final void visitStatementContainer(IrStatementContainer container2) {
        List<IrStatement> $this$transformFlat$iv = container2.getStatements();
        boolean $i$f$transformFlat = false;
        int i$iv = 0;
        while (i$iv < $this$transformFlat$iv.size()) {
            Integer n;
            List transformed$iv;
            IrStatement item$iv;
            IrStatement statement2 = item$iv = $this$transformFlat$iv.get(i$iv);
            boolean bl = false;
            List list2 = transformed$iv = statement2 instanceof IrFunction ? this.transformFunctionFlat((IrFunction)statement2) : CollectionsKt.listOf((Object)statement2.transform(this, null));
            Integer n2 = n = list2 != null ? Integer.valueOf(list2.size()) : null;
            if (n == null) {
                ++i$iv;
                continue;
            }
            if (n == 0) {
                $this$transformFlat$iv.remove(i$iv);
                continue;
            }
            if (n == 1) {
                $this$transformFlat$iv.set(i$iv++, (IrStatement)CollectionsKt.first((List)transformed$iv));
                continue;
            }
            $this$transformFlat$iv.addAll(i$iv, transformed$iv);
            $this$transformFlat$iv.remove(i$iv += transformed$iv.size());
        }
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.visitStatementContainer(expression2);
        return expression2;
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
        this.visitStatementContainer(body2);
        return body2;
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration irValueDeclaration2 = irValueDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            IrValueDeclaration it = irValueDeclaration2;
            boolean bl3 = false;
            return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
        }
        return super.visitGetValue(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitSetVariable(@NotNull IrSetVariable expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration irValueDeclaration2 = irValueDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            IrValueDeclaration it = irValueDeclaration2;
            boolean bl3 = false;
            IrValueSymbol irValueSymbol = it.getSymbol();
            if (irValueSymbol == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrVariableSymbol");
            }
            IrSetVariableImpl irSetVariableImpl = new IrSetVariableImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), (IrVariableSymbol)irValueSymbol, expression2.getOrigin());
            boolean bl4 = false;
            boolean bl5 = false;
            IrSetVariableImpl $this$apply = irSetVariableImpl;
            boolean bl6 = false;
            $this$apply.setValue(expression2.getValue().transform(this, null));
            return irSetVariableImpl;
        }
        return super.visitSetVariable(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPrimaryInlineClassConstructor(IrClass irClass, IrConstructor irConstructor) {
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        IrTypeParametersContainer $this$addConstructor$iv = irClass;
        boolean $i$f$addConstructor = false;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$run$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$buildConstructor$iv = $this$run$iv$iv;
        int n = 0;
        IrFunctionBuilder $this$addConstructor = $this$buildConstructor$iv;
        boolean bl4 = false;
        $this$addConstructor.updateFrom(irConstructor);
        Visibility visibility2 = Visibilities.PRIVATE;
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"Visibilities.PRIVATE");
        $this$addConstructor.setVisibility(visibility2);
        $this$addConstructor.setOrigin(JvmLoweredDeclarationOrigin.SYNTHETIC_INLINE_CLASS_MEMBER.INSTANCE);
        $this$addConstructor.setReturnType(irConstructor.getReturnType());
        $this$buildConstructor$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrConstructorImpl irConstructorImpl = DeclarationBuildersKt.buildConstructor($this$run$iv$iv);
        boolean bl5 = false;
        bl = false;
        Object constructor$iv = irConstructorImpl;
        boolean $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        ((IrDeclarationBase)constructor$iv).setParent($this$addConstructor$iv);
        $this$addConstructor$iv = irConstructorImpl;
        boolean bl6 = false;
        boolean bl7 = false;
        IrTypeParametersContainer $this$apply = $this$addConstructor$iv;
        boolean bl8 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)$this$apply, irConstructor);
        constructor$iv = LowerUtilsKt.createIrBuilder$default(this.context, ((IrConstructorImpl)$this$apply).getSymbol(), 0, 0, 6, null);
        IrTypeParametersContainer $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = $this$apply;
        boolean $i$f$irBlockBody = false;
        $this$buildConstructor$iv = $this$irBlockBody$iv;
        n = ((IrElement)$this$apply).getStartOffset();
        int endOffset$iv$iv = ((IrElement)$this$apply).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder this_$iv$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv$iv;
        boolean bl9 = false;
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall($this$irBlockBody, (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$irBlockBody.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        IrBuilderWithScope irBuilderWithScope = $this$irBlockBody;
        IrBuilderWithScope irBuilderWithScope2 = $this$irBlockBody;
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), InlineClassesKt.getInlineClassBackingField(irClass), ExpressionHelpersKt.irGet($this$irBlockBody, ((IrFunctionBase)$this$apply).getValueParameters().get(0))));
        IrBlockBody irBlockBody2 = this_$iv$iv$iv.doBuild();
        ((IrFunctionBase)$i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22).setBody(irBlockBody2);
        Object object = this.context.getInlineClassReplacements().getGetReplacementFunction().invoke((Object)irConstructor);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        IrFunction function2 = ((IrReplacementFunction)object).getFunction();
        Object object2 = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        bl7 = false;
        boolean bl10 = false;
        DeclarationIrBuilder $this$with = object2;
        boolean bl11 = false;
        IrValueParameter argument2 = function2.getValueParameters().get(0);
        function2.setBody(ExpressionHelpersKt.irExprBody($this$with, this.coerceInlineClasses(ExpressionHelpersKt.irGet($this$with, argument2), argument2.getType(), function2.getReturnType())));
        object2 = irClass.getDeclarations();
        bl7 = false;
        object2.add(function2);
    }

    private final void buildBoxFunction(IrClass irClass) {
        IrSimpleFunction function2 = (IrSimpleFunction)this.context.getInlineClassReplacements().getGetBoxFunction().invoke((Object)irClass);
        Object object = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = object;
        boolean bl3 = false;
        IrBuilderWithScope irBuilderWithScope = $this$with;
        IrBuilderWithScope irBuilderWithScope2 = $this$with;
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(irClass);
        if (irConstructor == null) {
            Intrinsics.throwNpe();
        }
        IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCall(irBuilderWithScope2, (IrConstructorSymbol)irConstructor.getSymbol());
        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl4 = false;
        boolean bl5 = false;
        IrConstructorCall $this$apply = irConstructorCall;
        boolean bl6 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default($this$apply, function2, 0, 2, null);
        $this$apply.putValueArgument(0, ExpressionHelpersKt.irGet($this$with, function2.getValueParameters().get(0)));
        IrConstructorCall irConstructorCall2 = irConstructorCall;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope3, irConstructorCall2));
        object = irClass.getDeclarations();
        bl = false;
        object.add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildUnboxFunction(IrClass irClass) {
        void $this$irBlockBody$iv;
        IrSimpleFunction function2 = (IrSimpleFunction)this.context.getInlineClassReplacements().getGetUnboxFunction().invoke((Object)irClass);
        IrField field2 = InlineClassesKt.getInlineClassBackingField(irClass);
        Object object = LowerUtilsKt.createIrBuilder$default(this.context, function2.getSymbol(), 0, 0, 6, null);
        IrSimpleFunction irSimpleFunction = function2;
        int startOffset$iv = $this$irBlockBody$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder this_$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv;
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = $this$irBlockBody;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        IrGetValueImpl thisVal = ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter);
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn($this$irBlockBody, ExpressionHelpersKt.irGetField($this$irBlockBody, thisVal, field2)));
        IrBlockBody irBlockBody2 = this_$iv$iv.doBuild();
        irSimpleFunction.setBody(irBlockBody2);
        object = irClass.getDeclarations();
        boolean bl2 = false;
        object.add(function2);
    }

    private final void buildSpecializedEqualsMethod(IrClass irClass) {
        IrSimpleFunction function2 = this.context.getInlineClassReplacements().getSpecializedEqualsMethod(irClass, this.context.getIrBuiltIns());
        IrValueParameter left = function2.getValueParameters().get(0);
        IrValueParameter right2 = function2.getValueParameters().get(1);
        IrType type2 = InlineClassAbiKt.unboxInlineClass(left.getType());
        Object object = LowerUtilsKt.createIrBuilder$default(this.context, irClass.getSymbol(), 0, 0, 6, null);
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$run = object;
        boolean bl3 = false;
        IrExpressionBodyImpl irExpressionBodyImpl = ExpressionHelpersKt.irExprBody($this$run, ExpressionHelpersKt.irEquals$default($this$run, this.coerceInlineClasses(ExpressionHelpersKt.irGet($this$run, left), left.getType(), type2), this.coerceInlineClasses(ExpressionHelpersKt.irGet($this$run, right2), right2.getType(), type2), null, 4, null));
        irSimpleFunction.setBody(irExpressionBodyImpl);
        object = irClass.getDeclarations();
        bl = false;
        object.add(function2);
    }

    public JvmInlineClassLowering(@NotNull JvmBackendContext context2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        JvmInlineClassLowering jvmInlineClassLowering = this;
        boolean bl = false;
        jvmInlineClassLowering.valueMap = map2 = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ List access$transformFunctionFlat(JvmInlineClassLowering $this, IrFunction function2) {
        return $this.transformFunctionFlat(function2);
    }

    public static final /* synthetic */ IrCallImpl access$coerceToUnboxed(JvmInlineClassLowering $this, IrExpression $this$access_u24coerceToUnboxed) {
        return $this.coerceToUnboxed($this$access_u24coerceToUnboxed);
    }

    public static final /* synthetic */ JvmBackendContext access$getContext$p(JvmInlineClassLowering $this) {
        return $this.context;
    }
}

