/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.konan.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.konan.KonanLog;
import com.jetbrains.konan.debugger.KonanLocalDebugProcess;
import com.jetbrains.konan.debugger.KonanStackFrameKt;
import com.jetbrains.konan.debugger.PositionType;
import com.jetbrains.konan.debugger.TypedPosition;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u001cJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/jetbrains/konan/debugger/KonanStackFrame;", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "suspensionCause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "debugProcess", "Lcom/jetbrains/konan/debugger/KonanLocalDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;Lcom/jetbrains/konan/debugger/KonanLocalDebugProcess;)V", "typedPosition", "Lcom/jetbrains/konan/debugger/TypedPosition;", "getTypedPosition", "()Lcom/jetbrains/konan/debugger/TypedPosition;", "typedPosition$delegate", "Lkotlin/Lazy;", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "disasmPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "doGetSourcePosition", "functionName", "", "getSourcePosition", "hasSourceFile", "", "isLibraryFile", "resolveLocalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "name", "common-native"})
public final class KonanStackFrame
extends CidrStackFrame {
    private final Lazy typedPosition$delegate;
    private final KonanLocalDebugProcess debugProcess;

    private final TypedPosition getTypedPosition() {
        Lazy lazy = this.typedPosition$delegate;
        KonanStackFrame konanStackFrame = this;
        Object var3_3 = null;
        boolean bl = false;
        return (TypedPosition)lazy.getValue();
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.getTypedPosition().getSourcePosition();
    }

    public boolean hasSourceFile() {
        return this.getTypedPosition().getType() != PositionType.DISASSEMBLED;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component2) {
        Intrinsics.checkParameterIsNotNull((Object)component2, (String)"component");
        component2.setIcon(AllIcons.Debugger.Frame);
        if (this.getTypedPosition().getType() != PositionType.DISASSEMBLED) {
            component2.append(this.functionName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            StringBuilder stringBuilder2 = new StringBuilder().append(' ');
            XSourcePosition xSourcePosition = this.getTypedPosition().getSourcePosition();
            if (xSourcePosition == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile virtualFile2 = xSourcePosition.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"typedPosition.sourcePosition!!.file");
            StringBuilder stringBuilder3 = stringBuilder2.append(virtualFile2.getName()).append(':');
            XSourcePosition xSourcePosition2 = this.getTypedPosition().getSourcePosition();
            if (xSourcePosition2 == null) {
                Intrinsics.throwNpe();
            }
            component2.append(stringBuilder3.append(xSourcePosition2.getLine() + 1).toString(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component2.append(this.functionName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            StringBuilder stringBuilder4 = new StringBuilder().append(" ");
            LLFrame lLFrame = this.getFrame();
            Intrinsics.checkExpressionValueIsNotNull((Object)lLFrame, (String)"frame");
            component2.append(stringBuilder4.append(lLFrame.getProgramCounter()).toString(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    private final XSourcePosition disasmPosition() {
        LLFrame lLFrame = this.getFrame();
        Intrinsics.checkExpressionValueIsNotNull((Object)lLFrame, (String)"frame");
        return this.debugProcess.createDisasmPosition(lLFrame.getProgramCounter());
    }

    private final TypedPosition doGetSourcePosition() {
        LLFrame lLFrame = this.getFrame();
        Intrinsics.checkExpressionValueIsNotNull((Object)lLFrame, (String)"frame");
        if (lLFrame.getFile() == null) {
            return KonanStackFrameKt.access$invoke(PositionType.DISASSEMBLED, this.disasmPosition());
        }
        LLFrame lLFrame2 = this.getFrame();
        Intrinsics.checkExpressionValueIsNotNull((Object)lLFrame2, (String)"frame");
        String string = lLFrame2.getFile();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"frame.file!!");
        VirtualFile virtualFile2 = this.resolveLocalFile(string);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile3;
            boolean bl3 = false;
            XDebuggerUtil xDebuggerUtil = XDebuggerUtil.getInstance();
            LLFrame lLFrame3 = this.getFrame();
            Intrinsics.checkExpressionValueIsNotNull((Object)lLFrame3, (String)"frame");
            XSourcePosition position2 = xDebuggerUtil.createPosition(it, lLFrame3.getLine());
            return KonanStackFrameKt.access$invoke(PositionType.PROJECT_FILE, position2);
        }
        LLFrame lLFrame4 = this.getFrame();
        Intrinsics.checkExpressionValueIsNotNull((Object)lLFrame4, (String)"frame");
        String string2 = lLFrame4.getFile();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"frame.file!!");
        VirtualFile virtualFile4 = this.debugProcess.resolveFile(string2);
        if (virtualFile4 != null) {
            VirtualFile virtualFile5 = virtualFile4;
            boolean bl = false;
            boolean bl4 = false;
            VirtualFile it = virtualFile5;
            boolean bl5 = false;
            XDebuggerUtil xDebuggerUtil = XDebuggerUtil.getInstance();
            LLFrame lLFrame5 = this.getFrame();
            Intrinsics.checkExpressionValueIsNotNull((Object)lLFrame5, (String)"frame");
            XSourcePosition position3 = xDebuggerUtil.createPosition(it, lLFrame5.getLine());
            return KonanStackFrameKt.access$invoke(PositionType.LIBRARY_FILE, position3);
        }
        return KonanStackFrameKt.access$invoke(PositionType.DISASSEMBLED, this.disasmPosition());
    }

    private final VirtualFile resolveLocalFile(String name2) {
        return (VirtualFile)ReadAction.compute((ThrowableComputable)new ThrowableComputable<T, E>(this, name2){
            final /* synthetic */ KonanStackFrame this$0;
            final /* synthetic */ String $name;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final VirtualFile compute() {
                void var2_2;
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(this.$name);
                if (virtualFile2 == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"LocalFileSystem.getInsta\u2026e) ?: return@compute null");
                VirtualFile vFile = virtualFile2;
                CidrDebugProcess cidrDebugProcess = this.this$0.getProcess();
                Intrinsics.checkExpressionValueIsNotNull((Object)cidrDebugProcess, (String)"process");
                VirtualFile virtualFile3 = ProjectRootUtil.findSymlinkedFileInContent((Project)cidrDebugProcess.getProject(), (VirtualFile)vFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"ProjectRootUtil.findSyml\u2026t(process.project, vFile)");
                VirtualFile resolvedFile = virtualFile3;
                if (KonanLog.INSTANCE.getLOG().isTraceEnabled() && Intrinsics.areEqual((Object)vFile, (Object)resolvedFile) ^ true) {
                    KonanLog.INSTANCE.getLOG().trace("Debugger path resolved: " + vFile + " -> " + resolvedFile);
                }
                return var2_2;
            }
            {
                this.this$0 = konanStackFrame;
                this.$name = string;
            }
        });
    }

    public final boolean isLibraryFile() {
        return this.getTypedPosition().getType() != PositionType.PROJECT_FILE;
    }

    private final String functionName() {
        String fullName;
        LLFrame lLFrame = this.getFrame();
        Intrinsics.checkExpressionValueIsNotNull((Object)lLFrame, (String)"frame");
        String string = lLFrame.getFunction();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"frame.function");
        String unmangledName = string;
        if (!StringsKt.startsWith$default((String)unmangledName, (String)"kfun:", (boolean)false, (int)2, null)) {
            return unmangledName;
        }
        if (!StringsKt.contains$default((CharSequence)unmangledName, (char)'(', (boolean)false, (int)2, null)) {
            return StringsKt.removePrefix((String)unmangledName, (CharSequence)"kfun:");
        }
        String string2 = unmangledName;
        int n = "kfun:".length();
        int n2 = StringsKt.indexOf$default((CharSequence)unmangledName, (char)'(', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string2 = fullName = string4;
        n = StringsKt.lastIndexOf$default((CharSequence)fullName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        n2 = 0;
        String string5 = string2;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        return string6;
    }

    public KonanStackFrame(@NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause, @NotNull KonanLocalDebugProcess debugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)thread, (String)"thread");
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)((Object)debugProcess), (String)"debugProcess");
        super((CidrDebugProcess)debugProcess, thread, frame, suspensionCause);
        this.debugProcess = debugProcess;
        this.typedPosition$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypedPosition>(this){
            final /* synthetic */ KonanStackFrame this$0;

            @NotNull
            public final TypedPosition invoke() {
                return KonanStackFrame.access$doGetSourcePosition(this.this$0);
            }
            {
                this.this$0 = konanStackFrame;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ TypedPosition access$doGetSourcePosition(KonanStackFrame $this) {
        return $this.doGetSourcePosition();
    }
}

