/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.api;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

public abstract class SimpleDecodingTestDiscoveryProtocolReader
implements TestDiscoveryProtocolReader,
TestDiscoveryProtocolReader.NameEnumeratorReader,
TestDiscoveryProtocolReader.MetadataReader {
    private final TIntObjectHashMap<String> enumerator = new TIntObjectHashMap();

    protected abstract void processData(String var1, String var2, String var3, String var4);

    protected void processAffectedFile(String testClassName, String testMethodName, String filePath) {
    }

    protected abstract void processClassMetadataData(ClassMetadata var1);

    public void debug(String message) {
    }

    public void error(String message) {
    }

    public void error(Exception error) {
    }

    public void testDiscoveryDataProcessingStarted(int version) {
    }

    public void testDiscoveryDataProcessingFinished() {
    }

    public TestDiscoveryProtocolReader.MetadataReader createMetadataReader() {
        return this;
    }

    public TestDiscoveryProtocolReader.ClassMetadataReader createClassMetadataReader() {
        return new TestDiscoveryProtocolReader.ClassMetadataReader(){
            private Map<String, byte[]> methods;
            private List<String> files;
            private String fqn;
            {
                this.reset();
            }

            public void classStarted(int classId) {
                this.fqn = (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(classId);
            }

            public void file(int fileId) {
                this.files.add((String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(fileId));
            }

            public void method(int methodId, byte[] hash) {
                this.methods.put((String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(methodId), hash);
            }

            public void classFinished(int classId) {
                SimpleDecodingTestDiscoveryProtocolReader.this.processClassMetadataData(new ClassMetadata(this.fqn, this.files, this.methods));
                this.reset();
            }

            private void reset() {
                this.fqn = null;
                this.files = new ArrayList<String>(1);
                this.methods = new HashMap<String, byte[]>(16);
            }

            public void finished() {
            }
        };
    }

    public TestDiscoveryProtocolReader.NameEnumeratorReader createNameEnumeratorReader() {
        return this;
    }

    public void enumerate(String name, int id) {
        this.enumerator.put(id, name);
    }

    public TestDiscoveryProtocolReader.TestDataReader createTestDataReader(final int testClassId, final int testMethodId) {
        return new TestDiscoveryProtocolReader.TestDataReader(){
            private String currentClassName;

            public void classProcessingStarted(int classId) {
                this.currentClassName = (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(classId);
            }

            public void processUsedMethod(int methodId) {
                SimpleDecodingTestDiscoveryProtocolReader.this.processData((String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(testClassId), (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(testMethodId), this.currentClassName, (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(methodId));
            }

            public void classProcessingFinished(int classId) {
            }

            public void testDataProcessed() {
            }

            public void processAffectedFile(int[] chunks) {
                SimpleDecodingTestDiscoveryProtocolReader.this.processAffectedFile((String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(testClassId), (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(testMethodId), SimpleDecodingTestDiscoveryProtocolReader.this.decodeFile(chunks));
            }
        };
    }

    private String decodeFile(int[] chunks) {
        if (chunks.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int chunk : chunks) {
            sb.append(this.enumerator.get(chunk)).append("/");
        }
        sb.setLength(sb.length() - "/".length());
        return sb.toString();
    }
}

