/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.sceneBuilder.EditorCallback;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilder;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderUtil;

public class SceneBuilderEditor
extends UserDataHolderBase
implements FileEditor,
EditorCallback {
    private static final Logger LOG = Logger.getInstance(SceneBuilderEditor.class);
    private static final String SCENE_CARD = "scene_builder";
    private static final String ERROR_CARD = "error";
    private final Project myProject;
    private final VirtualFile myFile;
    private final CardLayout myLayout;
    private final JPanel myPanel;
    private final JPanel myErrorPanel;
    private final HyperlinkLabel myErrorLabel;
    private JTextArea myErrorStack;
    private final Document myDocument;
    private final ExternalChangeListener myChangeListener;
    private SceneBuilder mySceneBuilder;

    public SceneBuilderEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SceneBuilderEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SceneBuilderEditor.$$$reportNull$$$0(1);
        }
        this.myLayout = new CardLayout();
        this.myPanel = new JPanel(this.myLayout);
        this.myErrorPanel = new JPanel(new BorderLayout());
        this.myErrorLabel = new HyperlinkLabel();
        this.myProject = project;
        this.myFile = file;
        this.myDocument = FileDocumentManager.getInstance().getDocument(file);
        this.myChangeListener = new ExternalChangeListener();
        this.createErrorPage();
    }

    private void createErrorPage() {
        this.myErrorLabel.setOpaque(false);
        this.myErrorLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                SceneBuilderEditor.this.updateState();
            }
        });
        this.myErrorStack = new JTextArea(50, 20);
        this.myErrorStack.setEditable(false);
        this.myErrorPanel.add((Component)this.myErrorLabel, "North");
        this.myErrorPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myErrorStack), "Center");
        this.myPanel.add(this.myErrorPanel);
    }

    private void showErrorPage(Throwable e) {
        String description;
        if (e != null) {
            LOG.info(e);
        }
        this.removeSceneBuilder();
        if (JavaVersion.current().feature == 11 && e instanceof NoClassDefFoundError && !SceneBuilderUtil.getSceneBuilder11Path().toFile().isFile()) {
            this.myErrorLabel.addHyperlinkListener(e1 -> {
                DownloadableFileService service = DownloadableFileService.getInstance();
                DownloadableFileDescription description = service.createFileDescription("https://cache-redirector.jetbrains.com/jetbrains.bintray.com/intellij-third-party-dependencies/org/jetbrains/intellij/deps/scenebuilderkit/11.0.2/scenebuilderkit-11.0.2.jar", "scenebuilderkit-11.0.2.jar");
                FileDownloader downloader = service.createDownloader(Collections.singletonList(description), "Scene Builder Kit");
                try {
                    Path tempDir = Files.createTempDirectory("", new FileAttribute[0]);
                    List list = downloader.downloadWithProgress(tempDir.toString(), this.myProject, (JComponent)this.myErrorPanel);
                    if (list == null || list.isEmpty()) {
                        this.myErrorLabel.setHyperlinkText(JavaFXBundle.message("javafx.scene.builder.editor.failed.to.download.kit.error", new Object[0]), "", "");
                        this.myErrorLabel.setIcon(Messages.getErrorIcon());
                        return;
                    }
                    FileUtil.copy((File)VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)((Pair)list.get((int)0)).first)), (File)SceneBuilderUtil.getSceneBuilder11Path().toFile());
                    FileUtil.delete((File)tempDir.toFile());
                    SceneBuilderUtil.updateLoader();
                    this.updateState();
                }
                catch (IOException e2) {
                    LOG.warn("Can't download SceneBuilderKit", (Throwable)e2);
                }
            });
            this.myErrorLabel.setHyperlinkText(JavaFXBundle.message("javafx.scene.builder.editor.failed.to.open.file.error", new Object[0]), JavaFXBundle.message("javafx.scene.builder.editor.download.scene.builder.kit", new Object[0]), "");
            this.myErrorLabel.setIcon(Messages.getErrorIcon());
            this.myLayout.show(this.myPanel, ERROR_CARD);
            return;
        }
        if (e != null) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Throwable t = e; t != null && t != t.getCause(); t = t.getCause()) {
                String message = SceneBuilderEditor.getErrorMessage(t);
                if (messages.isEmpty() || !((String)messages.get(messages.size() - 1)).contains(message)) {
                    messages.add(message);
                    continue;
                }
                messages.set(messages.size() - 1, message);
            }
            Collections.reverse(messages);
            description = "\n" + String.join((CharSequence)"\n\n", messages);
        } else {
            description = "Unknown error occurred";
        }
        this.myErrorLabel.setHyperlinkText(JavaFXBundle.message("javafx.scene.builder.editor.failed.to.open.file.error", new Object[0]), "", "");
        this.myErrorLabel.setIcon(Messages.getErrorIcon());
        this.myErrorStack.setText(description);
        this.myErrorStack.setVisible(true);
        this.myLayout.show(this.myPanel, ERROR_CARD);
    }

    private static String getErrorMessage(Throwable e) {
        String message = e.getMessage();
        String className = e.getClass().getName();
        if (StringUtil.isEmpty((String)message)) {
            if (e instanceof ClassNotFoundException) {
                return className + ": Unresolved import";
            }
            return className;
        }
        if (!message.contains(className)) {
            return className + ": " + message;
        }
        return message;
    }

    @Override
    public void saveChanges(String content) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.mySceneBuilder != null) {
                if (!this.myDocument.isWritable() && ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(Collections.singletonList(this.myFile)).hasReadonlyFiles()) {
                    return;
                }
                try {
                    this.myChangeListener.setRunState(false);
                    ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.myDocument.setText((CharSequence)content), JavaFXBundle.message("javafx.scene.builder.editor.scene.builder.edit.operation", new Object[0]), null));
                }
                finally {
                    this.myChangeListener.setRunState(true);
                }
            }
        });
    }

    @Override
    public void handleError(Throwable e) {
        UIUtil.invokeLaterIfNeeded(() -> this.showErrorPage(e));
    }

    private void updateState() {
        this.addSceneBuilder();
    }

    private void addSceneBuilder() {
        ApplicationManager.getApplication().invokeLater(this::addSceneBuilderImpl, ModalityState.defaultModalityState());
    }

    private void addSceneBuilderImpl() {
        try {
            ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveDocument(this.myDocument));
            if (this.mySceneBuilder != null && this.mySceneBuilder.reload()) {
                return;
            }
            this.removeSceneBuilder();
            this.mySceneBuilder = SceneBuilderUtil.create(new File(this.myFile.getPath()).toURI().toURL(), this.myProject, this);
            this.myPanel.add((Component)this.mySceneBuilder.getPanel(), SCENE_CARD);
            this.myLayout.show(this.myPanel, SCENE_CARD);
            this.myChangeListener.start();
        }
        catch (Throwable e) {
            this.showErrorPage(e);
        }
    }

    private void removeSceneBuilder() {
        this.myChangeListener.stop();
        if (this.mySceneBuilder != null) {
            this.myPanel.remove(this.mySceneBuilder.getPanel());
            this.mySceneBuilder.close();
            this.mySceneBuilder = null;
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            SceneBuilderEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySceneBuilder == null ? this.myErrorPanel : this.mySceneBuilder.getPanel();
    }

    public void dispose() {
        this.removeSceneBuilder();
        this.myChangeListener.dispose();
    }

    @NotNull
    public String getName() {
        return "Scene Builder";
    }

    public void selectNotify() {
        this.updateState();
    }

    public void deselectNotify() {
        this.myChangeListener.stop();
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            SceneBuilderEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public boolean isModified() {
        return false;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            SceneBuilderEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            SceneBuilderEditor.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExternalChangeListener
    implements DocumentListener {
        private volatile boolean myRunState;

        ExternalChangeListener() {
            SceneBuilderEditor.this.myDocument.addDocumentListener((DocumentListener)this);
        }

        public void start() {
            if (!this.myRunState) {
                this.myRunState = true;
            }
        }

        public void stop() {
            if (this.myRunState) {
                this.myRunState = false;
            }
        }

        public void setRunState(boolean state) {
            this.myRunState = state;
        }

        public void dispose() {
            SceneBuilderEditor.this.myDocument.removeDocumentListener((DocumentListener)this);
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                ExternalChangeListener.$$$reportNull$$$0(0);
            }
            if (this.myRunState) {
                SceneBuilderEditor.this.addSceneBuilder();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditor$ExternalChangeListener", "documentChanged"));
        }
    }
}

