/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxControllerFieldSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, final @NotNull Processor<? super PsiReference> consumer) {
        String qualifiedName;
        PsiField field;
        PsiClass containingClass;
        PsiElement elementToSearch;
        if (queryParameters == null) {
            JavaFxControllerFieldSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaFxControllerFieldSearcher.$$$reportNull$$$0(1);
        }
        if ((elementToSearch = queryParameters.getElementToSearch()) instanceof PsiField && (containingClass = (PsiClass)ReadAction.compute(() -> JavaFxControllerFieldSearcher.lambda$execute$0(field = (PsiField)elementToSearch))) != null && (qualifiedName = (String)ReadAction.compute(() -> containingClass.getQualifiedName())) != null) {
            Project project = PsiUtilCore.getProjectInReadAction((PsiElement)containingClass);
            List<PsiFile> fxmlWithController = JavaFxControllerClassIndex.findFxmlWithController(project, qualifiedName);
            for (PsiFile file : fxmlWithController) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    final String fieldName = field.getName();
                    VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
                    SearchScope searchScope = queryParameters.getEffectiveSearchScope();
                    if (searchScope.contains(virtualFile)) {
                        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                            public void visitXmlAttributeValue(XmlAttributeValue value) {
                                XmlAttribute attribute;
                                PsiElement parent;
                                PsiElement resolve;
                                PsiReference reference = value.getReference();
                                if (reference != null && (resolve = reference.resolve()) instanceof XmlAttributeValue && (parent = resolve.getParent()) instanceof XmlAttribute && "fx:id".equals((attribute = (XmlAttribute)parent).getName()) && fieldName.equals(attribute.getValue())) {
                                    consumer.process((Object)reference);
                                }
                            }
                        });
                    }
                });
            }
        }
        return true;
    }

    private static /* synthetic */ PsiClass lambda$execute$0(PsiField field) throws RuntimeException {
        return field.getContainingClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerFieldSearcher";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

