/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.renderers;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class ColorRenderer
extends ColoredListCellRenderer
implements PropertyRenderer<ColorDescriptor> {
    private ColorDescriptor myColorDescriptor;

    public ColorRenderer() {
        this.setOpaque(true);
    }

    @Override
    public JComponent getComponent(RadRootContainer rootContainer, ColorDescriptor value, boolean selected, boolean hasFocus) {
        this.prepareComponent(value, selected);
        return this;
    }

    private void prepareComponent(ColorDescriptor value, boolean selected) {
        this.myColorDescriptor = value;
        this.clear();
        this.setIcon(AllIcons.Nodes.EmptyNode);
        this.setBackground(selected ? UIUtil.getTableSelectionBackground((boolean)true) : UIUtil.getTableBackground());
        if (this.myColorDescriptor != null) {
            this.append(this.myColorDescriptor.toString(), selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myColorDescriptor != null) {
            int size = this.getBounds().height;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size + this.getIconTextGap() + 1, size);
            g.setColor(this.myColorDescriptor.getResolvedColor());
            g.fillRect(2, 2, size - 4, size - 4);
            g.setColor(Color.BLACK);
            g.drawRect(2, 2, size - 4, size - 4);
        }
    }

    protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (list == null) {
            ColorRenderer.$$$reportNull$$$0(0);
        }
        this.prepareComponent((ColorDescriptor)value, selected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/uiDesigner/propertyInspector/renderers/ColorRenderer", "customizeCellRenderer"));
    }
}

