/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.projectView.Form;
import com.intellij.uiDesigner.projectView.FormNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FormMergerTreeStructureProvider
implements TreeStructureProvider {
    private final Project myProject;

    public FormMergerTreeStructureProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        ProjectViewNode[] copy;
        if (parent == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (parent.getValue() instanceof Form) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                FormMergerTreeStructureProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        boolean formsFound = false;
        for (AbstractTreeNode<?> node : children) {
            PsiFile file;
            if (!(node.getValue() instanceof PsiFile) || (file = (PsiFile)node.getValue()).getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
            formsFound = true;
            break;
        }
        if (!formsFound) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                FormMergerTreeStructureProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }
        LinkedHashSet<AbstractTreeNode<BasePsiNode<? extends PsiElement>>> result = new LinkedHashSet<AbstractTreeNode<BasePsiNode<? extends PsiElement>>>(children);
        for (ProjectViewNode element : copy = children.toArray(new ProjectViewNode[0])) {
            List<PsiFile> forms;
            Collection<BasePsiNode<? extends PsiElement>> formNodes;
            String qName;
            PsiClass[] psiClasses;
            PsiClass psiClass = null;
            if (element.getValue() instanceof PsiClass) {
                psiClass = (PsiClass)element.getValue();
            } else if (element.getValue() instanceof PsiClassOwner && (psiClasses = ((PsiClassOwner)element.getValue()).getClasses()).length == 1) {
                psiClass = psiClasses[0];
            }
            if (psiClass == null || (qName = psiClass.getQualifiedName()) == null || (formNodes = FormMergerTreeStructureProvider.findFormsIn(children, forms = FormClassIndex.findFormsBoundToClass(this.myProject, qName))).isEmpty()) continue;
            Collection<PsiFile> formFiles = FormMergerTreeStructureProvider.convertToFiles(formNodes);
            ArrayList<BasePsiNode<? extends PsiElement>> subNodes = new ArrayList<BasePsiNode<? extends PsiElement>>();
            subNodes.add((BasePsiNode)element);
            subNodes.addAll(formNodes);
            result.add((AbstractTreeNode<BasePsiNode<? extends PsiElement>>)new FormNode(this.myProject, new Form(psiClass, formFiles), settings, subNodes));
            result.remove(element);
            result.removeAll(formNodes);
        }
        LinkedHashSet<AbstractTreeNode<BasePsiNode<? extends PsiElement>>> linkedHashSet = result;
        if (linkedHashSet == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    public Object getData(@NotNull Collection<AbstractTreeNode<?>> selected, @NotNull String dataId) {
        if (selected == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(5);
        }
        if (dataId == null) {
            FormMergerTreeStructureProvider.$$$reportNull$$$0(6);
        }
        if (Form.DATA_KEY.is(dataId)) {
            ArrayList<Form> result = new ArrayList<Form>();
            for (AbstractTreeNode<?> node : selected) {
                if (!(node.getValue() instanceof Form)) continue;
                result.add((Form)node.getValue());
            }
            if (!result.isEmpty()) {
                return result.toArray(new Form[0]);
            }
        } else if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            for (AbstractTreeNode<?> node : selected) {
                if (!(node.getValue() instanceof Form)) continue;
                return new MyDeleteProvider(selected);
            }
        }
        return null;
    }

    private static Collection<PsiFile> convertToFiles(Collection<BasePsiNode<? extends PsiElement>> formNodes) {
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (AbstractTreeNode abstractTreeNode : formNodes) {
            psiFiles.add((PsiFile)abstractTreeNode.getValue());
        }
        return psiFiles;
    }

    private static Collection<BasePsiNode<? extends PsiElement>> findFormsIn(Collection<AbstractTreeNode<?>> children, List<PsiFile> forms) {
        if (children.isEmpty() || forms.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BasePsiNode<? extends PsiElement>> result = new ArrayList<BasePsiNode<? extends PsiElement>>();
        HashSet<PsiFile> psiFiles = new HashSet<PsiFile>(forms);
        for (AbstractTreeNode<?> child : children) {
            BasePsiNode treeNode;
            if (!(child instanceof BasePsiNode) || !psiFiles.contains((treeNode = (BasePsiNode)child).getValue())) continue;
            result.add((BasePsiNode<? extends PsiElement>)treeNode);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/projectView/FormMergerTreeStructureProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/projectView/FormMergerTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDeleteProvider
    implements DeleteProvider {
        private final PsiElement[] myElements;

        MyDeleteProvider(Collection<AbstractTreeNode<?>> selected) {
            this.myElements = MyDeleteProvider.collectFormPsiElements(selected);
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteProvider.$$$reportNull$$$0(0);
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            DeleteHandler.deletePsiElement((PsiElement[])this.myElements, (Project)project);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeleteProvider.$$$reportNull$$$0(1);
            }
            return DeleteHandler.shouldEnableDeleteAction((PsiElement[])this.myElements);
        }

        private static PsiElement[] collectFormPsiElements(Collection<AbstractTreeNode<?>> selected) {
            HashSet<Object> result = new HashSet<Object>();
            for (AbstractTreeNode<?> node : selected) {
                if (node.getValue() instanceof Form) {
                    Form form = (Form)node.getValue();
                    result.add(form.getClassToBind());
                    ContainerUtil.addAll(result, (Object[])form.getFormFiles());
                    continue;
                }
                if (!(node.getValue() instanceof PsiElement)) continue;
                result.add((PsiElement)node.getValue());
            }
            return PsiUtilCore.toPsiElementArray(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/uiDesigner/projectView/FormMergerTreeStructureProvider$MyDeleteProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

