/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uiDesigner.binding.FormClassIndex;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class Form
implements Navigatable {
    public static final DataKey<Form[]> DATA_KEY = DataKey.create((String)"form.array");
    private final Collection<PsiFile> myFormFiles;
    @NotNull
    private final PsiClass myClassToBind;

    public Form(@NotNull PsiClass classToBind) {
        if (classToBind == null) {
            Form.$$$reportNull$$$0(0);
        }
        this.myClassToBind = classToBind;
        this.myFormFiles = FormClassIndex.findFormsBoundToClass(classToBind.getProject(), classToBind);
    }

    public Form(@NotNull PsiClass classToBind, Collection<? extends PsiFile> formFiles) {
        if (classToBind == null) {
            Form.$$$reportNull$$$0(1);
        }
        this.myClassToBind = classToBind;
        this.myFormFiles = new HashSet<PsiFile>(formFiles);
    }

    public boolean equals(Object object) {
        if (object instanceof Form) {
            Form form = (Form)object;
            return this.myFormFiles.equals(form.myFormFiles) && this.myClassToBind.equals(form.myClassToBind);
        }
        return false;
    }

    public int hashCode() {
        return this.myFormFiles.hashCode() ^ this.myClassToBind.hashCode();
    }

    public String getName() {
        return this.myClassToBind.getName();
    }

    @NotNull
    public PsiClass getClassToBind() {
        PsiClass psiClass = this.myClassToBind;
        if (psiClass == null) {
            Form.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    public PsiFile[] getFormFiles() {
        return PsiUtilCore.toPsiFileArray(this.myFormFiles);
    }

    public void navigate(boolean requestFocus) {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigate()) continue;
            psiFile.navigate(requestFocus);
        }
    }

    public boolean canNavigateToSource() {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigateToSource()) continue;
            return true;
        }
        return false;
    }

    public boolean canNavigate() {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigate()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        if (this.myFormFiles.size() == 0) {
            return false;
        }
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile.isValid()) continue;
            return false;
        }
        return this.myClassToBind.isValid();
    }

    public boolean containsFile(VirtualFile vFile) {
        VirtualFile classVFile;
        PsiFile classFile = this.myClassToBind.getContainingFile();
        VirtualFile virtualFile = classVFile = classFile == null ? null : classFile.getVirtualFile();
        if (classVFile != null && classVFile.equals(vFile)) {
            return true;
        }
        for (PsiFile psiFile : this.myFormFiles) {
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null || !virtualFile2.equals(vFile)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToBind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/projectView/Form";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/projectView/Form";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassToBind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

