/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.jlanguage;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.broker.GrazieDynamicClassBroker;
import com.intellij.grazie.jlanguage.broker.GrazieDynamicDataBroker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.language.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.UppercaseMatchFilter;
import org.languagetool.tools.classbroker.ClassBroker;
import org.languagetool.tools.databroker.ResourceDataBroker;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0005J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\n2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0015H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\rj\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/grazie/jlanguage/LangTool;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "()V", "allRules", "", "", "getAllRules", "()Ljava/util/Set;", "langs", "", "Lcom/intellij/grazie/jlanguage/Lang;", "Lorg/languagetool/JLanguageTool;", "rulesToLanguages", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getRuleLanguages", "ruleId", "getTool", "lang", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "init", "", "update", "prevState", "newState", "intellij.grazie"})
public final class LangTool
implements GrazieStateLifecycle {
    private static final Map<Lang, JLanguageTool> langs;
    private static final HashMap<String, Set<Lang>> rulesToLanguages;
    public static final LangTool INSTANCE;

    @NotNull
    public final Set<String> getAllRules() {
        Set<String> set = rulesToLanguages.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"rulesToLanguages.keys");
        return set;
    }

    @NotNull
    public final JLanguageTool getTool(@NotNull Lang lang, @NotNull GrazieConfig.State state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)lang), (String)"lang");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        boolean bl = lang.getJLanguage() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Trying to get LangTool for not available language";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        JLanguageTool jLanguageTool = langs.computeIfAbsent(lang, new Function<Lang, JLanguageTool>(lang, state){
            final /* synthetic */ Lang $lang;
            final /* synthetic */ GrazieConfig.State $state;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final JLanguageTool apply(@NotNull Lang it) {
                String id;
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                Language language = this.$lang.getJLanguage();
                if (language == null) {
                    Intrinsics.throwNpe();
                }
                JLanguageTool jLanguageTool = new JLanguageTool(language);
                boolean bl = false;
                boolean bl2 = false;
                JLanguageTool $this$apply = jLanguageTool;
                boolean bl3 = false;
                $this$apply.addMatchFilter((RuleMatchFilter)new UppercaseMatchFilter());
                Iterable $this$forEach$iv = this.$state.getUserDisabledRules();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    id = (String)element$iv;
                    boolean bl4 = false;
                    $this$apply.disableRule(id);
                }
                $this$forEach$iv = this.$state.getUserEnabledRules();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    id = (String)element$iv;
                    boolean bl5 = false;
                    $this$apply.enableRule(id);
                }
                Iterable $this$distinctBy$iv = $this$apply.getAllRules();
                boolean $i$f$distinctBy = false;
                HashSet<String> set$iv = new HashSet<String>();
                ArrayList<T> list$iv = new ArrayList<T>();
                for (T e$iv : $this$distinctBy$iv) {
                    Rule it2 = (Rule)e$iv;
                    boolean bl6 = false;
                    String key$iv = it2.getId();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                Iterable $this$onEach$iv = list$iv;
                boolean $i$f$onEach = false;
                Iterable iterable = $this$onEach$iv;
                boolean bl7 = false;
                boolean bl8 = false;
                Object $this$apply$iv = iterable;
                boolean bl9 = false;
                Iterator<T> iterator = $this$apply$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String key$iv;
                    void $this$getOrPut$iv;
                    T element$iv = iterator.next();
                    Rule rule = (Rule)element$iv;
                    boolean bl10 = false;
                    Map map = LangTool.access$getRulesToLanguages$p(LangTool.INSTANCE);
                    Intrinsics.checkExpressionValueIsNotNull((Object)rule.getId(), (String)"rule.id");
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl11 = false;
                        HashSet<E> answer$iv = new HashSet<E>();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(this.$lang);
                }
                return jLanguageTool;
            }
            {
                this.$lang = lang;
                this.$state = state;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jLanguageTool, (String)"langs.computeIfAbsent(la\u2026)\n        }\n      }\n    }");
        return jLanguageTool;
    }

    public static /* synthetic */ JLanguageTool getTool$default(LangTool langTool, Lang lang, GrazieConfig.State state, int n, Object object) {
        if ((n & 2) != 0) {
            state = GrazieConfig.Companion.get();
        }
        return langTool.getTool(lang, state);
    }

    @Override
    public void init(@NotNull GrazieConfig.State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Iterable $this$forEach$iv = state.getAvailableLanguages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Lang it = (Lang)((Object)element$iv);
            boolean bl = false;
            INSTANCE.getTool(it, state);
        }
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkParameterIsNotNull((Object)prevState, (String)"prevState");
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        if (Intrinsics.areEqual(prevState.getAvailableLanguages(), newState.getAvailableLanguages()) && Intrinsics.areEqual(prevState.getUserDisabledRules(), newState.getUserDisabledRules()) && Intrinsics.areEqual(prevState.getUserEnabledRules(), newState.getUserEnabledRules())) {
            return;
        }
        langs.clear();
        rulesToLanguages.clear();
        this.init(newState);
    }

    @Nullable
    public final Set<Lang> getRuleLanguages(@NotNull String ruleId) {
        Intrinsics.checkParameterIsNotNull((Object)ruleId, (String)"ruleId");
        return rulesToLanguages.get(ruleId);
    }

    private LangTool() {
    }

    static {
        LangTool langTool;
        INSTANCE = langTool = new LangTool();
        langs = new ConcurrentHashMap();
        rulesToLanguages = new HashMap();
        JLanguageTool.Companion.setDataBroker((ResourceDataBroker)GrazieDynamicDataBroker.INSTANCE);
        JLanguageTool.Companion.setClassBroker((ClassBroker)GrazieDynamicClassBroker.INSTANCE);
    }

    public static final /* synthetic */ HashMap access$getRulesToLanguages$p(LangTool $this) {
        LangTool langTool = $this;
        return rulesToLanguages;
    }
}

