/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sh.ShTypes;
import com.intellij.sh.highlighter.ShHighlighterColors;
import com.intellij.sh.psi.ShAssignmentCommand;
import com.intellij.sh.psi.ShFunctionDefinition;
import com.intellij.sh.psi.ShGenericCommandDirective;
import com.intellij.sh.psi.ShLiteral;
import com.intellij.sh.psi.ShShellParameterExpansion;
import com.intellij.sh.psi.ShSimpleCommandElement;
import com.intellij.sh.psi.ShSubshellCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement o, @NotNull AnnotationHolder holder) {
        IElementType elementType;
        if (o == null) {
            ShAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ShAnnotator.$$$reportNull$$$0(1);
        }
        if (o instanceof ShGenericCommandDirective) {
            ShAnnotator.mark(o, holder, ShHighlighterColors.GENERIC_COMMAND);
        } else if (o instanceof ShAssignmentCommand) {
            ShLiteral literal = ((ShAssignmentCommand)o).getLiteral();
            ShAnnotator.mark(literal, holder, ShHighlighterColors.VARIABLE_DECLARATION);
        } else if (o instanceof ShShellParameterExpansion) {
            ASTNode[] children;
            for (ASTNode node : children = o.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{ShTypes.PARAMETER_EXPANSION_BODY}))) {
                ShAnnotator.mark(node.getPsi(), holder, ShHighlighterColors.COMPOSED_VARIABLE);
            }
        } else if (o instanceof ShSubshellCommand) {
            ShSubshellCommand subshellCommand = (ShSubshellCommand)o;
            ShAnnotator.mark(subshellCommand.getLeftParen(), holder, ShHighlighterColors.SUBSHELL_COMMAND);
            ShAnnotator.mark(subshellCommand.getRightParen(), holder, ShHighlighterColors.SUBSHELL_COMMAND);
        }
        ASTNode node = o.getNode();
        IElementType iElementType = elementType = node == null ? null : node.getElementType();
        if (elementType == ShTypes.WORD) {
            PsiElement parent = o.getParent();
            if (parent instanceof ShSimpleCommandElement) {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
            }
            if (parent instanceof ShFunctionDefinition) {
                ShAnnotator.mark(o, holder, ShHighlighterColors.FUNCTION_DECLARATION);
            }
        }
    }

    private static void mark(@Nullable PsiElement o, @NotNull AnnotationHolder holder, @NotNull TextAttributesKey key) {
        if (holder == null) {
            ShAnnotator.$$$reportNull$$$0(2);
        }
        if (key == null) {
            ShAnnotator.$$$reportNull$$$0(3);
        }
        if (o != null) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(o).textAttributes(key).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/ShAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mark";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

