/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.properties.psi.DefaultResourceBundleManager;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceBundleManager {
    private static final ExtensionPointName<ResourceBundleManager> RESOURCE_BUNDLE_MANAGER = ExtensionPointName.create((String)"com.intellij.java-i18n.resourceBundleManager");
    protected final Project myProject;

    protected ResourceBundleManager(Project project) {
        this.myProject = project;
    }

    @Nullable
    public abstract PsiClass getResourceBundle();

    public List<String> suggestPropertiesFiles(@NotNull Set<Module> contextModules) {
        if (contextModules == null) {
            ResourceBundleManager.$$$reportNull$$$0(0);
        }
        return I18nUtil.defaultSuggestPropertiesFiles((Project)this.myProject, contextModules);
    }

    @Nullable
    public I18nizedTextGenerator getI18nizedTextGenerator() {
        return null;
    }

    @Nullable
    @NonNls
    public abstract String getTemplateName();

    @Nullable
    @NonNls
    public abstract String getConcatenationTemplateName();

    public abstract boolean isActive(@NotNull PsiFile var1) throws ResourceBundleNotFoundException;

    public abstract boolean canShowJavaCodeInfo();

    @Nullable
    public static ResourceBundleManager getManager(@NotNull PsiFile context) throws ResourceBundleNotFoundException {
        if (context == null) {
            ResourceBundleManager.$$$reportNull$$$0(1);
        }
        return ResourceBundleManager.getManager(Collections.singletonList(context), context.getProject());
    }

    @Nullable
    public static ResourceBundleManager getManager(@NotNull Collection<PsiFile> contexts, @NotNull Project project) throws ResourceBundleNotFoundException {
        if (contexts == null) {
            ResourceBundleManager.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ResourceBundleManager.$$$reportNull$$$0(3);
        }
        ResourceBundleManager result = null;
        for (ResourceBundleManager manager : (ResourceBundleManager[])RESOURCE_BUNDLE_MANAGER.getExtensions((AreaInstance)project)) {
            if (!ResourceBundleManager.isActiveForAny(manager, contexts)) continue;
            if (result != null) {
                return null;
            }
            result = manager;
        }
        if (result != null) {
            return result;
        }
        DefaultResourceBundleManager manager = new DefaultResourceBundleManager(project);
        return ResourceBundleManager.isActiveForAny(manager, contexts) ? manager : null;
    }

    private static boolean isActiveForAny(ResourceBundleManager manager, Collection<PsiFile> contexts) throws ResourceBundleNotFoundException {
        for (PsiFile context : contexts) {
            if (!manager.isActive(context)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PropertyCreationHandler getPropertyCreationHandler() {
        return null;
    }

    @Nullable
    public String suggestPropertyKey(@NotNull String value) {
        if (value == null) {
            ResourceBundleManager.$$$reportNull$$$0(4);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/psi/ResourceBundleManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestPropertiesFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestPropertyKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ResourceBundleNotFoundException
    extends Exception {
        private final IntentionAction myFix;

        public ResourceBundleNotFoundException(String message, IntentionAction setupResourceBundle) {
            super(message);
            this.myFix = setupResourceBundle;
        }

        public IntentionAction getFix() {
            return this.myFix;
        }
    }
}

