/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.folding.EditPropertyValueAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;

public class PropertyFoldingBuilder
extends FoldingBuilderEx {
    private static final int FOLD_MAX_LENGTH = 50;
    private static final Key<IProperty> CACHE = Key.create((String)"i18n.property.cache");
    public static final IProperty NULL = new PropertyImpl((PropertyStub)new PropertyStubImpl(null, null), PropertiesElementTypes.PROPERTY);

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement element, final @NotNull Document document, boolean quick) {
        if (element == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiFile) || quick || !PropertyFoldingBuilder.isFoldingsOn()) {
            if (FoldingDescriptor.EMPTY == null) {
                PropertyFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY;
        }
        PsiFile file = (PsiFile)element;
        final ArrayList result = new ArrayList();
        boolean hasJsp = ContainerUtil.intersects(Arrays.asList(StdLanguages.JSP, StdLanguages.JSPX), (Collection)file.getViewProvider().getLanguages());
        file.accept((PsiElementVisitor)(hasJsp ? new JavaRecursiveElementWalkingVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                ProgressManager.checkCanceled();
                ULiteralExpression uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)expression, ULiteralExpression.class);
                if (uLiteralExpression != null) {
                    PropertyFoldingBuilder.checkLiteral(document, uLiteralExpression, result);
                }
            }
        } : new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                ULiteralExpression uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)element, ULiteralExpression.class);
                if (uLiteralExpression != null) {
                    PropertyFoldingBuilder.checkLiteral(document, uLiteralExpression, result);
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder$2", "visitElement"));
            }
        }));
        FoldingDescriptor[] foldingDescriptorArray = result.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(3);
        }
        return foldingDescriptorArray;
    }

    private static boolean isFoldingsOn() {
        return JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    private static void checkLiteral(Document document, ULiteralExpression expression, List<? super FoldingDescriptor> result) {
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return;
        }
        if (!PropertyFoldingBuilder.isI18nProperty(expression)) {
            return;
        }
        IProperty property = PropertyFoldingBuilder.getI18nProperty(expression);
        HashSet<IProperty> set = new HashSet<IProperty>();
        set.add((IProperty)(property != null ? property : PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        String msg = PropertyFoldingBuilder.formatI18nProperty(expression, property);
        UElement parent = expression.getUastParent();
        if (!msg.equals(UastLiteralUtils.getValueIfStringLiteral((UElement)expression)) && parent instanceof UCallExpression && ((UExpression)((UCallExpression)parent).getValueArguments().get(0)).getSourcePsi() == expression.getSourcePsi()) {
            UCallExpression expressions = (UCallExpression)parent;
            PsiElement callSourcePsi = expressions.getSourcePsi();
            if (callSourcePsi == null) {
                return;
            }
            int count = JavaI18nUtil.getPropertyValueParamsMaxCount((UExpression)expression);
            List args = expressions.getValueArguments();
            if (args.size() == 1 + count) {
                boolean ok = true;
                for (int i = 1; i < count + 1; ++i) {
                    Object value = ((UExpression)args.get(i)).evaluate();
                    if (value != null || args.get(i) instanceof UReferenceExpression) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    UExpression receiver = expressions.getReceiver();
                    PsiElement receiverSourcePsi = receiver != null ? receiver.getSourcePsi() : null;
                    PsiElement elementToFold = null;
                    if (receiverSourcePsi != null) {
                        elementToFold = PsiTreeUtil.findCommonParent((PsiElement)callSourcePsi, (PsiElement)receiverSourcePsi);
                    }
                    if (elementToFold == null) {
                        elementToFold = callSourcePsi;
                    }
                    result.add((FoldingDescriptor)new FoldingDescriptor(Objects.requireNonNull(elementToFold.getNode()), elementToFold.getTextRange(), null, PropertyFoldingBuilder.formatMethodCallExpression(expressions), Boolean.valueOf(PropertyFoldingBuilder.isFoldingsOn()), set));
                    if (property != null) {
                        EditPropertyValueAction.registerFoldedElement(elementToFold, document);
                    }
                    return;
                }
            }
        }
        result.add((FoldingDescriptor)new FoldingDescriptor(Objects.requireNonNull(sourcePsi.getNode()), sourcePsi.getTextRange(), null, PropertyFoldingBuilder.getI18nMessage(expression), Boolean.valueOf(PropertyFoldingBuilder.isFoldingsOn()), set));
        if (property != null) {
            EditPropertyValueAction.registerFoldedElement(sourcePsi, document);
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    private static String formatMethodCallExpression(@NotNull UCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(5);
        }
        String string = (String)PropertyFoldingBuilder.format((UCallExpression)methodCallExpression).first;
        if (string == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static Pair<String, List<Couple<Integer>>> format(@NotNull UCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(7);
        }
        List args = methodCallExpression.getValueArguments();
        PsiElement callSourcePsi = methodCallExpression.getSourcePsi();
        if (args.size() > 0 && args.get(0) instanceof ULiteralExpression && PropertyFoldingBuilder.isI18nProperty((ULiteralExpression)args.get(0))) {
            int count = JavaI18nUtil.getPropertyValueParamsMaxCount((UExpression)args.get(0));
            if (args.size() == 1 + count) {
                String text = PropertyFoldingBuilder.getI18nMessage((ULiteralExpression)args.get(0));
                ArrayList<Couple<Integer>> replacementPositions = new ArrayList<Couple<Integer>>();
                for (int i = 1; i < count + 1; ++i) {
                    Object value = ((UExpression)args.get(i)).evaluate();
                    if (value == null) {
                        if (args.get(i) instanceof UReferenceExpression) {
                            PsiElement sourcePsi = ((UExpression)args.get(i)).getSourcePsi();
                            value = "{" + (sourcePsi != null ? sourcePsi.getText() : "<error>") + "}";
                        } else {
                            text = null;
                            break;
                        }
                    }
                    text = PropertyFoldingBuilder.replacePlaceholder(text, "{" + (i - 1) + "}", value.toString(), replacementPositions);
                }
                if (text != null) {
                    Pair pair = Pair.create((Object)(text.length() > 50 ? text.substring(0, 47) + "...\"" : text), replacementPositions);
                    if (pair == null) {
                        PropertyFoldingBuilder.$$$reportNull$$$0(8);
                    }
                    return pair;
                }
            }
        }
        Pair pair = Pair.create((Object)(callSourcePsi != null ? callSourcePsi.getText() : "<error>"), null);
        if (pair == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static String replacePlaceholder(String text, String placeholder, String replacement, List<Couple<Integer>> replacementPositions) {
        int placeholderPos;
        int curPos = 0;
        while ((placeholderPos = text.indexOf(placeholder, curPos)) >= 0) {
            Couple<Integer> next;
            text = text.substring(0, placeholderPos) + replacement + text.substring(placeholderPos + placeholder.length());
            ListIterator<Couple<Integer>> it = replacementPositions.listIterator();
            int diff = 0;
            while (it.hasNext()) {
                next = it.next();
                if ((Integer)next.second > placeholderPos) {
                    it.previous();
                    break;
                }
                diff = (Integer)next.second - (Integer)next.first;
            }
            it.add((Couple<Integer>)Couple.of((Object)(placeholderPos - diff), (Object)placeholderPos));
            it.add((Couple<Integer>)Couple.of((Object)(placeholderPos - diff + placeholder.length()), (Object)(placeholderPos + replacement.length())));
            while (it.hasNext()) {
                next = it.next();
                it.set((Couple<Integer>)Couple.of((Object)next.first, (Object)((Integer)next.second + replacement.length() - placeholder.length())));
            }
            curPos = placeholderPos + replacement.length();
        }
        return text;
    }

    @NotNull
    private static String getI18nMessage(@NotNull ULiteralExpression literal) {
        IProperty property;
        if (literal == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(10);
        }
        return (property = PropertyFoldingBuilder.getI18nProperty(literal)) == null ? UastLiteralUtils.getValueIfStringLiteral((UElement)literal) : PropertyFoldingBuilder.formatI18nProperty(literal, property);
    }

    @Nullable
    public static IProperty getI18nProperty(@NotNull ULiteralExpression literal) {
        PsiElement sourcePsi;
        if (literal == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(11);
        }
        if ((sourcePsi = literal.getSourcePsi()) == null) {
            return null;
        }
        Property property = (Property)sourcePsi.getUserData(CACHE);
        if (property == NULL) {
            return null;
        }
        if (property != null && PropertyFoldingBuilder.isValid(property, literal)) {
            return property;
        }
        if (PropertyFoldingBuilder.isI18nProperty(literal)) {
            Iterable references = UastLiteralUtils.getInjectedReferences((ULiteralExpression)literal);
            for (PsiReference reference : references) {
                if (reference instanceof PsiPolyVariantReference) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        PsiElement element = result.getElement();
                        if (!(element instanceof IProperty)) continue;
                        IProperty p = (IProperty)element;
                        sourcePsi.putUserData(CACHE, (Object)p);
                        return p;
                    }
                    continue;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof IProperty)) continue;
                IProperty p = (IProperty)element;
                sourcePsi.putUserData(CACHE, (Object)p);
                return p;
            }
        }
        return null;
    }

    private static boolean isValid(Property property, ULiteralExpression literal) {
        if (literal == null || property == null || !property.isValid()) {
            return false;
        }
        Object result = literal.evaluate();
        if (!(result instanceof String)) {
            return false;
        }
        return StringUtil.unquoteString((String)((String)result)).equals(property.getKey());
    }

    @NotNull
    private static String formatI18nProperty(@NotNull ULiteralExpression literal, IProperty property) {
        if (literal == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(12);
        }
        Object evaluated = literal.evaluate();
        String string = property == null ? (evaluated != null ? evaluated.toString() : "null") : "\"" + property.getValue() + "\"";
        if (string == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(14);
        }
        return PropertyFoldingBuilder.isFoldingsOn();
    }

    public static boolean isI18nProperty(@NotNull PsiLiteralExpression expr) {
        ULiteralExpression uLiteralExpression;
        if (expr == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(15);
        }
        if ((uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)expr, ULiteralExpression.class)) == null) {
            return false;
        }
        return PropertyFoldingBuilder.isI18nProperty(uLiteralExpression);
    }

    public static boolean isI18nProperty(@NotNull ULiteralExpression expr) {
        if (expr == null) {
            PropertyFoldingBuilder.$$$reportNull$$$0(16);
        }
        if (!expr.isString()) {
            return false;
        }
        PsiElement sourcePsi = expr.getSourcePsi();
        if (sourcePsi == null) {
            return false;
        }
        IProperty property = (IProperty)sourcePsi.getUserData(CACHE);
        if (property == NULL) {
            return false;
        }
        if (property != null) {
            return true;
        }
        boolean isI18n = JavaI18nUtil.mustBePropertyKey((UExpression)expr, null);
        if (!isI18n) {
            sourcePsi.putUserData(CACHE, (Object)NULL);
        }
        return isI18n;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/folding/PropertyFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethodCallExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatI18nProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatMethodCallExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getI18nMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getI18nProperty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatI18nProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isI18nProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

