/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInspection.i18n.folding.EditPropertyValueAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.FoldingPopupManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditPropertyValueTooltipManager
implements EditorMouseListener,
CaretListener {
    private static final Key<Boolean> INITIALIZED = Key.create((String)"PropertyEditTooltipManager");
    private static final long TOOLTIP_DELAY_MS = 500L;
    private final Alarm myAlarm;

    public static void initializeForDocument(@NotNull Document document) {
        if (document == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(0);
        }
        for (Editor editor : EditorFactory.getInstance().getEditors(document)) {
            EditPropertyValueTooltipManager.initializeForEditor(editor);
        }
    }

    private static void initializeForEditor(@NotNull Editor editor) {
        if (editor == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(1);
        }
        if (editor.getUserData(INITIALIZED) != null) {
            return;
        }
        editor.putUserData(INITIALIZED, (Object)Boolean.TRUE);
        new EditPropertyValueTooltipManager(editor);
    }

    private EditPropertyValueTooltipManager(@NotNull Editor editor) {
        if (editor == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(2);
        }
        this.myAlarm = new Alarm();
        editor.getCaretModel().addCaretListener((CaretListener)this);
        editor.addEditorMouseListener((EditorMouseListener)this);
    }

    public void mouseReleased(@NotNull EditorMouseEvent event) {
        if (event == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(3);
        }
        Editor editor = event.getEditor();
        if (event.getArea() == EditorMouseEventArea.EDITING_AREA && EditPropertyValueTooltipManager.shouldShowTooltip(editor)) {
            event.consume();
            this.myAlarm.cancelAllRequests();
            EditPropertyValueTooltipManager.showTooltip(editor);
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        if (event == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(4);
        }
        this.myAlarm.cancelAllRequests();
        Editor editor = event.getEditor();
        if (EditPropertyValueTooltipManager.shouldShowTooltip(editor)) {
            this.myAlarm.addRequest(() -> EditPropertyValueTooltipManager.showTooltip(editor), 500L);
        }
    }

    private static boolean shouldShowTooltip(@NotNull Editor editor) {
        if (editor == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(5);
        }
        return EditPropertyValueAction.isEnabled(editor);
    }

    private static void showTooltip(final @NotNull Editor editor) {
        String hintText;
        if (editor == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(6);
        }
        if ((hintText = StringUtil.join(Arrays.asList(EditPropertyValueTooltipManager.createActionText("ExpandRegion", "expand"), EditPropertyValueTooltipManager.createActionText("EditPropertyValue", "edit")), (String)"&nbsp;&nbsp;&nbsp;&nbsp;")).isEmpty()) {
            return;
        }
        JComponent component = HintUtil.createInformationLabel((String)("<html>" + hintText), (HyperlinkListener)new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                AnAction action;
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String actionId = null;
                switch (e.getDescription()) {
                    case "expand": {
                        actionId = "ExpandRegion";
                        break;
                    }
                    case "edit": {
                        actionId = "EditPropertyValue";
                    }
                }
                if (actionId != null && (action = ActionManager.getInstance().getAction(actionId)) != null) {
                    ActionUtil.invokeAction((AnAction)action, (Component)editor.getContentComponent(), (String)"unknown", (InputEvent)e.getInputEvent(), null);
                }
            }
        }, null, null);
        EditPropertyValueTooltipManager.showTooltip(editor, component, false);
    }

    @Nullable
    private static String createActionText(@NotNull String actionId, @NotNull String href) {
        AnAction action;
        if (actionId == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(7);
        }
        if (href == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(8);
        }
        if ((action = ActionManager.getInstance().getAction(actionId)) == null) {
            return null;
        }
        String text = action.getTemplateText();
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder().append("<a href='").append(href).append("'>").append(text).append("</a> <span style='color:#");
        UIUtil.appendColor((Color)UIUtil.getContextHelpForeground(), (StringBuilder)b);
        return b.append("'>").append(KeymapUtil.getFirstKeyboardShortcutText((AnAction)action)).append("</span>").toString();
    }

    public static LightweightHint showTooltip(@NotNull Editor editor, @NotNull JComponent component, boolean tenacious) {
        if (editor == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(9);
        }
        if (component == null) {
            EditPropertyValueTooltipManager.$$$reportNull$$$0(10);
        }
        if (editor.isDisposed()) {
            return null;
        }
        FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(editor.getCaretModel().getOffset());
        if (foldRegion == null) {
            return null;
        }
        JComponent editorComponent = editor.getContentComponent();
        JRootPane rootPane = editorComponent.getRootPane();
        if (rootPane == null) {
            return null;
        }
        Point start = editor.offsetToXY(foldRegion.getStartOffset(), true, false);
        Point end = editor.offsetToXY(foldRegion.getEndOffset(), false, true);
        Point relativePoint = new Point((start.x + end.x) / 2, start.y);
        Point point = SwingUtilities.convertPoint(editorComponent, relativePoint, rootPane.getLayeredPane());
        LightweightHint hint = new LightweightHint(component);
        HintHint hintHint = HintManagerImpl.createHintHint((Editor)editor, (Point)point, (LightweightHint)hint, (short)1).setShowImmediately(true);
        int flags = 40;
        if (tenacious) {
            hintHint.setExplicitClose(true);
        } else {
            flags |= 2;
        }
        FoldingPopupManager.disableForEditor((Editor)editor);
        hint.addHintListener(e -> FoldingPopupManager.enableForEditor((Editor)editor));
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, flags, 0, false, hintHint);
        return hint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "href";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/i18n/folding/EditPropertyValueTooltipManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeForDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeForEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseReleased";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "caretPositionChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldShowTooltip";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showTooltip";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createActionText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

