/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownSplitEditorProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownUtil;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public class MarkdownPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    private static final long PARSING_CALL_TIMEOUT_MS = 50L;
    private static final long RENDERING_DELAY_MS = 20L;
    static final NotNullLazyValue<PolicyFactory> SANITIZER_VALUE = new NotNullLazyValue<PolicyFactory>(){

        @NotNull
        protected PolicyFactory compute() {
            PolicyFactory policyFactory = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"file", "http", "https"}).allowElements(new String[]{"img"}).allowAttributes(new String[]{"alt", "src", "title"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "height", "width"}).onElements(new String[]{"img"}).toFactory()).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"http", "https"}).allowElements(new String[]{"input"}).allowAttributes(new String[]{"type", "class", "checked", "disabled"}).onElements(new String[]{"input"}).toFactory()).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"http", "https"}).allowElements(new String[]{"li"}).allowAttributes(new String[]{"class"}).onElements(new String[]{"li"}).toFactory()).and(new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"file", "http", "https", "mailto"}).allowElements(new String[]{"a"}).allowAttributes(new String[]{"href", "title"}).onElements(new String[]{"a"}).toFactory()).and(Sanitizers.TABLES).and(new HtmlPolicyBuilder().allowElements(new String[]{"body", "pre", "hr", "code", "tr", "span"}).allowAttributes(new String[]{HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME()}).globally().allowAttributes(new String[]{"class"}).onElements(new String[]{"code", "tr", "span"}).toFactory());
            if (policyFactory == null) {
                1.$$$reportNull$$$0(0);
            }
            return policyFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$1", "compute"));
        }
    };
    @NotNull
    private final JPanel myHtmlPanelWrapper;
    @Nullable
    private MarkdownHtmlPanel myPanel;
    @Nullable
    private MarkdownHtmlPanelProvider.ProviderInfo myLastPanelProviderInfo;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Document myDocument;
    @NotNull
    private final Alarm myPooledAlarm;
    @NotNull
    private final Alarm mySwingAlarm;
    private final Object REQUESTS_LOCK;
    @Nullable
    private Runnable myLastScrollRequest;
    @Nullable
    private Runnable myLastHtmlOrRefreshRequest;
    private volatile int myLastScrollOffset;
    @NotNull
    private String myLastRenderedHtml;

    public MarkdownPreviewFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(1);
        }
        this.myLastPanelProviderInfo = null;
        this.myPooledAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySwingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.REQUESTS_LOCK = new Object();
        this.myLastScrollRequest = null;
        this.myLastHtmlOrRefreshRequest = null;
        this.myLastRenderedHtml = "";
        this.myProject = project;
        this.myFile = file;
        this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        if (this.myDocument != null) {
            this.myDocument.addDocumentListener(new DocumentListener(){

                public void beforeDocumentChange(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MarkdownPreviewFileEditor.this.myPooledAlarm.cancelAllRequests();
                }

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    MarkdownPreviewFileEditor.this.myPooledAlarm.addRequest(() -> MarkdownPreviewFileEditor.this.updateHtml(true), 50L);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeDocumentChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "documentChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this);
        }
        this.myHtmlPanelWrapper = new JPanel(new BorderLayout());
        this.myHtmlPanelWrapper.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                    if (MarkdownPreviewFileEditor.this.myPanel != null) {
                        return;
                    }
                    MarkdownPreviewFileEditor.this.attachHtmlPanel();
                }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                    if (MarkdownPreviewFileEditor.this.myPanel == null) {
                        return;
                    }
                    MarkdownPreviewFileEditor.this.detachHtmlPanel();
                }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
            }
        });
        if (MarkdownPreviewFileEditor.isPreviewShown(project, file)) {
            this.attachHtmlPanel();
        }
        MessageBusConnection settingsConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        MyUpdatePanelOnSettingsChangedListener settingsChangedListener = new MyUpdatePanelOnSettingsChangedListener();
        settingsConnection.subscribe(MarkdownApplicationSettings.SettingsChangedListener.TOPIC, (Object)settingsChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToSrcOffset(int offset) {
        if (this.myPanel == null) {
            return;
        }
        if (!this.myPooledAlarm.isEmpty()) {
            this.myLastScrollOffset = offset;
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastScrollRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastScrollRequest);
            }
            this.myLastScrollRequest = () -> {
                if (this.myPanel == null) {
                    return;
                }
                this.myLastScrollOffset = offset;
                this.myPanel.scrollToMarkdownSrcOffset(this.myLastScrollOffset);
                Object object = this.REQUESTS_LOCK;
                synchronized (object) {
                    this.myLastScrollRequest = null;
                }
            };
            this.mySwingAlarm.addRequest(this.myLastScrollRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myHtmlPanelWrapper;
        if (jPanel == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myPanel == null) {
            return null;
        }
        return this.myPanel.getComponent();
    }

    @NotNull
    public String getName() {
        return "Markdown HTML Preview";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (this.myPanel == null) {
            return;
        }
        this.updateHtmlPooled();
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        if (this.myPanel == null) {
            return;
        }
        Disposer.dispose((Disposable)this.myPanel);
    }

    @NotNull
    private MarkdownHtmlPanelProvider retrievePanelProvider(@NotNull MarkdownApplicationSettings settings) {
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo;
        MarkdownHtmlPanelProvider provider;
        if (settings == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(6);
        }
        if ((provider = MarkdownHtmlPanelProvider.createFromInfo(providerInfo = settings.getMarkdownPreviewSettings().getHtmlPanelProviderInfo())).isAvailable() != MarkdownHtmlPanelProvider.AvailabilityInfo.AVAILABLE) {
            settings.setMarkdownPreviewSettings(new MarkdownPreviewSettings(settings.getMarkdownPreviewSettings().getSplitEditorLayout(), MarkdownPreviewSettings.DEFAULT.getHtmlPanelProviderInfo(), settings.getMarkdownPreviewSettings().isUseGrayscaleRendering(), settings.getMarkdownPreviewSettings().isAutoScrollPreview(), settings.getMarkdownPreviewSettings().isVerticalSplit()));
            Messages.showMessageDialog((Component)this.myHtmlPanelWrapper, (String)("Tried to use preview panel provider (" + providerInfo.getName() + "), but it is unavailable. Reverting to default."), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            provider = MarkdownHtmlPanelProvider.getProviders()[0];
        }
        this.myLastPanelProviderInfo = settings.getMarkdownPreviewSettings().getHtmlPanelProviderInfo();
        MarkdownHtmlPanelProvider markdownHtmlPanelProvider = provider;
        if (markdownHtmlPanelProvider == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(7);
        }
        return markdownHtmlPanelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtml(boolean preserveScrollOffset) {
        if (this.myPanel == null) {
            return;
        }
        if (!this.myFile.isValid() || this.myDocument == null || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        String html = MarkdownUtil.INSTANCE.generateMarkdownHtml(this.myFile, this.myDocument.getText(), this.myProject);
        if (!this.myFile.isValid() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        Object object = this.REQUESTS_LOCK;
        synchronized (object) {
            if (this.myLastHtmlOrRefreshRequest != null) {
                this.mySwingAlarm.cancelRequest(this.myLastHtmlOrRefreshRequest);
            }
            this.myLastHtmlOrRefreshRequest = () -> {
                if (this.myPanel == null) {
                    return;
                }
                String currentHtml = "<html><head></head>" + ((PolicyFactory)SANITIZER_VALUE.getValue()).sanitize(html) + "</html>";
                if (!currentHtml.equals(this.myLastRenderedHtml)) {
                    this.myLastRenderedHtml = currentHtml;
                    this.myPanel.setHtml(this.myLastRenderedHtml);
                    if (preserveScrollOffset) {
                        this.scrollToSrcOffset(this.myLastScrollOffset);
                    }
                }
                this.myPanel.render();
                Object object = this.REQUESTS_LOCK;
                synchronized (object) {
                    this.myLastHtmlOrRefreshRequest = null;
                }
            };
            this.mySwingAlarm.addRequest(this.myLastHtmlOrRefreshRequest, 20L, ModalityState.stateForComponent((Component)this.getComponent()));
        }
    }

    private void detachHtmlPanel() {
        if (this.myPanel != null) {
            this.myHtmlPanelWrapper.remove(this.myPanel.getComponent());
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
    }

    private void attachHtmlPanel() {
        MarkdownApplicationSettings settings = MarkdownApplicationSettings.getInstance();
        this.myPanel = this.retrievePanelProvider(settings).createHtmlPanel();
        this.myHtmlPanelWrapper.add((Component)this.myPanel.getComponent(), "Center");
        this.myHtmlPanelWrapper.repaint();
        MarkdownPreviewFileEditor.updatePanelCssSettings(this.myPanel, settings.getMarkdownCssSettings());
        this.myLastRenderedHtml = "";
        this.updateHtmlPooled();
    }

    private void updateHtmlPooled() {
        this.myPooledAlarm.cancelAllRequests();
        this.myPooledAlarm.addRequest(() -> this.updateHtml(true), 0);
    }

    private static void updatePanelCssSettings(@NotNull MarkdownHtmlPanel panel, @NotNull MarkdownCssSettings cssSettings) {
        if (panel == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(8);
        }
        if (cssSettings == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String inlineCss = cssSettings.isTextEnabled() ? cssSettings.getStylesheetText() : null;
        String customCssURI = cssSettings.isUriEnabled() ? cssSettings.getStylesheetUri() : MarkdownCssSettings.getDefaultCssSettings(StartupUiUtil.isUnderDarcula()).getStylesheetUri();
        panel.setCSS(inlineCss, customCssURI);
        panel.render();
    }

    private static boolean isPreviewShown(@NotNull Project project, @NotNull VirtualFile file) {
        MarkdownSplitEditorProvider provider;
        if (project == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(10);
        }
        if (file == null) {
            MarkdownPreviewFileEditor.$$$reportNull$$$0(11);
        }
        if ((provider = (MarkdownSplitEditorProvider)FileEditorProvider.EP_FILE_EDITOR_PROVIDER.findExtension(MarkdownSplitEditorProvider.class)) == null) {
            return true;
        }
        FileEditorState state = EditorHistoryManager.getInstance((Project)project).getState(file, (FileEditorProvider)provider);
        if (!(state instanceof SplitFileEditor.MyFileEditorState)) {
            return true;
        }
        return SplitFileEditor.SplitEditorLayout.valueOf(((SplitFileEditor.MyFileEditorState)state).getSplitLayout()) != SplitFileEditor.SplitEditorLayout.FIRST;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "retrievePanelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "retrievePanelProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updatePanelCssSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewShown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyUpdatePanelOnSettingsChangedListener
    implements MarkdownApplicationSettings.SettingsChangedListener {
        private MyUpdatePanelOnSettingsChangedListener() {
        }

        @Override
        public void settingsChanged(@NotNull MarkdownApplicationSettings settings) {
            if (settings == null) {
                MyUpdatePanelOnSettingsChangedListener.$$$reportNull$$$0(0);
            }
            MarkdownPreviewFileEditor.this.mySwingAlarm.addRequest(() -> {
                if (settings.getMarkdownPreviewSettings().getSplitEditorLayout() != SplitFileEditor.SplitEditorLayout.FIRST) {
                    if (MarkdownPreviewFileEditor.this.myPanel == null) {
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    } else if (MarkdownPreviewFileEditor.this.myLastPanelProviderInfo == null || MarkdownHtmlPanelProvider.createFromInfo(MarkdownPreviewFileEditor.this.myLastPanelProviderInfo).equals(MarkdownPreviewFileEditor.this.retrievePanelProvider(settings))) {
                        MarkdownPreviewFileEditor.this.detachHtmlPanel();
                        MarkdownPreviewFileEditor.this.attachHtmlPanel();
                    }
                    MarkdownPreviewFileEditor.this.myPanel.setHtml(MarkdownPreviewFileEditor.this.myLastRenderedHtml);
                    MarkdownPreviewFileEditor.updatePanelCssSettings(MarkdownPreviewFileEditor.this.myPanel, settings.getMarkdownCssSettings());
                }
            }, 0, ModalityState.stateForComponent((Component)MarkdownPreviewFileEditor.this.getComponent()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor$MyUpdatePanelOnSettingsChangedListener", "settingsChanged"));
        }
    }
}

