/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors;
import org.intellij.plugins.markdown.highlighting.MarkdownSyntaxHighlighter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRIBUTE_DESCRIPTORS = AttributeDescriptorsHolder.INSTANCE.get();

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        HashMap<String, TextAttributesKey> result = new HashMap<String, TextAttributesKey>();
        result.put("hh1", MarkdownHighlighterColors.HEADER_LEVEL_1_ATTR_KEY);
        result.put("hh2", MarkdownHighlighterColors.HEADER_LEVEL_2_ATTR_KEY);
        result.put("hh3", MarkdownHighlighterColors.HEADER_LEVEL_3_ATTR_KEY);
        result.put("hh4", MarkdownHighlighterColors.HEADER_LEVEL_4_ATTR_KEY);
        result.put("hh5", MarkdownHighlighterColors.HEADER_LEVEL_5_ATTR_KEY);
        result.put("hh6", MarkdownHighlighterColors.HEADER_LEVEL_6_ATTR_KEY);
        result.put("bold", MarkdownHighlighterColors.BOLD_ATTR_KEY);
        result.put("boldm", MarkdownHighlighterColors.BOLD_MARKER_ATTR_KEY);
        result.put("italic", MarkdownHighlighterColors.ITALIC_ATTR_KEY);
        result.put("italicm", MarkdownHighlighterColors.ITALIC_MARKER_ATTR_KEY);
        result.put("strike", MarkdownHighlighterColors.STRIKE_THROUGH_ATTR_KEY);
        result.put("alink", MarkdownHighlighterColors.AUTO_LINK_ATTR_KEY);
        result.put("link_def", MarkdownHighlighterColors.LINK_DEFINITION_ATTR_KEY);
        result.put("link_text", MarkdownHighlighterColors.LINK_TEXT_ATTR_KEY);
        result.put("link_label", MarkdownHighlighterColors.LINK_LABEL_ATTR_KEY);
        result.put("link_dest", MarkdownHighlighterColors.LINK_DESTINATION_ATTR_KEY);
        result.put("link_img", MarkdownHighlighterColors.IMAGE_ATTR_KEY);
        result.put("link_title", MarkdownHighlighterColors.LINK_TITLE_ATTR_KEY);
        result.put("code_span", MarkdownHighlighterColors.CODE_SPAN_ATTR_KEY);
        result.put("code_block", MarkdownHighlighterColors.CODE_BLOCK_ATTR_KEY);
        result.put("code_fence", MarkdownHighlighterColors.CODE_FENCE_ATTR_KEY);
        result.put("quote", MarkdownHighlighterColors.BLOCK_QUOTE_ATTR_KEY);
        result.put("ul", MarkdownHighlighterColors.UNORDERED_LIST_ATTR_KEY);
        result.put("ol", MarkdownHighlighterColors.ORDERED_LIST_ATTR_KEY);
        HashMap<String, TextAttributesKey> hashMap = result;
        if (hashMap == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRIBUTE_DESCRIPTORS == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(1);
        }
        return ATTRIBUTE_DESCRIPTORS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NonNls
    @NotNull
    public String getDemoText() {
        String string;
        InputStream stream = this.getClass().getResourceAsStream("SampleDocument.md");
        try {
            String result = StreamUtil.readText((InputStream)stream, (String)"UTF-8");
            stream.close();
            string = StringUtil.convertLineSeparators((String)result);
        }
        catch (IOException iOException) {
            return "*error loading text*";
        }
        if (string == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = MarkdownBundle.message("markdown.plugin.name", new Object[0]);
        if (string == null) {
            MarkdownColorSettingsPage.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new MarkdownSyntaxHighlighter();
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/markdown/highlighting/MarkdownColorSettingsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalHighlightingTagToDescriptorMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static enum AttributeDescriptorsHolder {
        INSTANCE;

        private final Map<String, TextAttributesKey> myMap = new HashMap<String, TextAttributesKey>();

        private AttributeDescriptorsHolder() {
            this.put("markdown.editor.colors.text", MarkdownHighlighterColors.TEXT_ATTR_KEY);
            this.put("markdown.editor.colors.bold", MarkdownHighlighterColors.BOLD_ATTR_KEY);
            this.put("markdown.editor.colors.bold_marker", MarkdownHighlighterColors.BOLD_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.italic", MarkdownHighlighterColors.ITALIC_ATTR_KEY);
            this.put("markdown.editor.colors.italic_marker", MarkdownHighlighterColors.ITALIC_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.strikethrough", MarkdownHighlighterColors.STRIKE_THROUGH_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_1", MarkdownHighlighterColors.HEADER_LEVEL_1_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_2", MarkdownHighlighterColors.HEADER_LEVEL_2_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_3", MarkdownHighlighterColors.HEADER_LEVEL_3_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_4", MarkdownHighlighterColors.HEADER_LEVEL_4_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_5", MarkdownHighlighterColors.HEADER_LEVEL_5_ATTR_KEY);
            this.put("markdown.editor.colors.header_level_6", MarkdownHighlighterColors.HEADER_LEVEL_6_ATTR_KEY);
            this.put("markdown.editor.colors.blockquote", MarkdownHighlighterColors.BLOCK_QUOTE_ATTR_KEY);
            this.put("markdown.editor.colors.code_span", MarkdownHighlighterColors.CODE_SPAN_ATTR_KEY);
            this.put("markdown.editor.colors.code_span_marker", MarkdownHighlighterColors.CODE_SPAN_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.code_block", MarkdownHighlighterColors.CODE_BLOCK_ATTR_KEY);
            this.put("markdown.editor.colors.code_fence", MarkdownHighlighterColors.CODE_FENCE_ATTR_KEY);
            this.put("markdown.editor.colors.hrule", MarkdownHighlighterColors.HRULE_ATTR_KEY);
            this.put("markdown.editor.colors.table_separator", MarkdownHighlighterColors.TABLE_SEPARATOR_ATTR_KEY);
            this.put("markdown.editor.colors.blockquote_marker", MarkdownHighlighterColors.BLOCK_QUOTE_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.list_marker", MarkdownHighlighterColors.LIST_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.header_marker", MarkdownHighlighterColors.HEADER_MARKER_ATTR_KEY);
            this.put("markdown.editor.colors.auto_link", MarkdownHighlighterColors.AUTO_LINK_ATTR_KEY);
            this.put("markdown.editor.colors.explicit_link", MarkdownHighlighterColors.EXPLICIT_LINK_ATTR_KEY);
            this.put("markdown.editor.colors.reference_link", MarkdownHighlighterColors.REFERENCE_LINK_ATTR_KEY);
            this.put("markdown.editor.colors.image", MarkdownHighlighterColors.IMAGE_ATTR_KEY);
            this.put("markdown.editor.colors.link_definition", MarkdownHighlighterColors.LINK_DEFINITION_ATTR_KEY);
            this.put("markdown.editor.colors.link_text", MarkdownHighlighterColors.LINK_TEXT_ATTR_KEY);
            this.put("markdown.editor.colors.link_label", MarkdownHighlighterColors.LINK_LABEL_ATTR_KEY);
            this.put("markdown.editor.colors.link_destination", MarkdownHighlighterColors.LINK_DESTINATION_ATTR_KEY);
            this.put("markdown.editor.colors.link_title", MarkdownHighlighterColors.LINK_TITLE_ATTR_KEY);
            this.put("markdown.editor.colors.unordered_list", MarkdownHighlighterColors.UNORDERED_LIST_ATTR_KEY);
            this.put("markdown.editor.colors.ordered_list", MarkdownHighlighterColors.ORDERED_LIST_ATTR_KEY);
            this.put("markdown.editor.colors.list_item", MarkdownHighlighterColors.LIST_ITEM_ATTR_KEY);
            this.put("markdown.editor.colors.html_block", MarkdownHighlighterColors.HTML_BLOCK_ATTR_KEY);
            this.put("markdown.editor.colors.inline_html", MarkdownHighlighterColors.INLINE_HTML_ATTR_KEY);
        }

        public AttributesDescriptor @NotNull [] get() {
            AttributesDescriptor[] result = new AttributesDescriptor[this.myMap.size()];
            int i = 0;
            for (Map.Entry<String, TextAttributesKey> entry : this.myMap.entrySet()) {
                result[i++] = new AttributesDescriptor(MarkdownBundle.message(entry.getKey(), new Object[0]), entry.getValue());
            }
            if (result == null) {
                AttributeDescriptorsHolder.$$$reportNull$$$0(0);
            }
            return result;
        }

        private void put(@NotNull String bundleKey, @NotNull TextAttributesKey attributes) {
            if (bundleKey == null) {
                AttributeDescriptorsHolder.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                AttributeDescriptorsHolder.$$$reportNull$$$0(2);
            }
            if (this.myMap.put(bundleKey, attributes) != null) {
                throw new IllegalArgumentException("Duplicated key: " + bundleKey);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/markdown/highlighting/MarkdownColorSettingsPage$AttributeDescriptorsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundleKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/markdown/highlighting/MarkdownColorSettingsPage$AttributeDescriptorsHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

