/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicator;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.ui.AppUIUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000b\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\f\u001a\u00020\u0003H\u0000\u001a+\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u001d0\u00012\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010!\"0\u0010\u0000\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00060\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"0\u0010\u0007\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\u0004j\b\u0012\u0004\u0012\u00020\t`\u00060\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"CHANGED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/LinkedHashMap;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Ljava/util/LinkedHashSet;", "Lcom/intellij/openapi/components/StateStorage;", "Lkotlin/collections/LinkedHashSet;", "CHANGED_SCHEMES_KEY", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeApplicator;", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "askToRestart", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "notReloadableComponents", "", "", "changedStorages", "", "isApp", "doReloadProject", "", "project", "Lcom/intellij/openapi/project/Project;", "reloadAppStore", "changes", "reloadStore", "Lcom/intellij/configurationStore/ReloadComponentStoreStatus;", "getAndClear", "T", "", "holder", "Lcom/intellij/openapi/util/UserDataHolderEx;", "(Lcom/intellij/openapi/util/Key;Lcom/intellij/openapi/util/UserDataHolderEx;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
public final class StoreReloadManagerImplKt {
    private static final Key<LinkedHashMap<ComponentStoreImpl, LinkedHashSet<StateStorage>>> CHANGED_FILES_KEY = new Key("CHANGED_FILES_KEY");
    private static final Key<LinkedHashMap<SchemeChangeApplicator, LinkedHashSet<SchemeChangeEvent>>> CHANGED_SCHEMES_KEY = new Key("CHANGED_SCHEMES_KEY");

    public static final boolean reloadAppStore(@NotNull Set<? extends StateStorage> changes) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application));
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ReloadComponentStoreStatus status = StoreReloadManagerImplKt.reloadStore(changes, (ComponentStoreImpl)iComponentStore);
        if (status == ReloadComponentStoreStatus.RESTART_AGREED) {
            ApplicationManagerEx.getApplicationEx().restart(true);
            return false;
        }
        return status == ReloadComponentStoreStatus.SUCCESS || status == ReloadComponentStoreStatus.RESTART_CANCELLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ReloadComponentStoreStatus reloadStore(@NotNull Set<? extends StateStorage> changedStorages, @NotNull ComponentStoreImpl store) {
        boolean willBeReloaded;
        Collection<String> notReloadableComponents;
        block11: {
            Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
            Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
            notReloadableComponents = null;
            willBeReloaded = false;
            try {
                notReloadableComponents = store.reload(changedStorages);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().warn(e);
                AppUIUtil.invokeOnEdt((Runnable)new Runnable(e){
                    final /* synthetic */ Throwable $e;

                    public final void run() {
                        Messages.showWarningDialog((String)ConfigurationStoreBundle.message("project.reload.failed", this.$e.getMessage()), (String)ConfigurationStoreBundle.message("project.reload.failed.title", new Object[0]));
                    }
                    {
                        this.$e = throwable;
                    }
                });
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
                return reloadComponentStoreStatus;
            }
            if (notReloadableComponents != null && !notReloadableComponents.isEmpty()) break block11;
            ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
            for (StateStorage stateStorage : changedStorages) {
                if (!(stateStorage instanceof StateStorageBase)) continue;
                ((StateStorageBase)stateStorage).enableSaving();
            }
            return reloadComponentStoreStatus;
        }
        try {
            willBeReloaded = StoreReloadManagerImplKt.askToRestart(store, notReloadableComponents, changedStorages, store.getProject() == null);
            ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
            return reloadComponentStoreStatus;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<String> notReloadableComponents, @Nullable Set<? extends StateStorage> changedStorages, boolean isApp) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project '" + ((IProjectStore)store).getProjectName() + '\'' : "Application";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (isApp) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            message.append(application.isRestartCapable() ? "restart" : "shutdown").append(' ');
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            message.append(applicationNamesInfo.getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) != 0) {
            return false;
        }
        if (changedStorages != null) {
            for (StateStorage stateStorage : changedStorages) {
                if (!(stateStorage instanceof StateStorageBase)) continue;
                ((StateStorageBase)stateStorage).disableSaving();
            }
        }
        return true;
    }

    private static final <T> T getAndClear(@NotNull Key<T> $this$getAndClear, UserDataHolderEx holder) {
        Object object = holder.getUserData($this$getAndClear);
        if (object == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"holder.getUserData(this) ?: return null");
        Object value = object;
        holder.replace($this$getAndClear, value, null);
        return (T)value;
    }

    private static final void doReloadProject(Project project) {
        Ref projectRef = Ref.create((Object)project);
        ProjectReloadState.getInstance((Project)project).onBeforeAutomaticProjectReload();
        AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(new Runnable(projectRef){
            final /* synthetic */ Ref $projectRef;

            public final void run() {
                ComponentStoreImplKt.getLOG().debug("Reloading project.");
                Project project1 = (Project)this.$projectRef.get();
                this.$projectRef.set(null);
                Project project = project1;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project1");
                if (project.isDisposed()) {
                    return;
                }
                String presentableUrl = project1.getPresentableUrl();
                if (!ProjectManagerEx.getInstanceEx().closeAndDispose(project1)) {
                    return;
                }
                ProjectUtil.openProject((String)Objects.requireNonNull(presentableUrl), null, (boolean)true);
            }
            {
                this.$projectRef = ref;
            }
        });
    }

    public static final /* synthetic */ Key access$getCHANGED_FILES_KEY$p() {
        return CHANGED_FILES_KEY;
    }

    public static final /* synthetic */ void access$doReloadProject(Project project) {
        StoreReloadManagerImplKt.doReloadProject(project);
    }

    public static final /* synthetic */ Key access$getCHANGED_SCHEMES_KEY$p() {
        return CHANGED_SCHEMES_KEY;
    }

    public static final /* synthetic */ Object access$getAndClear(Key $this$access_u24getAndClear, UserDataHolderEx holder) {
        return StoreReloadManagerImplKt.getAndClear($this$access_u24getAndClear, holder);
    }
}

