/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class Ksuid {
    private static final int EPOCH = 1400000000;
    private static final int TIMESTAMP_LENGTH = 4;
    private static final int PAYLOAD_LENGTH = 16;
    private static final int MAX_ENCODED_LENGTH = 27;
    private static final SecureRandom random = new SecureRandom();

    public static String generate() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        long utc = ZonedDateTime.now(ZoneOffset.UTC).toInstant().toEpochMilli() / 1000L;
        int timestamp = (int)(utc - 1400000000L);
        byteBuffer.putInt(timestamp);
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        byteBuffer.put(bytes);
        String uid = new String(Base62.encode(byteBuffer.array()), StandardCharsets.UTF_8);
        return uid.length() > 27 ? uid.substring(0, 27) : uid;
    }

    private static final class Base62 {
        private static final int STANDARD_BASE = 256;
        private static final int TARGET_BASE = 62;
        private static final byte[] lookup = new byte[256];
        private static final byte[] alphabet = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

        private Base62() {
        }

        public static byte[] encode(byte[] message) {
            byte[] indices = Base62.convert(message, 256, 62);
            return Base62.translate(indices, alphabet);
        }

        public byte[] decode(byte[] encoded) {
            byte[] prepared = Base62.translate(encoded, lookup);
            return Base62.convert(prepared, 62, 256);
        }

        private static byte[] translate(byte[] indices, byte[] dictionary) {
            byte[] translation = new byte[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                translation[i] = dictionary[indices[i]];
            }
            return translation;
        }

        private static byte[] convert(byte[] message, int sourceBase, int targetBase) {
            int estimatedLength = Base62.estimateOutputLength(message.length, sourceBase, targetBase);
            ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
            byte[] source = message;
            while (source.length > 0) {
                ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
                int remainder = 0;
                for (byte b : source) {
                    int accumulator = (b & 0xFF) + remainder * sourceBase;
                    int digit = (accumulator - accumulator % targetBase) / targetBase;
                    remainder = accumulator % targetBase;
                    if (quotient.size() <= 0 && digit <= 0) continue;
                    quotient.write(digit);
                }
                out.write(remainder);
                source = quotient.toByteArray();
            }
            for (int i = 0; i < message.length - 1 && message[i] == 0; ++i) {
                out.write(0);
            }
            return Base62.reverse(out.toByteArray());
        }

        private static int estimateOutputLength(int inputLength, int sourceBase, int targetBase) {
            return (int)Math.ceil(Math.log(sourceBase) / Math.log(targetBase) * (double)inputLength);
        }

        private static byte[] reverse(byte[] arr) {
            int length = arr.length;
            byte[] reversed = new byte[length];
            for (int i = 0; i < length; ++i) {
                reversed[length - i - 1] = arr[i];
            }
            return reversed;
        }

        static {
            for (int i = 0; i < alphabet.length; ++i) {
                Base62.lookup[Base62.alphabet[i]] = (byte)(i & 0xFF);
            }
        }
    }
}

