/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl.synch;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.impl.synch.ImplKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/impl/synch/SynchronizedTransformationAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.groovy.psi"})
public final class SynchronizedTransformationAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        if (element instanceof GrAnnotation && Intrinsics.areEqual((Object)((GrAnnotation)element).getQualifiedName(), (Object)"groovy.transform.Synchronized")) {
            PsiAnnotationOwner psiAnnotationOwner = ((GrAnnotation)element).getOwner();
            if (!(psiAnnotationOwner instanceof GrModifierList)) {
                psiAnnotationOwner = null;
            }
            GrModifierList grModifierList = (GrModifierList)psiAnnotationOwner;
            Object object = grModifierList != null ? grModifierList.getParent() : null;
            if (!(object instanceof GrMethod)) {
                object = null;
            }
            GrMethod grMethod = (GrMethod)object;
            if (grMethod == null) {
                return;
            }
            GrMethod method = grMethod;
            if (GrTraitUtil.isMethodAbstract(method)) {
                holder.newAnnotation(HighlightSeverity.ERROR, "@Synchronized not allowed on abstract method").range(element).create();
            }
        } else {
            ASTNode aSTNode = element.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)GroovyTokenTypes.mIDENT)) {
                PsiElement psiElement = element.getParent();
                if (!(psiElement instanceof GrField)) {
                    psiElement = null;
                }
                GrField grField = (GrField)psiElement;
                if (grField == null) {
                    return;
                }
                GrField field = grField;
                boolean staticField = ImplKt.isStatic((PsiModifierListOwner)field);
                if (!staticField) {
                    boolean hasStaticMethods;
                    block21: {
                        boolean bl;
                        Sequence<PsiMethod> $this$any$iv = ImplKt.getMethodsReferencingLock(field);
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            PsiMethod it = (PsiMethod)element$iv;
                            boolean bl2 = false;
                            if (!ImplKt.isStatic((PsiModifierListOwner)it)) continue;
                            bl = true;
                            break block21;
                        }
                        bl = hasStaticMethods = false;
                    }
                    if (hasStaticMethods) {
                        holder.newAnnotation(HighlightSeverity.ERROR, "Lock field '" + field.getName() + "' must be static").range(element).create();
                    }
                } else if (Intrinsics.areEqual((Object)field.getName(), (Object)"$lock")) {
                    boolean hasInstanceMethods;
                    block22: {
                        boolean bl;
                        Sequence<PsiMethod> $this$any$iv = ImplKt.getMethodsReferencingLock(field);
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            PsiMethod it = (PsiMethod)element$iv;
                            boolean bl3 = false;
                            if (!(!ImplKt.isStatic((PsiModifierListOwner)it))) continue;
                            bl = true;
                            break block22;
                        }
                        bl = hasInstanceMethods = false;
                    }
                    if (hasInstanceMethods) {
                        holder.newAnnotation(HighlightSeverity.ERROR, "Lock field '$lock' must not be static").range(element).create();
                    }
                }
            } else if (ImplKt.getPATTERN().accepts((Object)element)) {
                GrField field;
                GrLiteral cfr_ignored_0 = (GrLiteral)element;
                PsiReference psiReference = ((GrLiteral)element).getReference();
                if (psiReference == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"element.reference ?: return");
                PsiReference reference = psiReference;
                PsiElement psiElement = reference.resolve();
                if (!(psiElement instanceof GrField)) {
                    psiElement = null;
                }
                if ((field = (GrField)psiElement) == null) {
                    TextRange textRange = reference.getRangeInElement();
                    TextRange textRange2 = ((GrLiteral)element).getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"element.textRange");
                    TextRange textRange3 = textRange.shiftRight(textRange2.getStartOffset());
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange3, (String)"reference.rangeInElement\u2026nt.textRange.startOffset)");
                    TextRange range = textRange3;
                    holder.newAnnotation(HighlightSeverity.ERROR, "Lock field '" + ((GrLiteral)element).getValue() + "' not found").range(range).create();
                }
            }
        }
    }
}

