/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineGroovyFieldDialog;

public class GrInlineFieldUtil {
    private GrInlineFieldUtil() {
    }

    @Nullable
    static InlineHandler.Settings inlineFieldSettings(GrField field, Editor editor, boolean invokedOnReference) {
        Project project = field.getProject();
        if (!field.hasModifierProperty("final")) {
            String message = JavaRefactoringBundle.message((String)"0.refactoring.is.supported.only.for.final.fields", (Object[])new Object[]{GrInlineFieldUtil.getInlineField()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)GrInlineFieldUtil.getInlineField(), (String)"refactoring.inlineField");
            return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
        }
        if (field.getInitializerGroovy() == null) {
            String message = GroovyRefactoringBundle.message("cannot.find.a.single.definition.to.inline.field", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)GrInlineFieldUtil.getInlineField(), (String)"refactoring.inlineField");
            return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
        }
        return GrInlineFieldUtil.inlineFieldDialogResult(project, field, invokedOnReference);
    }

    private static InlineHandler.Settings inlineFieldDialogResult(Project project, GrField field, final boolean invokedOnReference) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new InlineHandler.Settings(){

                public boolean isOnlyOneReferenceToInline() {
                    return invokedOnReference;
                }
            };
        }
        final InlineGroovyFieldDialog dialog = new InlineGroovyFieldDialog(project, field, invokedOnReference);
        if (dialog.showAndGet()) {
            return new InlineHandler.Settings(){

                public boolean isOnlyOneReferenceToInline() {
                    return dialog.isInlineThisOnly();
                }
            };
        }
        return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
    }

    public static String getInlineField() {
        return JavaRefactoringBundle.message((String)"inline.field.title", (Object[])new Object[0]);
    }
}

