/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrInExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.readWrite.ReadBeforeWriteState;

public class ControlFlowBuilderUtil {
    private ControlFlowBuilderUtil() {
    }

    public static ReadWriteVariableInstruction[] getReadsWithoutPriorWrites(Instruction[] flow, boolean onlyFirstRead) {
        DFAEngine<ReadBeforeWriteState> engine = new DFAEngine<ReadBeforeWriteState>(flow, new ReadBeforeWriteInstance(ControlFlowBuilderUtil.buildVariablesIndex(flow), onlyFirstRead), ReadBeforeWriteSemilattice.INSTANCE);
        List<ReadBeforeWriteState> dfaResult = engine.performDFAWithTimeout();
        if (dfaResult == null) {
            return ReadWriteVariableInstruction.EMPTY_ARRAY;
        }
        ArrayList<ReadWriteVariableInstruction> result2 = new ArrayList<ReadWriteVariableInstruction>();
        BitSet reads = dfaResult.get(dfaResult.size() - 1).getReads();
        int i = reads.nextSetBit(0);
        while (i >= 0 && i != Integer.MAX_VALUE) {
            result2.add((ReadWriteVariableInstruction)flow[i]);
            i = reads.nextSetBit(i + 1);
        }
        return result2.toArray(ReadWriteVariableInstruction.EMPTY_ARRAY);
    }

    private static TObjectIntHashMap<VariableDescriptor> buildVariablesIndex(Instruction[] flow) {
        ObjectIntHashMap variablesIndex = new ObjectIntHashMap();
        int idx = 0;
        for (Instruction instruction : flow) {
            VariableDescriptor descriptor2;
            if (!(instruction instanceof ReadWriteVariableInstruction) || variablesIndex.contains((Object)(descriptor2 = ((ReadWriteVariableInstruction)instruction).getDescriptor()))) continue;
            variablesIndex.put((Object)descriptor2, idx++);
        }
        return variablesIndex;
    }

    public static boolean isInstanceOfBinary(GrBinaryExpression binary) {
        if (binary instanceof GrInExpression) {
            GrExpression left = binary.getLeftOperand();
            GrExpression right = binary.getRightOperand();
            if (left instanceof GrReferenceExpression && ((GrReferenceExpression)left).getQualifier() == null && right instanceof GrReferenceExpression && ControlFlowBuilderUtil.findClassByText((GrReferenceExpression)right)) {
                return true;
            }
        }
        return false;
    }

    private static boolean findClassByText(GrReferenceExpression ref) {
        String text = ref.getText();
        int i = text.indexOf(60);
        String className = i == -1 ? text : text.substring(0, i);
        PsiClass[] names = PsiShortNamesCache.getInstance((Project)ref.getProject()).getClassesByName(className, ref.getResolveScope());
        if (names.length > 0) {
            return true;
        }
        PsiFile file = ref.getContainingFile();
        if (file instanceof GroovyFile) {
            GrImportStatement[] imports2;
            for (GrImportStatement anImport : imports2 = ((GroovyFile)file).getImportStatements()) {
                if (!className.equals(anImport.getImportedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCertainlyReturnStatement(GrStatement st) {
        PsiElement parent2 = st.getParent();
        if (parent2 instanceof GrOpenBlock) {
            if (st != ArrayUtil.getLastElement((Object[])((GrOpenBlock)parent2).getStatements())) {
                return false;
            }
            PsiElement pparent = parent2.getParent();
            if (pparent instanceof GrMethod) {
                return true;
            }
            if (pparent instanceof GrBlockStatement || pparent instanceof GrCatchClause || pparent instanceof GrLabeledStatement) {
                pparent = pparent.getParent();
            }
            if (pparent instanceof GrControlStatement || pparent instanceof GrTryCatchStatement) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)pparent);
            }
        } else {
            if (parent2 instanceof GrClosableBlock || parent2 instanceof GrBlockLambdaBody) {
                return st == ArrayUtil.getLastElement((Object[])((GrCodeBlock)parent2).getStatements());
            }
            if (parent2 instanceof GroovyFileBase) {
                return st == ArrayUtil.getLastElement((Object[])((GroovyFileBase)parent2).getStatements());
            }
            if (parent2 instanceof GrForStatement || parent2 instanceof GrIfStatement && st != ((GrIfStatement)parent2).getCondition() || parent2 instanceof GrSynchronizedStatement && st != ((GrSynchronizedStatement)parent2).getMonitor() || parent2 instanceof GrWhileStatement && st != ((GrWhileStatement)parent2).getCondition() || parent2 instanceof GrConditionalExpression && st != ((GrConditionalExpression)parent2).getCondition() || parent2 instanceof GrElvisExpression) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)parent2);
            }
            if (parent2 instanceof GrCaseSection) {
                Object[] statements2 = ((GrCaseSection)parent2).getStatements();
                GrStatement last = (GrStatement)ArrayUtil.getLastElement((Object[])statements2);
                GrSwitchStatement switchStatement = (GrSwitchStatement)parent2.getParent();
                if (last instanceof GrBreakStatement && statements2.length > 1 && statements2[statements2.length - 2] == st) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchStatement);
                }
                if (st == last && (st instanceof GrBreakStatement || ControlFlowBuilderUtil.isLastStatementInCaseSection((GrCaseSection)parent2, switchStatement))) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchStatement);
                }
            }
        }
        return false;
    }

    private static boolean isLastStatementInCaseSection(GrCaseSection caseSection, GrSwitchStatement switchStatement) {
        Object[] sections = switchStatement.getCaseSections();
        int i = ArrayUtilRt.find((Object[])sections, (Object)caseSection);
        if (i == sections.length - 1) {
            return true;
        }
        for (int j = i + 1; j < sections.length; ++j) {
            Object section = sections[j];
            for (GrStatement statement : section.getStatements()) {
                if (statement instanceof GrBreakStatement) continue;
                return false;
            }
        }
        return true;
    }
}

