/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.style.inference.CollectingGroovyInferenceSession;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.MethodInstantiationUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.NameGenerator;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptions;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.CommonDriver;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.EmptyDriver;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriver;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.ParameterizationManager;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.TypeUsageInformation;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceGraphUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitGraph;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitGraphKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"forbiddenAnnotations", "", "", "createDriver", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/InferenceDriver;", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "options", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceOptions;", "runInferenceProcess", "setUpGraph", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraph;", "virtualMethod", "constantTypes", "", "Lcom/intellij/psi/PsiTypeParameter;", "typeUsage", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformation;", "eligibleForExtendedInference", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;", "intellij.groovy"})
public final class InferenceProcessKt {
    private static final Set<String> forbiddenAnnotations = SetsKt.setOf((Object[])new String[]{"groovy.lang.DelegatesTo", "groovy.transform.stc.ClosureParams"});

    @NotNull
    public static final GrMethod runInferenceProcess(@NotNull GrMethod method, @NotNull SignatureInferenceOptions options2) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
        GrMethod originalMethod = InferenceProcessUtilKt.getOriginalMethod(method);
        PsiMethod overridableMethod = InferenceProcessUtilKt.findOverridableMethod(originalMethod);
        if (overridableMethod != null) {
            GrMethod grMethod = InferenceProcessUtilKt.convertToGroovyMethod(overridableMethod);
            if (grMethod == null) {
                grMethod = method;
            }
            return grMethod;
        }
        SignatureInferenceOptions newOptions2 = SignatureInferenceOptions.copy$default(options2, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends PsiReference>>(originalMethod, options2){
            final /* synthetic */ GrMethod $originalMethod;
            final /* synthetic */ SignatureInferenceOptions $options;

            @NotNull
            public final List<PsiReference> invoke() {
                Collection collection = ReferencesSearch.search((PsiElement)this.$originalMethod, (SearchScope)this.$options.getSearchScope()).findAll();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ReferencesSearch.search(\u2026ns.searchScope).findAll()");
                Iterable $this$sortedBy$iv = collection;
                boolean $i$f$sortedBy = false;
                Iterable iterable = $this$sortedBy$iv;
                boolean bl = false;
                Comparator comparator2 = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        PsiReference it = (PsiReference)a;
                        boolean bl2 = false;
                        PsiReference psiReference = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
                        PsiElement psiElement = psiReference.getElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it.element");
                        it = (PsiReference)b;
                        Comparable comparable = Integer.valueOf(psiElement.getTextOffset());
                        bl2 = false;
                        PsiReference psiReference2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiReference2, (String)"it");
                        PsiElement psiElement2 = psiReference2.getElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it.element");
                        Integer n = psiElement2.getTextOffset();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                    }
                };
                return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator2);
            }
            {
                this.$originalMethod = grMethod;
                this.$options = signatureInferenceOptions;
                super(0);
            }
        })), 3, null);
        InferenceDriver driver = InferenceProcessKt.createDriver(originalMethod, newOptions2);
        PsiSubstitutor signatureSubstitutor = InferenceProcessUtilKt.removeForeignTypeParameters(driver.collectSignatureSubstitutor(), method);
        GrMethod grMethod = InferenceProcessUtilKt.createVirtualMethod$default(method, null, 2, null);
        if (grMethod == null) {
            return method;
        }
        GrMethod virtualMethod = grMethod;
        InferenceDriver parameterizedDriver = driver.createParameterizedDriver(new ParameterizationManager(method), virtualMethod, signatureSubstitutor);
        TypeUsageInformation typeUsage = parameterizedDriver.collectInnerConstraints();
        Object[] objectArray = method.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"method.typeParameters");
        InferenceUnitGraph graph = InferenceProcessKt.setUpGraph(virtualMethod, ArraysKt.asList((Object[])objectArray), typeUsage);
        InferenceUnitGraph inferredGraph = InferenceUnitGraphKt.determineDependencies(graph);
        return MethodInstantiationUtilKt.instantiateTypeParameters(parameterizedDriver, inferredGraph, method, typeUsage);
    }

    public static final boolean eligibleForExtendedInference(@NotNull GrParameter $this$eligibleForExtendedInference) {
        Intrinsics.checkParameterIsNotNull((Object)$this$eligibleForExtendedInference, (String)"$this$eligibleForExtendedInference");
        return $this$eligibleForExtendedInference.getTypeElement() == null;
    }

    private static final InferenceDriver createDriver(GrMethod method, SignatureInferenceOptions options2) {
        GrMethod grMethod = InferenceProcessUtilKt.createVirtualMethod$default(method, null, 2, null);
        if (grMethod == null) {
            return EmptyDriver.INSTANCE;
        }
        GrMethod virtualMethod = grMethod;
        NameGenerator generator = new NameGenerator("_START" + method.hashCode(), method);
        return CommonDriver.Companion.createFromMethod(method, virtualMethod, generator, options2);
    }

    private static final InferenceUnitGraph setUpGraph(GrMethod virtualMethod, List<? extends PsiTypeParameter> constantTypes, TypeUsageInformation typeUsage) {
        PsiTypeParameter[] psiTypeParameterArray = virtualMethod.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"virtualMethod.typeParameters");
        CollectingGroovyInferenceSession inferenceSession = new CollectingGroovyInferenceSession(psiTypeParameterArray, virtualMethod, null, null, null, false, null, 0, 252, null);
        typeUsage.fillSession(inferenceSession);
        inferenceSession.infer();
        return InferenceGraphUtilKt.createGraphFromInferenceVariables(inferenceSession, virtualMethod, typeUsage, constantTypes);
    }
}

