/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.actions.NewGroovyActionBase;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class NewGantScriptAction
extends NewGroovyActionBase {
    public NewGantScriptAction() {
        super("Gant Script", "Create new Gant Script", JetgroovyIcons.Groovy.Gant_16x16);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return null;
    }

    @Override
    protected String getDialogPrompt() {
        return "Enter name for new Gant Script";
    }

    @Override
    protected String getDialogTitle() {
        return "New Gant Script";
    }

    @Override
    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && GantUtils.isSDKConfiguredToRun((Module)Objects.requireNonNull(LangDataKeys.MODULE.getData(dataContext)));
    }

    @Override
    protected PsiElement @NotNull [] doCreate(String newName, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray;
        PsiFile file = NewGantScriptAction.createGantScriptFromTemplate(directory, newName, "Gant Script.gant", new String[0]);
        PsiElement lastChild = file.getLastChild();
        PsiElement child = null;
        if (lastChild instanceof GrMethodCallExpression) {
            child = lastChild;
        }
        if (child == null && file.getChildren().length > 0) {
            child = file.getLastChild();
        }
        if (child != null) {
            PsiElement[] psiElementArray2 = new PsiElement[2];
            psiElementArray2[0] = file;
            psiElementArray = psiElementArray2;
            psiElementArray2[1] = child;
        } else {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = file;
        }
        if (psiElementArray == null) {
            NewGantScriptAction.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    private static PsiFile createGantScriptFromTemplate(PsiDirectory directory, String className, String templateName, String ... parameters2) throws IncorrectOperationException {
        return GroovyTemplatesFactory.createFromTemplate(directory, className, className + "." + "gant", templateName, true, parameters2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/NewGantScriptAction", "doCreate"));
    }
}

