/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.extensions.GroovyUnresolvedHighlightFilter;
import org.jetbrains.plugins.groovy.findUsages.MissingMethodAndPropertyUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.transformations.impl.GroovyObjectTransformationSupport;

public class GrUnresolvedAccessChecker {
    public static final Logger LOG = Logger.getInstance(GrUnresolvedAccessChecker.class);

    static boolean areMissingMethodsDeclared(GrReferenceExpression ref) {
        PsiType qualifierType = PsiImplUtil.getQualifierType(ref);
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)qualifierType).resolve();
        if (resolved == null) {
            return false;
        }
        if (ref.getParent() instanceof GrCall) {
            PsiMethod[] found;
            for (PsiMethod method : found = resolved.findMethodsByName("methodMissing", true)) {
                if (!MissingMethodAndPropertyUtil.isMethodMissing(method)) continue;
                return true;
            }
        } else {
            PsiMethod[] found;
            for (PsiMethod method : found = resolved.findMethodsByName("propertyMissing", true)) {
                if (!MissingMethodAndPropertyUtil.isPropertyMissing(method)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean areGroovyObjectMethodsOverridden(GrReferenceExpression ref) {
        PsiMethod patternMethod = GrUnresolvedAccessChecker.findPatternMethod(ref);
        if (patternMethod == null) {
            return false;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier != null) {
            return GrUnresolvedAccessChecker.checkGroovyObjectMethodsByQualifier(ref, patternMethod);
        }
        return GrUnresolvedAccessChecker.checkMethodInPlace(ref, patternMethod);
    }

    private static boolean checkMethodInPlace(GrReferenceExpression ref, PsiMethod patternMethod) {
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{GrClosableBlock.class, PsiMember.class, PsiFile.class});
        assert (container != null);
        return GrUnresolvedAccessChecker.checkContainer(patternMethod, container);
    }

    private static boolean checkContainer(@NotNull PsiMethod patternMethod, @NotNull PsiElement container) {
        if (patternMethod == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(0);
        }
        if (container == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(1);
        }
        String name = patternMethod.getName();
        Map cached = (Map)CachedValuesManager.getCachedValue((PsiElement)container, () -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        Boolean cachedResult = (Boolean)cached.get(name);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result2 = GrUnresolvedAccessChecker.doCheckContainer(patternMethod, container, name);
        cached.put(name, result2);
        return result2;
    }

    private static boolean doCheckContainer(final PsiMethod patternMethod, PsiElement container, final String name) {
        final Ref result2 = new Ref((Object)false);
        GrScopeProcessorWithHints processor = new GrScopeProcessorWithHints(name, ClassHint.RESOLVE_KINDS_METHOD){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof PsiMethod && name.equals(((PsiMethod)element).getName()) && patternMethod.getParameterList().getParametersCount() == ((PsiMethod)element).getParameterList().getParametersCount() && GrUnresolvedAccessChecker.isNotFromGroovyObject((PsiMethod)element)) {
                    result2.set((Object)true);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessChecker$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ResolveUtil.treeWalkUp(container, processor, true);
        return (Boolean)result2.get();
    }

    private static boolean checkGroovyObjectMethodsByQualifier(GrReferenceExpression ref, PsiMethod patternMethod) {
        PsiType qualifierType = PsiImplUtil.getQualifierType(ref);
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)qualifierType).resolve();
        if (resolved == null) {
            return false;
        }
        PsiMethod found = resolved.findMethodBySignature(patternMethod, true);
        if (found == null) {
            return false;
        }
        return GrUnresolvedAccessChecker.isNotFromGroovyObject(found);
    }

    private static boolean isNotFromGroovyObject(@NotNull PsiMethod found) {
        if (found == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(2);
        }
        if (GroovyObjectTransformationSupport.isGroovyObjectSupportMethod(found)) {
            return false;
        }
        PsiClass aClass = found.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        if ("groovy.lang.GroovyObject".equals(qname)) {
            return false;
        }
        return !"groovy.lang.GroovyObjectSupport".equals(qname);
    }

    @Nullable
    private static PsiMethod findPatternMethod(@NotNull GrReferenceExpression ref) {
        PsiClass groovyObject;
        if (ref == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(3);
        }
        if ((groovyObject = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("groovy.lang.GroovyObject", ref.getResolveScope())) == null) {
            return null;
        }
        String methodName = ref.getParent() instanceof GrCall ? "invokeMethod" : (PsiUtil.isLValue(ref) ? "setProperty" : "getProperty");
        PsiMethod[] patternMethods = groovyObject.findMethodsByName(methodName, false);
        if (patternMethods.length != 1) {
            return null;
        }
        return patternMethods[0];
    }

    static boolean isStaticOk(GroovyResolveResult resolveResult2) {
        if (resolveResult2.isStaticsOK()) {
            return true;
        }
        PsiElement resolved = resolveResult2.getElement();
        LOG.assertTrue(resolved != null);
        LOG.assertTrue(resolved instanceof PsiModifierListOwner, (Object)(resolved + " : " + resolved.getText()));
        return ((PsiModifierListOwner)resolved).hasModifierProperty("static");
    }

    static boolean shouldHighlightAsUnresolved(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            GrUnresolvedAccessChecker.$$$reportNull$$$0(4);
        }
        if (GrHighlightUtil.isDeclarationAssignment(referenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)referenceExpression.getQualifier();
        if (qualifier != null && qualifier.getType() == null && !GrUnresolvedAccessChecker.isRefToPackage(qualifier)) {
            return false;
        }
        if (qualifier != null && referenceExpression.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER && referenceExpression.multiResolve(false).length > 0) {
            return false;
        }
        if (PsiUtilKt.isFake(referenceExpression)) {
            return false;
        }
        if (!GroovyUnresolvedHighlightFilter.shouldHighlight(referenceExpression)) {
            return false;
        }
        CollectConsumer consumer = new CollectConsumer();
        for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
            searcher.findDeclarationsAt((PsiElement)referenceExpression, 0, (Consumer)consumer);
            if (consumer.getResult().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isRefToPackage(GrExpression expr) {
        return expr instanceof GrReferenceExpression && ((GrReferenceExpression)expr).resolve() instanceof PsiPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "found";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContainer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotFromGroovyObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPatternMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightAsUnresolved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

