/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyEmptyFinallyBlockInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Empty '#ref' block #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitFinallyClause(@NotNull GrFinallyClause finallyClause) {
            if (finallyClause == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitFinallyClause(finallyClause);
            GrOpenBlock body = finallyClause.getBody();
            if (body == null || !Visitor.isEmpty(body)) {
                return;
            }
            this.registerError(finallyClause.getFirstChild());
        }

        private static boolean isEmpty(GrOpenBlock body) {
            GrStatement[] statements2 = body.getStatements();
            return statements2.length == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyClause", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyEmptyFinallyBlockInspection$Visitor", "visitFinallyClause"));
        }
    }
}

