/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class AddMethodFix
extends GroovyFix {
    private static final Logger LOG = Logger.getInstance(AddMethodFix.class);
    private final String myMethodName;
    private final String myClassName;
    private final SmartPsiElementPointer<GrTypeDefinition> myPsiClassPointer;

    public AddMethodFix(@NotNull String methodName, @NotNull GrTypeDefinition aClass) {
        if (methodName == null) {
            AddMethodFix.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            AddMethodFix.$$$reportNull$$$0(1);
        }
        this.myMethodName = methodName;
        this.myClassName = aClass.getName();
        this.myPsiClassPointer = PointersKt.createSmartPointer((PsiElement)aClass);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        GrTypeDefinition psiClass;
        if (project == null) {
            AddMethodFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            AddMethodFix.$$$reportNull$$$0(3);
        }
        if ((psiClass = (GrTypeDefinition)this.myPsiClassPointer.getElement()) == null) {
            return;
        }
        if (psiClass.isInterface()) {
            GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("def " + psiClass.getName() + " " + this.myMethodName + "();");
            psiClass.add(method);
        } else {
            String templName = "Implemented Method Body.java";
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getCodeTemplate(templName);
            Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            String returnType2 = AddMethodFix.generateTypeText(psiClass);
            properties.setProperty("RETURN_TYPE", returnType2);
            properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)JavaPsiFacade.getElementFactory((Project)project).createType((PsiClass)psiClass)));
            properties.setProperty("CALL_SUPER", "");
            properties.setProperty("CLASS_NAME", psiClass.getQualifiedName());
            properties.setProperty("SIMPLE_CLASS_NAME", psiClass.getName());
            properties.setProperty("METHOD_NAME", this.myMethodName);
            try {
                String bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
                GrCodeBlock newBody = GroovyPsiElementFactory.getInstance(project).createMethodBodyFromText("\n" + bodyText + "\n");
                GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText("", this.myMethodName, returnType2, ArrayUtilRt.EMPTY_STRING_ARRAY, psiClass);
                method.setBlock(newBody);
                psiClass.add(method);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public String getName() {
        String string = GroovyInspectionBundle.message("add.method", this.myMethodName, this.myClassName);
        if (string == null) {
            AddMethodFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Add method";
    }

    static String generateTypeText(GrTypeDefinition aClass) {
        String className = aClass.getName();
        LOG.assertTrue(className != null, (Object)aClass);
        StringBuilder returnType2 = new StringBuilder(className);
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            returnType2.append('<');
            for (PsiTypeParameter typeParameter : typeParameters) {
                returnType2.append(typeParameter.getName()).append(", ");
            }
            returnType2.replace(returnType2.length() - 2, returnType2.length(), ">");
        }
        return returnType2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/AddMethodFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/AddMethodFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

