/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyAssignmentToForLoopParameterInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Assignment to for-loop parameter '#ref' #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression grAssignmentExpression) {
            if (grAssignmentExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(grAssignmentExpression);
            GrExpression lhs = grAssignmentExpression.getLValue();
            if (!(lhs instanceof GrReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)lhs).resolve();
            if (referent == null) {
                return;
            }
            if (!(referent instanceof GrParameter)) {
                return;
            }
            PsiElement parent2 = referent.getParent();
            if (!(parent2 instanceof GrForClause)) {
                return;
            }
            if (parent2 instanceof GrTraditionalForClause && PsiTreeUtil.isAncestor((PsiElement)parent2, (PsiElement)grAssignmentExpression, (boolean)true)) {
                return;
            }
            this.registerError(lhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grAssignmentExpression", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignmentToForLoopParameterInspection$Visitor", "visitAssignmentExpression"));
        }
    }
}

