/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/checkers/NamedParamAnnotationChecker;", "Lorg/jetbrains/plugins/groovy/annotator/checkers/CustomAnnotationChecker;", "()V", "checkArgumentList", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "intellij.groovy.psi"})
public final class NamedParamAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        Pair.NonNull<PsiElement, String> r;
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        if (Intrinsics.areEqual((Object)"groovy.transform.NamedParam", (Object)annotation.getQualifiedName()) ^ true) {
            return false;
        }
        PsiClass psiClass = ResolveUtil.resolveAnnotation(annotation);
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"ResolveUtil.resolveAnnot\u2026notation) ?: return false");
        PsiClass annotationClass = psiClass;
        PsiElement psiElement = annotation.getClassReference();
        GrAnnotationArgumentList grAnnotationArgumentList = annotation.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)grAnnotationArgumentList, (String)"annotation.parameterList");
        Pair.NonNull<PsiElement, String> nonNull = r = CustomAnnotationChecker.checkAnnotationArguments(annotationClass, psiElement, grAnnotationArgumentList.getAttributes(), false);
        if ((nonNull != null ? (PsiElement)nonNull.getFirst() : null) != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, (String)r.second).range((PsiElement)r.first).create();
        }
        return true;
    }
}

