/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gradle.internal.impldep.org.testng.collections.Lists;
import org.gradle.internal.impldep.org.testng.collections.Maps;
import org.gradle.internal.impldep.org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolService<KeyType, FutureType> {
    private static PoolService m_instance;
    private ExecutorService m_service;
    private HashMap<KeyType, List<Future<FutureType>>> m_futureMap;
    private Thread m_listenerThread;
    private Map<KeyType, PoolListener<KeyType, FutureType>> m_listeners;

    private PoolService(int threadPoolSize) {
        m_instance = this;
        this.m_service = Executors.newFixedThreadPool(threadPoolSize);
        this.m_futureMap = new HashMap();
        this.m_listeners = Maps.newHashMap();
        this.m_listenerThread = new Thread(){

            public void run() {
                System.out.println("Listener thread starting, futures:" + PoolService.this.m_futureMap.size());
                while (PoolService.this.m_futureMap.size() > 0) {
                    List doneFutures = Lists.newArrayList();
                    for (Object key : PoolService.this.m_futureMap.keySet()) {
                        List futures = (List)PoolService.this.m_futureMap.get(key);
                        if (!PoolService.this.isFinished(futures)) continue;
                        PoolListener listener = (PoolListener)PoolService.this.m_listeners.get(key);
                        if (listener != null) {
                            listener.onFinish(key, futures);
                        }
                        PoolService.this.m_listeners.remove(key);
                        doneFutures.add(key);
                    }
                    for (Object key : doneFutures) {
                        PoolService.this.m_futureMap.remove(key);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("Listener thread ending");
            }
        };
    }

    public static void initialize(int threadCount) {
        m_instance = new PoolService(threadCount);
    }

    public static PoolService getInstance() {
        if (m_instance == null) {
            throw new RuntimeException("The Service Pool was not created, should never happen");
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FutureType> submitTasksAndWait(KeyType key, List<Callable<FutureType>> tasks) {
        List result = Lists.newArrayList();
        this.submitTasks(key, tasks, null);
        List<Future<FutureType>> futures = null;
        HashMap<KeyType, List<Future<FutureType>>> hashMap = this.m_futureMap;
        synchronized (hashMap) {
            futures = this.m_futureMap.get(key);
            if (futures != null) {
                while (!this.isFinished(futures)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                for (Future<FutureType> future : futures) {
                    try {
                        if (future == null) continue;
                        result.add(future.get());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTasks(KeyType key, List<Callable<FutureType>> tasks, PoolListener<KeyType, FutureType> listener) {
        for (Callable<FutureType> task : tasks) {
            Future<FutureType> future = this.m_service.submit(task);
            HashMap<KeyType, List<Future<FutureType>>> hashMap = this.m_futureMap;
            synchronized (hashMap) {
                List<Future<Object>> list = this.m_futureMap.get(key);
                if (list == null) {
                    list = Lists.newArrayList();
                    this.m_futureMap.put(key, list);
                }
                list.add(future);
            }
        }
        if (listener != null) {
            this.m_listeners.put(key, listener);
            if (!this.m_listenerThread.isAlive()) {
                this.m_listenerThread.start();
            }
        }
    }

    private boolean isFinished(List<Future<FutureType>> futures) {
        for (Future<FutureType> f : futures) {
            if (f == null || f.isDone()) continue;
            return false;
        }
        return true;
    }

    public void shutdown() {
        Utils.log(this.getClass().getName(), 3, "Shutting down poolservice " + this + " terminated:" + this.m_service.isTerminated());
        this.m_service.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PoolListener<KeyType, FutureType> {
        public void onFinish(KeyType var1, List<Future<FutureType>> var2);
    }
}

